// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ENPC
// 
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt

function Makename=ilib_gen_Make(name,tables,files,libs,makename,with_gateway,ldflags,cflags,fflags,cc)
// flag 'c' or 'f' used with lcc 
//------------------------------------
// generate a Makefile for gateway

  if argn(2)<6 then with_gateway=%t,ldflags='',cflags='',fflags='', cc='';end
  for i=1:size(files,'*') // compatibility scilab 4.x
    [path_f, file_f, ext_f] = fileparts(files(i));
    if or(ext_f == ['.o','.obj']) then
      files(i) = path_f + file_f;
    else
      files(i) = path_f + file_f + ext_f;
    end
  end
  
  // change table if necessary 
  if typeof(tables)<>'list' then 
    tables= list(tables)
  end
  L=length(tables); 
  for it = 1:L 
    table = tables(it);
    [mt,nt]=size(table);
	
	if nt==2 then 
	  col= "csci";  // @TODO what is csci
	  table = [table, col(ones(mt,1))];
	  nt=3; 
	end 
	
	if nt<>3 then 
	  error(msprintf(gettext("%s: Wrong size for input argument #%d.\n"),"ilib_gen_Make",2));
	end 
	
	tables(it)=table;
  end
      
  comp_target = COMPILER;
  if with_lcc() == %T then
  	Makename = makename+'.lcc'
  	ilib_gen_Make_lcc(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags,'c')
  else if getenv('WIN32','NO')=='OK' then
    select comp_target
     case 'VC++'   then Makename = makename+'.mak'
      ilib_gen_Make_win32(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
     case 'gcc' then 
      Makename = makename;
      ilib_gen_Make_unix(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags,cc)
    else
       Makename = makename;
       ilib_gen_Make_win32(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
    end
  else
     Makename = makename;
     ilib_gen_Make_unix(name,files,libs,name,ldflags,cflags,fflags,cc)
  end
  end
endfunction


function ilib_gen_Make_win32(name,table,files,libs,Makename,with_gateway,ldflags,cflags,fflags)

  managed_ext = ['.f90','.cxx','.cpp','.c','.f'];
  for i=1:size(files,'*') // compatibility scilab 4.x
    [path_f, file_f, ext_f] = fileparts(files(i));
    if or(managed_ext == ext_f) then
      files(i) = path_f + file_f;
    else
      files(i) = path_f + file_f + ext_f;
    end
  end

  fd=mopen(Makename,"w");
  mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------\n");
  mfprintf(fd,"SHELL = /bin/sh\n");
  mfprintf(fd,"SCIDIR =%s\n",SCI);
  mfprintf(fd,"SCIDIR1 =%s\n",pathconvert(SCI,%f,%f,'w'));
  mfprintf(fd,"# name of the dll to be built\n"); 
  mfprintf(fd,"LIBRARY = %s\n",name);
  mfprintf(fd,"# list of objects file\n");
  mfprintf(fd,"OBJS =");
  for x=files(:)' ; mfprintf(fd," %s.obj",x);end

  if typeof(tables)<>'list' then 
    tables= list(tables)
  end
  L=length(tables); 

  if with_gateway then 
    if L==1 then 
      mfprintf(fd," %s.obj",name);
    else
       for i=1:L , mfprintf(fd," %s.obj",name+string(i));end 
    end
  end
  
  for it=1:L 
    table = tables(it)
    [mt,nt]=size(table);
 
    for i=1:mt ; 
      // mex files to be added 
      if table(i,3)=='cmex' | table(i,3)=='fmex' | table(i,3)=='Fmex' 
	mfprintf(fd," %s.obj",table(i,2));
      end
    end
  end
  mfprintf(fd,"\n# added libraries \n");
  mfprintf(fd,"OTHERLIBS = ");
  for x=libs(:)' ; mfprintf(fd," %s.lib",x);end
  mfprintf(fd,"\n");
  mfprintf(fd,"!include $(SCIDIR1)\\Makefile.incl.mak\n");
  
  mexcflags = ' ';
  mexfflags = ' ';
  
  if table(i,3)=='cmex' | table(i,3)=='fmex' | table(i,3)=='Fmex' then
    if findmsvccompiler() <>'msvc90express' then
      mexcflags = " -Dmexfunction_=mex$*_  -DmexFunction=mex_$* ";
      mexfflags = " -Dmexfunction=mex$* ";
    end
  end
  mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/modules/core/includes\"""+...
	   mexcflags + cflags +" \n"); 
  mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/modules/core/includes\"""+...
	   mexfflags + fflags +"\n"); 
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+"\n");
  mfprintf(fd,"!include $(SCIDIR1)\\modules\\dynamic_link\\src\\scripts\\Makedll.incl \n");
  mclose(fd);
endfunction
//---------------------------------------------------------------------------------------
         
function ilib_gen_Make_lcc(name,table,files,libs,Makename,with_gateway,ldflags,cflags,fflags,flag)
// Allan CORNET
//INRIA 2004

  managed_ext = ['.cxx','.cpp','.c','.f'];
  for i=1:size(files,'*') // compatibility scilab 4.x
    [path_f, file_f, ext_f] = fileparts(files(i));
    if or(managed_ext == ext_f) then
      files(i) = path_f + file_f;
    else
      files(i) = path_f + file_f + ext_f;
    end
  end
  
  if with_module('scicos') then
    scicoslib = '$(LCCLIBDIR)\\scicoslcc.lib $(LCCLIBDIR)\\scicos_flcc.lib $(LCCLIBDIR)\\scicos_blockslcc.lib  $(LCCLIBDIR)\\scicos_blocks_flcc.lib';
  else
    scicoslib = '';
  end

  fd=mopen(Makename,"w");
  mfprintf(fd,"# ------------------------------------------------------------\n");
  mfprintf(fd,"# generated by builder.sce (lcc 1): Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------------\n\n");
  mfprintf(fd,"SCIDIR =%s\n",SCI);
  mfprintf(fd,"LCCLIBDIR =%s\n",getshortpathname(SCIHOME+filesep()+'lcclib'));
  mfprintf(fd,"SCIDIR1 =%s\n",pathconvert(SCI,%f,%f,'w'));
  mfprintf(fd,"DUMPEXTS=""$(SCIDIR1)\\bin\\dumpexts""\n");
 	mfprintf(fd,"SCIIMPLIB=$(LCCLIBDIR)\\LibScilablcc.lib $(LCCLIBDIR)\\blaspluslcc.lib $(LCCLIBDIR)\\libf2clcc.lib $(LCCLIBDIR)\\interscilcc.lib $(LCCLIBDIR)\\lapacklcc.lib " + scicoslib +"\n\n");
  mfprintf(fd,"CC=lcc\n");
  mfprintf(fd,"LINKER=lcclnk\n");
  mfprintf(fd,"CFLAGS= -ansic msvcrt.lib -I""$(SCIDIR)/modules/core/includes"" -I""$(SCIDIR)/modules/output_stream/includes"" -I""$(SCIDIR)/libs/f2c"" -I""$(SCIDIR)/modules/mexlib/includes"" -Dmexfunction_=mex$*_ -DmexFunction=mex_$* -DWIN32 -DSTRICT -DFORDLL -D__STDC__ "+ cflags +" \n"); 
  mfprintf(fd,"LINKER_FLAGS=-dll -nounderscores\n");
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+"\n");
  mfprintf(fd,"O=.obj\n");
 
  mfprintf(fd,"# name of the dll to be built\n"); 
  mfprintf(fd,"LIBRARY = %s\n",name);
  mfprintf(fd,"# list of objects file\n");
  mfprintf(fd,"OBJS =");
  for x=files(:)' ; mfprintf(fd," %s$(O)",x);end

  if typeof(table)<>'list' then 
    tables= list(table)
  end
  
  L=length(table); 

  if with_gateway then 
    if L==1 then 
      mfprintf(fd," %s$(O)",name);
    else
       for i=1:L , mfprintf(fd," %s$(O)",name+string(i));end 
    end
  end
  
  for it=1:L 
    table = tables(it)
    [mt,nt]=size(table);
 
    for i=1:mt ; 
      // mex files to be added 
      if table(i,3)=='cmex' | table(i,3)=='fmex' | table(i,3)=='Fmex' 
	mfprintf(fd," %s$(O)",table(i,2));
      end
    end
  end
  
  
  mfprintf(fd,"\n\n# added libraries \n");
  mfprintf(fd,"OTHERLIBS =");
  
  for x=libs(:)' ; mfprintf(fd," %s.lib",x);end
  mfprintf(fd,"\n");
  
  mfprintf(fd,"\n");
  
  mfprintf(fd,"\nall :: $(LIBRARY).dll\n");
  mfprintf(fd,"\n$(LIBRARY).dll: $(OBJS)\n");
  mfprintf(fd,"\t"+"$(DUMPEXTS) -o ""$(LIBRARY).def"" ""$*"" $(OBJS)\n");
  mfprintf(fd,"\t"+"$(LINKER) $(LINKER_FLAGS) $(OBJS) $(OTHERLIBS) $(SCIIMPLIB) $(XLIBSBIN) $(TERMCAPLIB) $(EXTRA_LDFLAGS) $*.def -o $(LIBRARY).dll\n\n");

  for x=files(:)' ;
    managed_ext_obj = ['.obj','.o'];
    [path_f, file_f, ext_f] = fileparts(x);
    if or(managed_ext == ext_f) then
      files(i) = path_f + file_f;
    else
      files(i) = path_f + file_f + ext_f;
    end
  	mfprintf(fd,"%s$(O):\n",x);
  	mfprintf(fd,"\t"+"$(CC) $(CFLAGS) $*.c\n\n");
  end

  if with_gateway then 
    if L==1 then 
      mfprintf(fd,"\n%s$(O):\n",name);
      mfprintf(fd,"\t"+"$(CC) $(CFLAGS) $*.c\n");
    else
       for i=1:L ;
       mfprintf(fd,"\n%s$(O):\n",name+string(i));
       mfprintf(fd,"\t"+"$(CC) $(CFLAGS) $*.c\n");
       end 
    end
  end
  
  mfprintf(fd,"\nclean:\n");
  mfprintf(fd,"\t"+"del *.obj\n");
  mfprintf(fd,"\t"+"del *.dll\n");
  mfprintf(fd,"\t"+"del *.lib\n");
  mfprintf(fd,"\t"+"del *.def\n");
 
 mclose(fd);

endfunction
//---------------------------------------------------------------------------------------
