// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Vincent COUVERT
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- Non-regression test for bug 3303 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=3303
//
// <-- Short Description -->
// Shambolic error management or parsing in slave Tcl interpreters

// First command executed in main interpreter
ierr = execstr("TCL_EvalStr(""wrongcommand"");", "errcatch");
assert_checkequal(ierr, 999);
msg = lasterror();
msgref = ["TCL_EvalStr,  at line 1" ; ..
ascii(9)+ "invalid command name ""wrongcommand""" ; ..
"    while executing" ; ..
"""wrongcommand"""];
assert_checkequal(msg, msgref);

TCL_CreateSlave("slave");

// Command executed in slave: error message returned must not depend on previous error in main
ierr = execstr("TCL_EvalStr(""wrongcommandinslave"",""slave"")", "errcatch");
assert_checkequal(ierr, 999);
msg = lasterror();
msgref = ["TCL_EvalStr, invalid command name ""wrongcommandinslave"" at line 1" ; ..
ascii(9) + "invalid command name ""wrongcommandinslave""" ; ..
"    while executing" ; ..
"""wrongcommandinslave"""];
assert_checkequal(msg, msgref);

// Second command executed in main interpreter
ierr = execstr("TCL_EvalStr(""wrongcommand2"");", "errcatch");
assert_checkequal(ierr, 999);
msg = lasterror();
msgref = ["TCL_EvalStr,  at line 1" ; ..
ascii(9) + "invalid command name ""wrongcommand2""" ; ..
"    while executing" ; ..
"""wrongcommand2"""];
assert_checkequal(msg, msgref);

// Command executed again in slave: must give the same error message
ierr = execstr("TCL_EvalStr(""wrongcommandinslave"",""slave"")", "errcatch");
msg = lasterror();
msgref = ["TCL_EvalStr, invalid command name ""wrongcommandinslave"" at line 1" ; ..
ascii(9) + "invalid command name ""wrongcommandinslave""" ; ..
"    while executing" ; ..
"""wrongcommandinslave"""];
assert_checkequal(msg, msgref);
