/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGEAGENTPANELCLIENT_H
#define SCIMBRIDGEAGENTPANELCLIENT_H

#define Uses_SCIM_EVENT
#define Uses_SCIM_PANEL_CLIENT
#define Uses_SCIM_SIGNAL
#define Uses_SCIM_SOCKET
#define Uses_SCIM_TRANSACTION
#define Uses_SCIM_TRANS_COMMANDS

#include <scim.h>

#include "scim-bridge.h"
#include "scim-bridge-display.h"
#include "scim-bridge-imcontext.h"

typedef scim::Slot1<void, int> ScimBridgeAgentPanelClientSlotVoid;
typedef scim::Slot2<void, int, int> ScimBridgeAgentPanelClientSlotInt;
typedef scim::Slot2<void, int, const scim::String&> ScimBridgeAgentPanelClientSlotString;
typedef scim::Slot2<void, int, const scim::WideString&> ScimBridgeAgentPanelClientSlotWideString;
typedef scim::Slot4<void, int, const scim::String&, const scim::String&, const scim::Transaction&> ScimBridgeAgentPanelClientSlotStringStringTransaction;
typedef scim::Slot2<void, int, const scim::KeyEvent&> ScimBridgeAgentPanelClientSlotKeyEvent;

class ScimBridgeAgentPanelClient
{

    public:

        static ScimBridgeAgentPanelClient *alloc (const scim::String &config, const ScimBridgeDisplay *display);

        virtual ~ScimBridgeAgentPanelClient ();

        virtual int open_connection () = 0;
        virtual void close_connection () = 0;
        virtual int get_connection_number () const = 0;
        virtual bool is_connected () const = 0;

        virtual bool has_pending_event () const = 0;
        virtual retval_t filter_event () = 0;

        virtual retval_t prepare (scim_bridge_imcontext_id_t imcontext_id) = 0;
        virtual retval_t send () = 0;

        virtual void turn_on () = 0;
        virtual void turn_off () = 0;
        virtual void update_screen () = 0;
        virtual void show_help (const scim::String &help) = 0;
        virtual void show_factory_menu (const std::vector<scim::PanelFactoryInfo> &menu) = 0;
        virtual void focus_in (const scim::String &uuid) = 0;
        virtual void focus_out () = 0;
        virtual void update_factory_info (const scim::PanelFactoryInfo &info) = 0;
        virtual void update_spot_location (int x, int y) = 0;
        virtual void show_preedit_string () = 0;
        virtual void show_aux_string () = 0;
        virtual void show_lookup_table () = 0;
        virtual void hide_preedit_string () = 0;
        virtual void hide_aux_string () = 0;
        virtual void hide_lookup_table () = 0;
        virtual void update_preedit_string (const scim::WideString &str, const scim::AttributeList &attrs) = 0;
        virtual void update_preedit_caret (int cursor_position) = 0;
        virtual void update_aux_string (const scim::WideString &str, const scim::AttributeList &attrs) = 0;
        virtual void update_lookup_table (const scim::LookupTable &table) = 0;
        virtual void register_properties (const scim::PropertyList &properties) = 0;
        virtual void update_property (const scim::Property &property) = 0;
        virtual void start_helper (const scim::String &helper_uuid) = 0;
        virtual void stop_helper (const scim::String &helper_uuid) = 0;
        virtual void send_helper_event (const scim::String &helper_uuid, const scim::Transaction &trans) = 0;
        virtual void register_input_context (const scim::String &uuid) = 0;
        virtual void remove_input_context () = 0;

        virtual scim::Connection signal_connect_reload_config (ScimBridgeAgentPanelClientSlotVoid *slot) = 0;
        virtual scim::Connection signal_connect_exit (ScimBridgeAgentPanelClientSlotVoid *slot) = 0;
        virtual scim::Connection signal_connect_update_lookup_table_page_size (ScimBridgeAgentPanelClientSlotInt *slot) = 0;
        virtual scim::Connection signal_connect_lookup_table_page_up (ScimBridgeAgentPanelClientSlotVoid *slot) = 0;
        virtual scim::Connection signal_connect_lookup_table_page_down (ScimBridgeAgentPanelClientSlotVoid *slot) = 0;
        virtual scim::Connection signal_connect_trigger_property (ScimBridgeAgentPanelClientSlotString *slot) = 0;
        virtual scim::Connection signal_connect_process_helper_event (ScimBridgeAgentPanelClientSlotStringStringTransaction *slot) = 0;
        virtual scim::Connection signal_connect_move_preedit_caret (ScimBridgeAgentPanelClientSlotInt *slot) = 0;
        virtual scim::Connection signal_connect_select_candidate (ScimBridgeAgentPanelClientSlotInt *slot) = 0;
        virtual scim::Connection signal_connect_process_key_event (ScimBridgeAgentPanelClientSlotKeyEvent *slot) = 0;
        virtual scim::Connection signal_connect_commit_string (ScimBridgeAgentPanelClientSlotWideString *slot) = 0;
        virtual scim::Connection signal_connect_forward_key_event (ScimBridgeAgentPanelClientSlotKeyEvent *slot) = 0;
        virtual scim::Connection signal_connect_request_help (ScimBridgeAgentPanelClientSlotVoid *slot) = 0;
        virtual scim::Connection signal_connect_request_factory_menu (ScimBridgeAgentPanelClientSlotVoid *slot) = 0;
        virtual scim::Connection signal_connect_change_factory (ScimBridgeAgentPanelClientSlotString *slot) = 0;

    protected:

        ScimBridgeAgentPanelClient ();
};
#endif                                            /*SCIMBRIDGEAGENTPANELCLIENT_H*/
