/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation and 
 * appearing in the file LICENSE.LGPL included in the package of this file.
 * You can also redistribute it and/or modify it under the terms of 
 * the GNU General Public License as published by the Free Software Foundation and 
 * appearing in the file LICENSE.GPL included in the package of this file.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <assert.h>

#include <qinputcontextplugin.h>

#include "scim-bridge.h"
#include "scim-bridge-client-imcontext-qt.h"
#include "scim-bridge-client-qt.h"

/* Static Variables */
static ScimBridgeClientQt *client = NULL;


/* The class Definition */
class ScimBridgeInputContextPlugin: public QInputContextPlugin 
{

    public:

        ScimBridgeInputContextPlugin ();

        ~ScimBridgeInputContextPlugin ();

        QStringList keys () const;

        QStringList languages (const QString &key);

        QString description (const QString &key);
        
        QInputContext *create (const QString &key);

        QString displayName (const QString &key);

};


/* Implementations */
ScimBridgeInputContextPlugin::ScimBridgeInputContextPlugin ()
{
}


ScimBridgeInputContextPlugin::~ScimBridgeInputContextPlugin () {
    delete client;
    client = NULL;
}


QStringList ScimBridgeInputContextPlugin::keys () const {
    QStringList keylist;
    keylist.push_back ("scim-bridge");
    return keylist;
}


QStringList ScimBridgeInputContextPlugin::languages (const QString &key) {
    QStringList lang_list;
    lang_list.push_back ("zh_CN");
    lang_list.push_back ("zh_TW");
    lang_list.push_back ("zh_HK");
    lang_list.push_back ("ja");
    lang_list.push_back ("ko");
    return lang_list;
}


QString ScimBridgeInputContextPlugin::description (const QString &key) {
    return QString::fromUtf8 ("Qt immodule plugin for SCIM Bridge");
}


QInputContext *ScimBridgeInputContextPlugin::create (const QString &key) {
    if (key.lower () != "scim-bridge") {
        return NULL;
    } else {
        if (client == NULL) client = new ScimBridgeClientQt ();
        return ScimBridgeClientIMContext::alloc ();
    }
}


QString ScimBridgeInputContextPlugin::displayName (const QString &key) {
    return key;
}


Q_EXPORT_PLUGIN (ScimBridgeInputContextPlugin)
