# -*- coding: utf-8 -*-
# vim: set noet ts=4:
#
# scim-python
#
# Copyright (c) 2008-2008 Yu Yuwei <acevery@gmail.com>
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA
#
# $Id: $
#

from glob import glob
from os import path

factorys = []

def get_factorys (config):

	global factorys
	wildcast = path.join (path.dirname (__file__), "tables/*.db")

	if len (factorys) == 0:
		import XingMa
		for db in [name for name in glob (wildcast) if path.isfile (name)]:
			try:
				factorys.append (XingMa.Factory (config,db))
			except:
				import traceback
				traceback.print_exc ()

	return factorys


