/** @file scim_socket_server.h
 * definition of SocketServerFactory related classes.
 */

/* 
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_socket_server.h,v 1.6 2003/08/14 11:45:18 suzhe Exp $
 */

#if !defined (__SCIM_SOCKET_SERVER_H)
#define __SCIM_SOCKET_SERVER_H

using namespace scim;

class SocketServerFactory : public ServerFactoryBase
{
    WideString m_name;

    String     m_peer_uuid;

    String     m_icon_file;

    bool       m_ok;

    bool       m_icon_file_should_delete;

    friend class SocketServerInstance;

private:
    static SocketClient  m_socket_client;
    static SocketAddress m_socket_address;
    static uint32        m_socket_magic_key;
    static int           m_socket_timeout;
    static volatile int  m_socket_lock;

    static std::vector<String> m_peer_server_factories;

public:
    static bool create_connection ();
    static unsigned int init_global (const ConfigPointer &config);
    static void destroy_global ();

    static unsigned int number_of_server_factories ();
    static SocketServerFactory * create_server_factory (unsigned int server);

private:
    static void init_transaction (SocketTransaction &trans);
    static bool send_transaction (SocketTransaction &trans);
    static bool receive_transaction (SocketTransaction &trans);

    static bool lock_socket_client ();
    static bool unlock_socket_client ();

public:
    SocketServerFactory (const String &peer_uuid);

    bool valid () const { return m_ok; }

    virtual ~SocketServerFactory ();

    virtual WideString  get_name () const;
    virtual WideString  get_authors () const;
    virtual WideString  get_credits () const;
    virtual WideString  get_help () const;
    virtual String      get_uuid () const;
    virtual String      get_icon_file () const;

    virtual ServerInstancePointer create_server_instance (const String& encoding, int id = -1);

private:
    void init_icon_file ();
};

class SocketServerInstance : public ServerInstanceBase
{
    int               m_peer_id;

public:
    SocketServerInstance (SocketServerFactory *factory, const String& encoding, int id, int peer_id);
    virtual ~SocketServerInstance ();

    virtual bool process_key_event (const KeyEvent& key);
    virtual void move_preedit_caret (unsigned int pos);
    virtual void select_lookup_table (unsigned int item);
    virtual void update_lookup_table_page_size (unsigned int page_size);
    virtual void reset ();
    virtual void focus_in ();
    virtual void focus_out ();
    virtual void toggle_full_width_punctuation ();
    virtual void toggle_full_width_letter ();
    virtual void toggle_input_status ();

private:
    bool commit_transaction (SocketTransaction &trans);
    bool do_transaction (SocketTransaction &trans);
};

#endif
/*
vi:ts=4:nowrap:ai:expandtab
*/

