/** @file scim_panel.h
 */

/* 
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_panel.h,v 1.1 2004/04/07 15:29:54 suzhe Exp $
 */

#ifndef __SCIM_PANEL_H__
#define __SCIM_PANEL_H__

#define SCIM_PANEL_DEFAULT_SOCKET_ADDRESS "local:/tmp/scim-panel-socket"

#define SCIM_CONFIG_PANEL_SOCKET_ADDRESS  "/Panel/SocketAddress"
#define SCIM_CONFIG_PANEL_SOCKET_TIMEOUT  "/Panel/SocketTimeout"

namespace scim {

const int
    //Privately used by panel.
    SCIM_TRANS_CMD_PANEL_EXIT                  = SCIM_TRANS_CMD_USER_DEFINED + 0,

    //client -> panel
    SCIM_TRANS_CMD_PANEL_TURN_ON               = SCIM_TRANS_CMD_USER_DEFINED + 1,
    SCIM_TRANS_CMD_PANEL_TURN_OFF              = SCIM_TRANS_CMD_USER_DEFINED + 2,
    SCIM_TRANS_CMD_PANEL_UPDATE_DISPLAY        = SCIM_TRANS_CMD_USER_DEFINED + 3,
    SCIM_TRANS_CMD_PANEL_UPDATE_SCREEN         = SCIM_TRANS_CMD_USER_DEFINED + 4,
    SCIM_TRANS_CMD_PANEL_UPDATE_SPOT_LOCATION  = SCIM_TRANS_CMD_USER_DEFINED + 5,
    SCIM_TRANS_CMD_PANEL_UPDATE_SERVER_INFO    = SCIM_TRANS_CMD_USER_DEFINED + 6,
    SCIM_TRANS_CMD_PANEL_SHOW_HELP             = SCIM_TRANS_CMD_USER_DEFINED + 7,
    SCIM_TRANS_CMD_PANEL_SHOW_SERVER_MENU      = SCIM_TRANS_CMD_USER_DEFINED + 8,

    //panel -> client
    SCIM_TRANS_CMD_PANEL_REQUEST_HELP          = SCIM_TRANS_CMD_USER_DEFINED + 32,
    SCIM_TRANS_CMD_PANEL_REQUEST_SERVER_MENU   = SCIM_TRANS_CMD_USER_DEFINED + 33,
    SCIM_TRANS_CMD_PANEL_CHANGE_SERVER_FACTORY = SCIM_TRANS_CMD_USER_DEFINED + 34;

} // namespace scim

#endif

/*
vi:ts=4:nowrap:expandtab
*/
