%define name scm
%define version 5d9
%define release 1
%define implpath %{prefix}/lib/scm
# rpm seems to require all on one line, bleah.
%define features cautious bignums arrays inexact dump dynamic-linking macro engineering-notation

Name:         %{name}
Release:      %{release}
Version:      %{version}
Packager:     Radey Shouman <shouman@ne.mediaone.net>

Copyright:    GPL
Vendor:       Aubrey Jaffer <agj @ alum.mit.edu>
Group:        Development/Languages
Provides:     scm
Requires:     slib

Summary: SCM Scheme implementation.
Source:       ftp://swissnet.ai.mit.edu/pub/scm/scm%{version}.zip
URL:          http://swissnet.ai.mit.edu/~jaffer/SCM
BuildRoot:    %{_tmppath}/%{name}%{version}
Prefix:       /usr

%description
Scm conforms to Revised^5 Report on the Algorithmic Language Scheme and
the IEEE P1178 specification.  Scm provides a machine independent
platform for JACAL, a symbolic algebra system.

This distribution requires libdl.so from the glibc-devel package and the
slib Scheme library package.  If your machine lacks XFree86 or readline,
install with --nodeps.

%define __os_install_post /usr/lib/rpm/brp-compress

%prep
rm -rf /var/tmp/%{name}%{version}
%setup -n scm -c -T
cd ..
unzip $RPM_SOURCE_DIR/scm%{version}.zip

%build
# SLIB is required to build SCM.
if [ -n "$SCHEME_LIBRARY_PATH" ]; then
  echo using SLIB $SCHEME_LIBRARY_PATH
elif [ -d /usr/share/slib ]; then
  export SCHEME_LIBRARY_PATH=/usr/share/slib/
elif [ -d /usr/lib/slib ]; then
  export SCHEME_LIBRARY_PATH=/usr/lib/slib/
fi
make scmlit
make clean
export PATH=.:$PATH   # to get scmlit in the path.

# Build the executable.
./build -h system -o udscm5 --compiler-options="-O3" -l debug -s %{implpath} -F %{features}
echo "(quit)" | ./udscm5 -no-init-file -r5 -o scm
make check

# Build dlls
make x.so
./build -h system -F curses -t dll --compiler-options="-O3"
./build -h system -t dll -c sc2.c rgx.c record.c gsubr.c ioext.c posix.c \
	    unix.c socket.c ramap.c --compiler-options="-O3"
./build -h system -F edit-line -t dll --compiler-options="-O3"
./build -h system -F x -t dll --compiler-options="-O3"

# Build libscm.a static library
./build -h system -F cautious bignums arrays inexact dynamic-linking -t lib \
	--compiler-options="-O3"

%install
mkdir -p ${RPM_BUILD_ROOT}%{prefix}/bin
mkdir -p ${RPM_BUILD_ROOT}%{prefix}/lib/scm
mkdir -p ${RPM_BUILD_ROOT}%{prefix}/man/man1
make prefix=${RPM_BUILD_ROOT}%{prefix}/  install
make prefix=${RPM_BUILD_ROOT}%{prefix}/  installlib
rm -f ${RPM_BUILD_ROOT}%{prefix}/bin/scm
cp udscm5 ${RPM_BUILD_ROOT}%{prefix}/bin/

# Assume SLIB is in /usr/share/slib, as installed by the slib rpm.
cat > ${RPM_BUILD_ROOT}%{prefix}/lib/scm/require.scm <<EOF
(set! library-vicinity (lambda () "%{prefix}/share/slib/"))
EOF

mkdir -p ${RPM_BUILD_ROOT}%{prefix}/info/
gzip *.info
cp *.info.gz ${RPM_BUILD_ROOT}%{prefix}/info/

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/install-info /usr/info/scm.info.gz /usr/info/dir
/sbin/install-info /usr/info/hobbit.info.gz /usr/info/dir
/sbin/install-info /usr/info/Xlibscm.info.gz /usr/info/dir
echo "(quit)" | %{prefix}/bin/udscm5 -no-init-file -r5 -o %{prefix}/bin/scm
ln -s %{prefix}/bin/scm /usr/local/bin/scm
ln -s %{prefix}/lib/scm /usr/local/lib/
/usr/bin/scm -c "(require 'new-catalog)"

%verifyscript
cp -f %{prefix}/lib/scm/r4rstest.scm /tmp/
(cd /tmp
    %{prefix}/bin/scm -fr4rstest.scm -e'(test-sc4)(test-cont)(test-delay)(gc)')

%preun
rm -f %{prefix}/lib/scm/slibcat %{prefix}/lib/scm/implcat
if [ -L /usr/local/bin/scm ] && \
    ls -l /usr/local/bin/scm | grep -q "> %{prefix}/bin/scm"; then
  rm -f /usr/local/bin/scm
fi
if [ -L /usr/local/lib/scm ] && \
    ls -l /usr/local/lib/scm | grep -q "> %{prefix}/lib/scm"; then
  rm -f /usr/local/lib/scm
fi
rm -f %{prefix}/bin/scm

%files
%defattr(-, root, root)
%{prefix}/bin/scmlit
%{prefix}/bin/udscm5
%dir %{prefix}/lib/scm
# No wildcards here because we need to segregate files by package.
%{prefix}/lib/scm/crs.so
%{prefix}/lib/scm/gsubr.so
%{prefix}/lib/scm/posix.so
%{prefix}/lib/scm/record.so
%{prefix}/lib/scm/sc2.so
%{prefix}/lib/scm/unix.so
%{prefix}/lib/scm/ioext.so
%{prefix}/lib/scm/ramap.so
%{prefix}/lib/scm/socket.so
%{prefix}/lib/scm/rgx.so
%{prefix}/lib/scm/Init%{version}.scm
%{prefix}/lib/scm/require.scm
%{prefix}/lib/scm/Macexp.scm
%{prefix}/lib/scm/Macro.scm
%{prefix}/lib/scm/Tscript.scm
%{prefix}/lib/scm/Transcen.scm
%{prefix}/lib/scm/mkimpcat.scm
%{prefix}/lib/scm/Link.scm
%{prefix}/lib/scm/compile.scm
%{prefix}/lib/scm/hobbit.scm
%{prefix}/lib/scm/scmhob.scm
%{prefix}/lib/scm/scmhob.h
%{prefix}/lib/scm/patchlvl.h
%{prefix}/lib/scm/build.scm
%{prefix}/lib/scm/build
%{prefix}/lib/scm/Iedline.scm
%{prefix}/lib/scm/edline.so
%{prefix}/lib/scm/x.so
%{prefix}/lib/scm/xevent.scm
%{prefix}/lib/scm/xatoms.scm
%{prefix}/lib/scm/x11.scm
%{prefix}/lib/scm/keysymdef.scm
%{prefix}/lib/scm/r4rstest.scm
/usr/info/Xlibscm.info.gz
/usr/info/hobbit.info.gz
/usr/info/scm.info.gz
/usr/man/man1/scm.1.gz

%{prefix}/lib/libscm.a
%{prefix}/include/scm.h
%{prefix}/include/scmfig.h
%{prefix}/include/scmflags.h

%doc ANNOUNCE COPYING QUICKREF README ChangeLog

%changelog
