/* Copyright (C) 2006 Free Software Foundation, Inc.
 * Author: Richard E. Harke (get-contoffset-ia64.c only) copyright assigned
 * to Free Software Foundation, Inc.
 *
 * By including the following notice, I am agreeing to its terms,
 * including the special exception for SCM.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of SCM.
 *
 * The exception is that, if you link the SCM library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the SCM library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name SCM.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * SCM, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for SCM, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 */

/* The .o of this file does not get linked into SCM.
 * It is a utility used to create an include file
 * for continue-ia64.S to get offsets into struct jump_buf
 * and be sure they are correct for the current compiler.
 *
 * create get-contoffset-ia64 program by:
 *   gcc -o get-contoffset-ia64 get-contoffset-ia64.c
 * create ASM include file by:
 *   ./get-contoffset-ia64 contoffset-ia64.S
 */
#include <stddef.h>
#include <stdio.h>

#define IN_CONTINUE_C
#include "setjump.h"

int
main(int argc, char ** argv)
{
  struct Continuation taco;
  long jmpbuf_off = 10L;
  long thrwval_off;
  long length_off;
  long stkbse_off;
  long bspbse_off;
  long bsplength_off;
  long rnat_off;
  long other_off;
  long parent_off;
  long cont_size;
  FILE *prt;

  switch (argc) {
  case 1: prt = stdout; break;
  case 2: prt = fopen(argv[1], "w"); break;
  default: return !0;
  }
  jmpbuf_off = &((struct Continuation *)0)->jmpbuf;
  thrwval_off = &((struct Continuation *)0)->thrwval;
  length_off = &((struct Continuation *)0)->length;
  stkbse_off = &((struct Continuation *)0)->stkbse;
  bspbse_off = &((struct Continuation *)0)->bspbse;
  bsplength_off = &((struct Continuation *)0)->bsplength;
  rnat_off = &((struct Continuation *)0)->rnat;
  other_off = &((struct Continuation *)0)->other;
  parent_off = &((struct Continuation *)0)->parent;
  cont_size = sizeof(struct Continuation);

  fprintf(prt, "        jmpbuf_off = %ld\n", jmpbuf_off);
  fprintf(prt, "        thrwval_off = %ld\n", thrwval_off);
  fprintf(prt, "        length_off = %ld\n", length_off);
  fprintf(prt, "        stkbse_off = %ld\n", stkbse_off);
  fprintf(prt, "        bspbse_off = %ld\n", bspbse_off);
  fprintf(prt, "        bsplength_off = %ld\n", bsplength_off);
  fprintf(prt, "        rnat_off = %ld\n", rnat_off);
  fprintf(prt, "        other_off = %ld\n", other_off);
  fprintf(prt, "        parent_off = %ld\n", parent_off);
  fprintf(prt, "        cont_size = %ld\n", cont_size);
  fclose(prt);
  return 0;
}
