/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include "../config.h"
#include <stdio.h>
#include <string.h>
#include <strings.h>

void help(char *me){
  char* name;
  
  if ((name = rindex(me,'/')) == NULL) {
    name = me;
  } else {
    ++name;
  }
  printf("This is a program written by Hendrik Sattler <post@hendrik-sattler.de>.\n");
  printf("This program is licenced with the GPL.\n");
  printf("Use at your own risk!\n");
  printf("You need a phone made by Siemens to get an useful result.\n\n");
  printf("Syntax: %s [options] operation [mem type] [sms options] [file...]\n",name);

  printf("\nOptions:\n");
  printf(" --device <device>   -d  specify another than the compiled in device\n");
  printf(" --baud <baudrate>   -b  specify another than the compiled in baudrate\n");
  printf(" --out <file>        -o  specify a file when getting ('-' for stdout)\n");
  printf("                         when using slot \"all\" this gets expanded\n");
  printf(" --pipe <program>    -p  specify a pipe to use\n");
  printf(" --pin <pin>             use this pin if one is needed\n");
  printf(" --quiet             -q  decreases verbosity by 1\n");
  printf(" --verbose           -v  increases verbosity by 1\n");

  printf("\nOperations:\n");
  printf(" --remove            -r  removes an entry from the phone\n");
  printf(" --send              -s  sends a file to the phone\n");
  printf(" --get               -g  get an entry and save it to a file\n");
  printf(" --info              -i  collect information\n");
  printf(" --set-time              synchronize time on phone\n");
  printf(" --set-smsc              set the SMSC number (requires option -n)\n");
  printf(" --reset                 send some special characters and exit\n");
  printf(" --help              -h  print this message\n");
  printf(" --version               print the version number\n");

  printf("\nMemory types:\n");
  printf(" --binary            -N  binary file transfer\n");
  printf(" --pbook             -P  phonebook\n");
  printf(" --sms               -S  short messages\n");

  printf("\nMemory type options:\n");
  printf(" --mem <mem>             select a memory\n");
  printf(" --slot <slot>           select a slot or slot group\n");

  printf("\nSMS options:\n");
  printf(" --direct                send/receive without storing in the phone\n");

  printf("\nSMS-PDU creation options:\n");
  printf(" --number <number>   -n  specify number to send SMS to\n");
  printf(" --text <text>       -t  specify content of SMS\n");
  printf(" --unicode               use UCS-2 (unicode) as charset\n");
  printf(" --srr                   request a status report from the SMSC\n");
  printf(" --flash                 make the sms appear directly (if supported by\n");
  printf("                         the receiving entity)\n");

  printf("\nSee man page for more detailed information.\n");
}

void version () {
  printf("%s\n",PACKAGE_VERSION);
}
