/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONS_H
#define OPTIONS_H

#define SCMXX_ACTION_REMOVE 0x1
#define SCMXX_ACTION_SEND   0x2
#define SCMXX_ACTION_GET    0x4

#define SCMXX_FTYPE_BINARY 0x1
#define SCMXX_FTYPE_PBOOK  0x2
#define SCMXX_FTYPE_SMS    0x4

#define SCMXX_SLOT_SMS_SENT   -6
#define SCMXX_SLOT_SMS_UNSENT -5
#define SCMXX_SLOT_SMS_READ   -4
#define SCMXX_SLOT_SMS_UNREAD -3
#define SCMXX_SLOT_ALL        -2
#define SCMXX_SLOT_UNDEFINED  -1

#define SCMXX_SLOT_BINARY_MIN 0
#define SCMXX_SLOT_PBOOK_MIN  1
#define SCMXX_SLOT_SMS_MIN    1

#include "../config.h"
#ifdef HAVE_STDINT_H
#  include <stdint.h>
#else
#  include <inttypes.h>
#endif

struct smsopts {
  char flash;
  char srr;
  char unicode;
  char direct;
};

struct parameters {
  char* text;
  char* number;
  int slot;
  char* mem;
};

struct port_args_t {
  char* device;
  char* baud;
  uint8_t timeout;
  int ignorebits;
  unsigned int startdelay;
};

struct args_t {
  struct port_args_t port;

  struct parameters myparams;
  struct smsopts mysmsopts;

  char scmxx_action;
  char scmxx_ftype;

  char* myFILE;
  char* myPIPE;

  int info;
  int meminfo;
  int time;
  int smsc;
  int reset;
  int help;
  int version;

  int verbose;
  char* pin;
};

/* a function to init the variables in the struct
 */
void args_init (struct args_t* args);

/* functions to fill the struct by parsing the command line
 * currently only GNU getopt_long() is implemented (options_getopt.c)
 * returns a NULL terminated list of files
 */
char** args_parse (int argc, char** argv,
		   struct args_t* args);

/* used by the different implementations of args_parse()
 */
void arg_fill (int short_opt, const char* long_opt,
	       char* argument, struct args_t* args);

/* include environment variables and/or
 * use values from config.h
 */
void use_envvars (struct args_t* args);

#endif
