/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMSPDU_H
#define SMSPDU_H

#include "options.h"
#include "charsets.h"
#include "timeincl.h"

enum sms_direction {
  SMS_INCOMING = 0,
  SMS_OUTGOING = 1
};

#define SMS_DELIVER        0 //type SMS_INCOMING
#define SMS_SUBMIT_REPORT  1 //type SMS_INCOMING
#define SMS_STATUS_REPORT  2 //type SMS_INCOMING

#define SMS_DELIVER_REPORT 0 //type SMS_OUTGOING
#define SMS_SUBMIT         1 //type SMS_OUTGOING
#define SMS_COMMAND        2 //type SMS_OUTGOING

#include "../config.h"
#ifdef HAVE_STDINT_H
#  include <stdint.h>
#else
#  include <inttypes.h>
#endif

struct sms_number {
  unsigned int length;
  unsigned int type;
  unsigned char number[21];
};
typedef struct sms_number sms_number_t;

struct sms_pdu_ud_header {
  uint8_t type;
  uint8_t len;
  char* data;
};

struct sms_pdu_ud {
  uint8_t len;
  struct sms_pdu_ud_header** header;
  ucs4char_t* text;
};

struct sms_pdu_time {
  enum {
    SMS_PDU_TIME_NONE = 0,
    SMS_PDU_TIME_RELATIVE,
    SMS_PDU_TIME_ABSOLUTE
  } format;
  time_t value; //for absolute, this is in GMT
};

struct sms_pdu_data {
  uint8_t type;
  sms_number_t address;
  uint8_t pid;
  uint8_t dcs;
  struct sms_pdu_time timedata;
  struct sms_pdu_ud ud;
};

struct sms_tpdu_data {
  sms_number_t sca;
  struct sms_pdu_data* pdu;
};

struct sms_data {
  int slot; //>0 for true values
  enum sms_direction type;
  char tpdu[363];
};
typedef struct sms_data sms_data_t;

#include <stdio.h>

char* sms_pdu_create_submit (char* text, char* number, struct smsopts* opts);
void sms_pdu_decode (FILE* fp, int slot, int type, char* tpdu);
struct sms_pdu_data*  sms_pdu_decode_deliver (char* pdu);
void sms_pdu_print_deliver (FILE* fp, int slot, enum sms_direction type, struct sms_tpdu_data* sms);

unsigned int sms_pdu_len (char* pdu);
unsigned int sms_tpdu_len (char* tpdu);

void sms_udh_print (FILE* fp, struct sms_pdu_ud_header** udh);
void sms_udh_multipart8_print (FILE* fp, char* data);
void sms_udh_multipart16_print (FILE* fp, char* data);
void sms_udh_application8_print (FILE* fp, char* data);
void sms_udh_application16_print (FILE* fp, char* data);
void sms_udh_source_indicator_print (FILE* fp, char* data);
void sms_udh_smstk_print (FILE* fp, char* data);
void sms_udh_wcmpdu_print (FILE* fp, char* data);
void sms_udh_indication_print (FILE* fp, char* data);

struct sms_pdu_ud_header_def {
  int16_t type; //negative entries are invalid
  uint8_t minlen; //in octets
  uint8_t maxlen; //in octets (obviously not more than 137(=140-1-2)))
  void (*print_func) (FILE* fp, char* data); //function pointer to header type printer
};
extern struct sms_pdu_ud_header_def header_defs[]; //known header types

#endif
