/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <atcommand.h>
#include <common.h>
#include <helper.h>

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <errno.h>

void at_sie_binary_write (const char* ftype,
			  unsigned int slot,
			  int part, int total)
{
  char* parmlist;

  if (str_len(ftype) == 0) return;
  parmlist = mem_alloc(1+strlen(ftype)+2+numlen(slot)
		       +1+numlen(part)+1+numlen(total)
		       +1,
		       1);
  if (part < 0 || total < 0) {
    sprintf(parmlist,"\"%s\",%d",ftype,slot);
  } else if (part == 0 || total == 0) {
    sprintf(parmlist,"\"%s\",%d,%d",ftype,slot,part);
  } else {
    sprintf(parmlist,"\"%s\",%d,%d,%d",ftype,slot,part,total);
  }
  at_command_send(AT_SIE_BIN_WRITE,parmlist);
  mem_realloc(parmlist,0);
}

void at_sie_binary_read (const char* ftype, unsigned int slot) {
  char* parmlist;

  if (str_len(ftype) == 0) return;
  parmlist = mem_alloc(1+strlen(ftype)+2+numlen(slot)+1, 1);
  sprintf(parmlist,"\"%s\",%d",ftype,slot);
  at_command_send(AT_SIE_BIN_READ,parmlist);
  mem_realloc(parmlist,0);
}

void at_sie_phonebook_vcf_read (unsigned int slot, int type) {
  char* parmlist;
  
  if (type > 3 || type < 0) {
    type = -1;
    parmlist = mem_alloc(numlen(slot)+1,1);
    sprintf(parmlist,"%d",slot);
  } else {
    parmlist = mem_alloc(numlen(slot)+1+numlen(type)+1,1);
    sprintf(parmlist,"%d,%d",slot,type);
  }
  at_command_send(AT_SIE_PB_VCF_READ,parmlist);
  mem_realloc(parmlist,0);
}

void at_sie_phonebook_read_sorted (unsigned int slot_low,
				   unsigned int slot_high)
{
  char* parmlist;

  parmlist = mem_alloc(numlen(slot_low)+1
		       +numlen(slot_high)+1, 1);
  sprintf(parmlist,"%d,%d",slot_low,slot_high);
  at_command_send(AT_SIE_PB_READ_SORTED,parmlist);
  mem_realloc(parmlist,0);  
}

void at_sie_phonebook_select (const char* mem) {
  char* parmlist;

  if (mem == NULL) return;
  parmlist = mem_alloc(1+strlen(mem)+2, 1);
  sprintf(parmlist,"\"%s\"",mem);
  at_command_send(AT_SIE_PB_SELECT,parmlist);
  mem_realloc(parmlist,0);  
}

void at_sie_sms_slot_read (unsigned int slot) {
  char* parmlist;

  parmlist = mem_alloc(numlen(slot)+1,1);
  sprintf(parmlist,"%d",slot);
  at_command_send(AT_SIE_SMS_SLOT_READ,parmlist);
  mem_realloc(parmlist,0);  
}

void at_sie_sms_list_read (unsigned int list_id) {
  char* parmlist;

  parmlist = mem_alloc(numlen(list_id)+1,1);
  sprintf(parmlist,"%d",list_id);
  at_command_send(AT_SIE_SMS_LIST_READ,parmlist);
  mem_realloc(parmlist,0);  
}
