/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "memtypes.h"	 
#include "common.h"
#include "helper.h"
#include "atcommand.h"

#include <stdlib.h>
#include <string.h>
#include <strings.h>

struct slot_range** file_get_types (int mode) {
  struct slot_range** retval;
  char* ausgabe;
  char* command;
  char* temp;
  char* start;
  char* end;
  int count = 0;

  ausgabe=get_vendor();
  if (ausgabe != NULL &&
      !strcasecmp(ausgabe,"SIEMENS")) {
    ausgabe = mem_realloc(ausgabe,0);
    if (mode == 0) {
      command = AT_SIE_BIN_READ;
    } else {
      command = AT_SIE_BIN_WRITE;
    }
    at_command_send(command,"?");
    ausgabe = at_get_value(command);
    /* ^SBNR: ("bmp",(0-2)),("mid",(0-10)),("vcf",(0-500)),("vcs",(1-500))
     * ^SBNW: ("bmp",(0-4)),("mid",(0-10)),("vcf",(0-500)),("vcs",(0-500)),("t9d",(0))
     */
    if (ausgabe != NULL) {
      //count the number of entries
      temp = ausgabe;
      while ((start = index(temp,'"')) != NULL &&
	     (end = index(start+1,'"')) != NULL) {
	++count;
	temp = end+1;
      }
      retval = mem_alloc(sizeof(*retval)*(count+1),0);
      
      //assign the entries;
      count = 0;
      temp = ausgabe;
      while ((start = index(temp,'"')) != NULL &&
	     (end = index(start+1,'"')) != NULL) {
	++start;
	if (end-start > 3) {
	  errexit("%s","ERROR: Buffer overrun.\n");
	}
	retval[count] = mem_alloc(sizeof(**retval),0);
	strncpy(retval[count]->name,start,end-start);
	retval[count]->name[end-start]=0;
	if ((start = index(end+1,'(')) != NULL ||
	    index(start+1,')') != NULL) {
	  ++start;
	  retval[count]->min = atoi(start);
	  do {
	    ++start;
	  } while (*start != '-' && *start != ')');
	  if (*start == '-') {
	    retval[count]->max = atoi(start+1);
	  } else {
	    retval[count]->max = retval[count]->min;
	  }
	} else {
	  retval[count]->min = -1;
	  retval[count]->max = -1;	  
	}
	++count;
	temp = end+1;
      }
    } else {
      retval = mem_alloc(sizeof(*retval),0);
    }
  } else {
    retval = mem_alloc(sizeof(*retval),0);
  }
  retval[count]=NULL;
  mem_realloc(ausgabe,0);
  return retval;
}

void file_print_memlist (FILE* fd, unsigned int full) {
  struct slot_range** rrange;
  struct slot_range** wrange;
  int i = 0;
  int j = 0;
  unsigned int nmaxl = 0;
  unsigned int rmaxl = 0;
  unsigned int wmaxl = 0;
  unsigned int rflen;
  unsigned int wflen;
  struct mem_list_t {
    char* name;
    struct slot_range* r;
    struct slot_range* w;
  };
  struct mem_list_t* memlist;

  if (fd == NULL) {
    fd = stdout;
  }

  rrange = file_get_types(0);
  wrange = file_get_types(1);

  while (rrange[i] != NULL) {
    if (rmaxl < numlen(rrange[i]->max)) {
      rmaxl = numlen(rrange[i]->max);
    }
    if (nmaxl < strlen(rrange[i]->name)) {
      nmaxl = strlen(rrange[i]->name);
    }
    ++i;
  }
  while (wrange[j] != NULL) {
    if (wmaxl < numlen(wrange[j]->max)) {
      wmaxl = numlen(wrange[j]->max);
    }
    if (nmaxl < strlen(wrange[j]->name)) {
      nmaxl = strlen(wrange[j]->name);
    }
    ++j;
  }

  //finding a list of all mems
  memlist = mem_alloc(((i+1)+(j+1)+1)*sizeof(*memlist),0);
  
  i=0;
  while (rrange[i] != NULL) {
    memlist[i].name = rrange[i]->name;
    memlist[i].r = rrange[i];
    memlist[i].w = NULL;
    ++i;
  }
  memlist[i].name = NULL;
  j=0;
  while (wrange[j] != NULL) {
    i=0;
    while (memlist[i].name != NULL &&
	   strcmp(memlist[i].name,wrange[j]->name) != 0) {
      ++i;
    }
    if (memlist[i].name == NULL) {
      memlist[i].name = wrange[j]->name;
      memlist[i].r = NULL;
      memlist[i+1].name = NULL;
    }
    memlist[i].w = wrange[j];
    ++j;
  }

  i=0;
  if (full) {
    rflen = strlen("readable");
    if ((2*rmaxl)+1 > rflen) {
      rflen = (2*rmaxl)+1;
    }
    wflen = strlen("writable");
    if ((2*wmaxl)+1 > wflen) {
      wflen = (2*wmaxl)+1;
    }
    fprintf(fd,"\n");
    fprintf(fd,"%-*s\t%*s\t%*s\t%s\n",nmaxl,"mem",rflen,"readable",wflen,"writable","description");
    fprintf(fd,"%-*s\t%*s\t%*s\t%s\n",nmaxl,"---",rflen,"--------",wflen,"--------","-----------");
    while (memlist[i].name != NULL) {
      fprintf(fd,"%-*s\t",nmaxl,memlist[i].name);
      if (memlist[i].r != NULL) {
	if (memlist[i].r->min != memlist[i].r->max) {
	  fprintf(fd,"%*d-%-*d",rmaxl,memlist[i].r->min,rflen-rmaxl-1,memlist[i].r->max);
	} else {
	  fprintf(fd,"%*d%*s",rmaxl,memlist[i].r->min,rflen-rmaxl,"");
	}
      } else {
	fprintf(fd,"%*s",rflen,"");
      }
      fprintf(fd,"\t");
      if (memlist[i].w != NULL) {
	if (memlist[i].w->min != memlist[i].w->max) {
	  fprintf(fd,"%*d-%-*d",wmaxl,memlist[i].w->min,wflen-wmaxl-1,memlist[i].w->max);
	} else {
	  fprintf(fd,"%*d%*s",wmaxl,memlist[i].w->min,wflen-wmaxl,"");
	}
      } else {
	fprintf(fd,"%*s",wflen,"");
      }
      fprintf(fd,"\t");
      if (strcmp(memlist[i].name,"bmp") == 0) {
	fprintf(fd,"bitmap");
      } else if (strcmp(memlist[i].name,"mid") == 0) {
	fprintf(fd,"midi");
      } else if (strcmp(memlist[i].name,"vcs") == 0) {
	fprintf(fd,"vCalendar");
      } else if (strcmp(memlist[i].name,"vcf") == 0) {
	fprintf(fd,"vCard (address book)");
      } else if (strcmp(memlist[i].name,"bmx") == 0) {
	fprintf(fd,"EMS animation");
      } else if (strcmp(memlist[i].name,"t9d") == 0) {
	fprintf(fd,"T9 database");
      }
      fprintf(fd,"\n");
      ++i;
    }
  } else {
    while (memlist[i].name != NULL) {
      if (i != 0) {
	fprintf(fd,", ");
      }
      fprintf(fd,"%s",memlist[i].name);
      ++i;
    }
  }
  fprintf(fd,"\n");
  mem_realloc(rrange,0);
  mem_realloc(wrange,0);
  mem_realloc(memlist,0);
}

char** pb_get_types (void) {
  char** retval;
  char* ausgabe;
  char* command;
  unsigned int i = 0;
  int has_mem_vcf = 0;

  ausgabe = get_vendor();
  if(ausgabe != NULL &&
     strcasecmp(ausgabe,"SIEMENS") == 0) {
    command = AT_SIE_PB_SELECT;
    mem_realloc(ausgabe,0);
    at_command_send(AT_SIE_PB_VCF_READ,AT_READ_SUFFIX);
    ausgabe = at_get_value(AT_SIE_PB_VCF_READ);
    if (ausgabe != NULL) has_mem_vcf = 1;
  } else {
    command = AT_GEN_PB_SELECT;
  }
  mem_realloc(ausgabe,0);
  at_command_send(command,AT_READ_SUFFIX);
  ausgabe = at_get_value(command);
  /* ^SPBS: ("FD","SM","ON","LD","MC","RC","OW","MS","CD","BL","RD","CS")
   * +CPBS: ("FD","SM","ON","LD","MC","RC")
   */
  if (ausgabe != NULL) {
    retval = at_parse_stringlist(ausgabe);
    if (has_mem_vcf) {
      while (retval[i] != NULL) ++i;
      retval = mem_realloc(retval,(i+2)*sizeof(*retval));
      retval[i] = str_dup(VCARD_PHONEBOOK_NAME);
      retval[i+1] = NULL;
    }
  } else {
    retval = NULL;
  }
  mem_realloc(ausgabe,0);
  return retval;
}

void pbook_print_memlist (FILE* fd, unsigned int full) {
  char** memlist;
  int i = 0;
  int min;
  int max;
  int nrlen;
  int txtlen;
  int writable;
  int fw1,fw2,fw3,fw4,fw5;
  

  if (fd == NULL) {
    fd = stdout;
  }

  memlist = pb_get_types();
  if (full) {
    fprintf(fd,"\n");
    fprintf(fd,"%s  %-*s  %s  %s  %s  %s\n","mem",6,"slots","writable","digits","chars","description");
    fprintf(fd,"%s  %-*s  %s  %s  %s  %s\n","---",6,"-----","--------","------","-----","-----------");
    fw1 = strlen("digits");
    fw2 = strlen("chars");
    fw3 = strlen("writable");
    fw4 = strlen("slots");
    fw5 = strlen("mem");
    while (memlist[i] != NULL) {
      pbook_select_mem(memlist[i]);
      writable = pbook_get_ranges(memlist[i],1,&min,&max,&nrlen,&txtlen);
      if (writable == 0) {
	if(!pbook_get_ranges(memlist[i],0,&min,&max,&nrlen,&txtlen)) {
	  fprintf(fd,"Error on getting limits of phonebook %s.\n",memlist[i]);
	  ++i;
	  continue;
	}
      }
      fprintf(fd,"%-*s",fw5+2,memlist[i]);
      if (min != max) {
	fprintf(fd,"%d-%-*d",min,fw4+2-numlen(min),max);
      } else {
	if (min == 0) {
	  fprintf(fd,"%-*s",fw4+3,"none");
	} else {
	  fprintf(fd,"%-*d",fw4+3,min);
	}
      }
      if (writable) {
	fprintf(fd,"  %-*s",fw3,"yes");
      } else {
	fprintf(fd,"  %-*s",fw3,"no");
      }
      if (nrlen >= 0) {
	fprintf(fd,"%*s%-*d",(fw1-numlen(nrlen))/2+(fw1%2),"",(fw1/2)+(numlen(nrlen)/2),nrlen);
      } else {
	fprintf(fd,"%*s",fw1,"");
      }
      fprintf(fd,"  ");
      if (txtlen >= 0) {
	fprintf(fd,"%*s%-*d",(fw2-numlen(txtlen))/2+(fw2%2),"",(fw2/2)+(numlen(txtlen)/2),txtlen);
      } else {
	fprintf(fd,"%*s",fw2,"");
      }
      fprintf(fd,"  ");
      if (strcasecmp(memlist[i],"FD") == 0) {
	fprintf(fd,"SIM fix-dialing phonebook");
      } else if (strcasecmp(memlist[i],"SM") == 0) {
	fprintf(fd,"SIM phonebook");
      } else if (strcasecmp(memlist[i],"DC") == 0 ||
		 strcasecmp(memlist[i],"MD") == 0) {
	fprintf(fd,"last calls (mobile)");
      } else if (strcasecmp(memlist[i],"LD") == 0) {
	fprintf(fd,"last calls (SIM)");
      } else if (strcasecmp(memlist[i],"ON") == 0 ||
		 strcasecmp(memlist[i],"OW") == 0) {
	fprintf(fd,"own numbers");
      } else if (strcasecmp(memlist[i],"ME") == 0) {
	fprintf(fd,"mobile equipment phonebook");
      } else if (strcasecmp(memlist[i],"BD") == 0) {
	fprintf(fd,"barred numbers");
      } else if (strcasecmp(memlist[i],"SD") == 0) {
	fprintf(fd,"service numbers");
      } else if (strcasecmp(memlist[i],"MC") == 0 ||
		 strcasecmp(memlist[i],"MS") == 0) {
	fprintf(fd,"missed calls");
      } else if (strcasecmp(memlist[i],"RC") == 0 ||
		 strcasecmp(memlist[i],"CD") == 0) {
	fprintf(fd,"callback numbers");
      } else if (strcasecmp(memlist[i],"BL") == 0) {
	fprintf(fd,"blacklist numbers");
      } else if (strcasecmp(memlist[i],"MB") == 0) {
	fprintf(fd,"mailbox numbers");
      } else if (strcasecmp(memlist[i],"RD") == 0) {
	fprintf(fd,"red book (VIP in CS)");
      } else if (strcasecmp(memlist[i],"CS") == 0) {
	fprintf(fd,"common sortable (FD+SM+ME)");
      } else if (strcasecmp(memlist[i],VCARD_PHONEBOOK_NAME) == 0) {
	fprintf(fd,"address book numbers");
      }
      fprintf(fd,"\n");
      ++i;
    }
  } else {
    if (memlist != NULL && memlist[0] != NULL) {
      do {
	if (i != 0) {
	  fprintf(fd,", ");
	}
	fprintf(fd,"%s",memlist[i]);
	mem_realloc(memlist[i],0);
      } while (memlist[++i] != NULL);
    }
  }
  fprintf(fd,"\n");
  mem_realloc(memlist,0);
}

char** sms_get_types (void) {
  char** retval;
  char* ausgabe;

  at_command_send(AT_GEN_SMS_MEM,"?");
  ausgabe = at_get_value(AT_GEN_SMS_MEM);
  /* +CPMS: ("MT","SM","ME"),("MT","SM","ME"),("MT","SM","ME")
   */
  if (ausgabe != NULL) {
    retval = at_parse_stringlist(ausgabe);
  } else {
    retval = NULL;
  }
  mem_realloc(ausgabe,0);
  return retval;
}

void sms_print_memlist (FILE* fd, unsigned int full) {
  char** memlist;
  int i = 0;
  struct slot_range range;
  int current;
  int fw1,fw2,fw3;

  if (fd == NULL) {
    fd = stdout;
  }

  memlist = sms_get_types();
  if (full) {
    fprintf(fd,"\n");
    fprintf(fd,"%s\t%-*s\t%s\t%s\n","mem",6,"slots","used","description");
    fprintf(fd,"%s\t%-*s\t%s\t%s\n","---",6,"-----","----","-----------");
    fw1 = strlen("mem");
    fw2 = 6;
    fw3 = strlen("used");
    while (memlist[i] != NULL) {
      sms_select_mem(memlist[i],&range,&current);
      fprintf(fd,"%-*s",fw1,range.name);
      fprintf(fd,"\t");
      if (range.min != range.max) {
	fprintf(fd,"%d-%-*d",range.min,(fw2-1)-numlen(range.min),range.max);
      } else {
	fprintf(fd,"%-*d",fw2+2,range.min);
      }
      fprintf(fd,"\t");
      fprintf(fd,"%*d",(fw3/2)+(numlen(range.max-range.min+1)/2),current);
      fprintf(fd,"%*s",(fw3/2)-(numlen(range.max-range.min+1)/2)+((range.max-range.min+1)%2),"");
      fprintf(fd,"\t");
      if (strcmp(range.name,"SM") == 0) {
	fprintf(fd,"SIM");
      } else if (strcmp(range.name,"ME") == 0) {
	fprintf(fd,"mobile equipment");
      } else if (strcmp(range.name,"MT") == 0) {
	fprintf(fd,"ME + SM");
      }
      fprintf(fd,"\n");
      ++i;
    }
  } else {
    if (memlist != NULL && memlist[0] != NULL) {
      do {
	if (i != 0) {
	  fprintf(fd,", ");
	}
	fprintf(fd,"%s",memlist[i]);
	mem_realloc(memlist[i],0);
      } while (memlist[++i] != NULL);
    }
  }
  fprintf(fd,"\n");
  mem_realloc(memlist,0);
}
