/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#include "vncviewer.h"

void PrintXImageData(const XImage *image)
{
    int i,j;
    char nextByte;
    
    printf("GENERAL-INFO\n");
    printf("---------------\n");
    printf("\t XYBitmap code:%d\n", XYBitmap);
    printf("\t XYPixmap code:%d\n", XYPixmap);
    printf("\t ZPixmap code:%d\n", ZPixmap);
    printf("\n");
    printf("\t LSBFirst code:%d\n", LSBFirst);
    printf("\t MSBFirst code:%d\n", MSBFirst);
    printf("\n");
    printf("IMAGE-INFO\n");
    printf("---------------\n");
    printf("\t width:%d\n", image->width);
    printf("\t height:%d\n", image->height);
    printf("\t format:%d\n", image->format);
    printf("\t byte_order:%d\n", image->byte_order);
    printf("\t bitmap_unit:%d\n", image->bitmap_unit);
    printf("\t bitmap_bit_order:%d\n", image->bitmap_bit_order);
    printf("\t bitmap_pad:%d\n", image->bitmap_pad);
    printf("\t depth:%d\n", image->depth);
    printf("\t bytes_per_line:%d\n", image->bytes_per_line);
    printf("\t bits_per_pixel:%d\n", image->bits_per_pixel);
    printf("\t red_mask:%d\n", image->red_mask);
    printf("\t green_mask:%d\n", image->green_mask);
    printf("\t blue_mask:%d\n", image->blue_mask);
    printf("\n");
    printf("IMAGE-DATA\n");
    printf("---------------\n");
    for (i=0; i<image->height;i++){
	printf("new scanline\n");
	for (j=0; j<image->bytes_per_line;j++){
	    nextByte = i*image->bytes_per_line+j;
	    printf(" %X", image->f.get_pixel);
	}
    }
    printf("\n");
}

void FatalError(const char *filename, const char* str)
{
    fprintf(stderr, "FATAL ERROR: %s - %s\n", filename, str);
    exit(EXIT_FAILURE);
}
void Error(const char *filename, const char* str)
{
    fprintf(stderr, "FATAL ERROR: %s - %s\n", filename, str);
}
