/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#define FILE_NAME "record.c"

#include "vncviewer.h"

static FILE *recFile;
static fpos_t savedPos;
static double startTimeMillis;
static int firstFrame = 1, size;

static long totalSizeKb = 0, totalCompressedSizeKb = 0;

/* PRIVATE HELPER FUNCTIONS */
static void writeTimestamp()
{
  struct timeval tv;

  gettimeofday (&tv, NULL);
  tv.tv_sec = Swap32IfLE (tv.tv_sec);
  tv.tv_usec = Swap32IfLE (tv.tv_usec);
  fwrite (&tv, sizeof (struct timeval), 1, recFile);
}

/* PUBLIC FUNCTIONS */
void InitRecFile()
{
    /* set default filename if necessary */
    if (!appData.recFile)
	appData.recFile = DEFAULT_REC_FILENAME;
    
    /* write magic number */
    recFile = fopen(appData.recFile, "w");
    if (recFile == NULL){
	FatalError(FILE_NAME, "Failed to open recFile.");
    }	
    else{	
	if (!RecWriteString(MAGIC_NUMBER)) {
	    Error(FILE_NAME, "Error during writing of magic number.");
	}
    }
}

int RecSavePos()
{
    return fgetpos(recFile, &savedPos)==0?True:False;
}

fpos_t* RecGetSavedPos()
{
    return &savedPos;
}

int RecSetPos(fpos_t *pos)
{
    return fsetpos(recFile, pos)==0?True:False;
}

int RecGetPos(fpos_t* pos)
{
    return fgetpos(recFile, pos)==0?True:False;
}

int RecWriteString(const char* str)
{
    size_t retsize;
    
    if (!recFile)
	return False;
    
    retsize = fwrite(str, 1, strlen(str), recFile);
    
    return retsize==strlen(str);
}

int RecWriteU32(CARD32 num)
{
    size_t retsize;
    
    if (!recFile)
	return False;
        
    num = Swap32IfLE(num);
    
    retsize = fwrite((char*)&num, 1, sizeof(CARD32), recFile);
    
    return retsize==sizeof(CARD32);
}

/* same as U32 ?? */
int RecWriteS32(CARD32 num)
{
    size_t retsize;
    
    if (!recFile)
	return False;
        
    num = Swap32IfLE(num);
    
    retsize = fwrite((char*)&num, 1, sizeof(CARD32), recFile);
    
    return retsize==sizeof(CARD32);
}

int RecWriteU16(CARD16 num)
{
    size_t retsize;
    
    if (!recFile)
	return False;
        
    num = Swap16IfLE(num);
    
    retsize = fwrite((char*)&num, 1, sizeof(CARD16), recFile);
    
    return retsize==sizeof(CARD16);
}

int RecWriteU8(CARD8 num)
{
    size_t retsize;
    
    if (!recFile)
	return False;
    
    retsize = fwrite((char*)&num, 1, sizeof(CARD8), recFile);
    
    return retsize==sizeof(CARD8);
}

int RecWriteU8Array(CARD8 arr[], int size)
{
    size_t retsize;
    
    if (!recFile)
	return False;
    
    retsize = fwrite((char*)arr, 1, size, recFile);
    
    return retsize==size;
}

int RecFrameBufferUpdateHeader(CARD16 numRects)
{
    size_t retsize;
    
    if (!recFile)
	return False;
    
    writeTimestamp();
    RecWriteU16(numRects);
    
    return retsize==sizeof(CARD8);    
}

void CloseRecFile()
{
    if (recFile)
	fclose(recFile);
}

