/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#include <qmap.h>

#include <kaction.h>
#include <klocale.h>
#include <klanguagebutton.h>

#include "srkaddlanguagedialog.h"

//-----CONSTRUCTORS-----
SRKAddLanguageDialog::SRKAddLanguageDialog(QWidget* parent, const char* name, bool modal, WFlags fl)
: SRKAddLanguageDialogBase(parent,name, modal,fl)
{
    //fill the language-combo
    QStringList list = KGlobal::locale()->allLanguagesTwoAlpha();

    //We introduce a map to sort on full lang name (==key)
    typedef QMap<QString, QString> LangMap;
    LangMap map;
    
    //add the lang list to the map
    for (QStringList::Iterator it=list.begin();it!=list.end();it++) {
	QString longName = KGlobal::locale()->twoAlphaToLanguageName(*it);
	map[longName] = *it;
    }
    
    for (LangMap::Iterator it=map.begin();it!=map.end();it++) {
	// Uncomment this to generate an SQL-insert language list
	//cout << "INSERT INTO languages(code, name) VALUES('" << it.data() << "', '" << it.key() << "');" << endl;
	if (it.key()!="") {
	    languageCombo->insertItem(it.key(), it.data());
	}
	if (it.data()==KGlobal::locale()->defaultLanguage()) {
	    languageCombo->setCurrentItem(it.data());
	}
    }
}

//-----DESTRUCTOR-----
SRKAddLanguageDialog::~SRKAddLanguageDialog()
{
}

//-----PROTECTED SLOTS-----
void SRKAddLanguageDialog::reject()
{
  QDialog::reject();
}
void SRKAddLanguageDialog::accept()
{
  QDialog::accept();
}

#include "srkaddlanguagedialog.moc"

