/** 
 *
 * \mainpage SCTPLIB Documentation
 *
 *  \section introduction Documentation of SCTP Source Code
 * The current version of this SCTP projects implements SCTP according
 * to RFC 2960.
 * This RFC describes in section 1.3 a number of functional components of 
 * the protocol which each implementation would have to provide.
 * Consequently, we have adopted a module concept in our SCTP software
 * development project, which was partly derived from
 * an SDL specification we did from an earlier version of the draft.
 * \image HTML sctp-modules.png
 * \image LATEX sctp-modules.eps "SCTPLIB module concept" width=10cm
 *
 * The image presents the modules we implemented together with the 
 * approximate data/control flow.
 * We distinguish between SCTP instances (usually there will be one SCTP
 * instance per host - this is what we mostly tested),
 * and associations. Since an SCTP instance may connect to several SCTP
 * endpoints (i. e. it may have a number of established SCTP associations), 
 * it can have multiple instances of data structures belonging to an association.
 *
 * Therefore the data arriving from an upper layer protocol (ULP) or the
 * network must be dispatched accordingly to the correct
 * association. That is done by the \ref distribution 
 * "Association Distribution Layer".
 * The \ref adaptation "Adaptation Layer" takes care of network input and 
 * output as well as timer functions. The protocol can register call-back functions
 * associated with a timer, that will be called after a certain
 * time has passed.
 * 
 * So there are two kinds of events, that SCTP must react to :
 * \li Network Read Events
 * \li Timer Events
 * 
 * For both events the Association Distribution Layer sets the
 * correct association, and schedules the necessary functions. If data
 * arrives on the network, it is validated and then passed to the
 * \ref bundling "Bundling Module", where the single chunks that 
 * may be part of an SCTP packet
 * are passed on to the relevant module. That may be either :
 * \li SCTP Controller (see \ref sctpcontrol "SCTP Controller"), which 
 * deals with chunks that change the association's state
 * \li \ref recvctrl "SCTP Reception Controller", which keeps track of 
 * data chunks
 * \li \ref reltransfer "SCTP Retransmission Handler", that deals with SACK chunks
 * \li \ref pathmanagement "Path Management" for Heartbeat Chunks
 * 
 *  \section eventhandling Event Handling
 *  
 * Timer events trigger the execution of callback functions, often when a
 * timer expires that initializes re-transmission of data.
 * This is used for heartbeats, initialization and shutdown timers, timer
 * based ULP actions, the data re-transmission, the sending of delayed SACKs 
 * and the timed reduction of the congestion window if no data is to be sent.
 * 
 * If the association state changes, if data arrives or the ULP is to be
 * notified of a change of path state, data is passed
 * from the SCTP protocol instance to the ULP. Currently this is
 * implemented via function callbacks within one program (i.e.
 * the ULP has functions registered at the very beginning of the program,
 * that are to be called if some notification is due).
 *
 * Any data chunks that are received are held back in the 
 * Stream Engine, if they do not arrive in order. 
 * Normally the chunks are reordered at that level. All chunks are 
 * immediately being delivered up to the
 * highest stream sequence number that has consecutively arrived.
 */
