/* ScummVM - Scumm Interpreter
 * Copyright (C) 2006 The ScummVM project
 *
 * cinE Engine is (C) 2004-2005 by CinE Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-9-1/engines/cine/unpack.h $
 * $Id: unpack.h 21414 2006-03-23 03:45:52Z sev $
 *
 */

#ifndef CINE_UNPACK_H_
#define CINE_UNPACK_H_

#include "common/stdafx.h"
#include "common/scummsys.h"

namespace Cine {

struct UnpackCtx {
	int size, datasize;
	uint32 crc;
	uint32 chk;
	byte *dst;
	const byte *src;	
};

bool delphineUnpack(byte *dst, const byte *src, int len);

} // End of namespace Cine

#endif
