/*
 * memfreemax.c - return size of maximum unallocated heap block
 *
 * written by Vangelis Rokas <vrokas AT otenet.gr> 2005
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 * In other words, you are welcome to use, share and improve this program.
 * You are forbidden to forbid anyone else to use, share and improve
 * what you give them.   Help stamp out software-hoarding!  
 *
 * $Id: memfreemax.c,v 1.1 2005/03/31 16:24:45 vrokas Exp $
 */

#include <malloc.h>

extern unsigned char _MALLOC_SPEC *heap;

unsigned int memfreemax(void)
{
  _malloc_rec _MALLOC_SPEC *pHeap;
  unsigned int maxSize=0;

    pHeap = (_malloc_rec _MALLOC_SPEC *)&heap;
    
    while(pHeap->datum) {
      if(!pHeap->bits.alloc
        && pHeap->bits.count > maxSize)
          maxSize = pHeap->bits.count;
      
      pHeap = (_malloc_rec _MALLOC_SPEC *)((unsigned int)pHeap + pHeap->bits.count);
    }

  return (maxSize);
}
