#ifndef _LIBWRAPPER_HPP_
#define _LIBWRAPPER_HPP_

#include <string>
#include <vector>

#include "lib.h"

using std::string;
using std::vector;

//this structure is wrapper and it need for unification
//results of search whith return Dicts class
struct TSearchResult{
  string bookname;
  string def;
  string exp;

  TSearchResult(const string& bookname_, const string& def_, const string& exp_)
    : bookname(bookname_), def(def_), exp(exp_)
  {
  }
};

typedef vector<TSearchResult> TSearchResultList;
typedef TSearchResultList::iterator PSearchResult;

//this class is wrapper around Dicts class for easy use
//of it
class Library : public Dicts{
public:

  void SimpleLookup(const char *str, TSearchResultList& res_list);
  void LookupWithFuzzy(const char *str, TSearchResultList& res_list);
  void LookupWithRule(const char *str, TSearchResultList& res_lsit);
};

#endif//!_LIBWRAPPER_HPP_
