/* -------------------------------------------------------------

This file is a component of SDPA
Copyright (C) 2004-2012 SDPA Project

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

------------------------------------------------------------- */
// Here is the start of ``example5.cpp''
  
#include <cstdio>
#include <cstdlib>
#include <sdpa_call.h>

int main(int argc, char** argv)
{
  if (argc != 4) {
    fprintf(stderr, "%s [Input] [Output] [Param] \n", argv[0]);
    exit(EXIT_FAILURE);
  }

  SDPA Problem1;
  FILE* fpresult;
  if ((fpresult = fopen(argv[2],"w")) == NULL) {
    fprintf(stderr, "Cannot Open %s \n", argv[2]);
  }
  Problem1.setResultFile(fpresult);

  // fpresult records which file is read from argv[3]
  Problem1.readParameter(argv[3],fpresult);
  // Note that readParameter should be called before readInput
  // Otherwise initial point cannot be decided by lambdaStar
  Problem1.readInput(argv[1],fpresult,SDPA::AUTO);

  Problem1.initializeSolve();
  
  // All results and intermediate log are written into fpresult
  Problem1.solve();

  fclose(fpresult);
  Problem1.terminate();
  exit(0);
}
