#ifndef OBJUTILS_H
#define OBJUTILS_H

#include "obj.h"

extern int SARObjIsAllocated(
        sar_object_struct **ptr, int total,
        int n
);
extern sar_object_struct *SARObjGetPtr(
        sar_object_struct **ptr, int total,
        int n
);
extern int SARGetObjectNumberFromPointer(
        sar_scene_struct *scene,
        sar_object_struct **ptr, int total,
        sar_object_struct *obj_ptr
);
extern sar_object_struct *SARObjMatchPointerByName(
        sar_scene_struct *scene,
        sar_object_struct **ptr, int total,
        const char *name, int *obj_num
);

extern int SARIsTextureAllocated(
        sar_scene_struct *scene,
        int n
);
extern v3d_texture_ref_struct *SARGetTextureRefByName(
        sar_scene_struct *scene, const char *name
);
extern int SARGetTextureRefNumberByName(
        sar_scene_struct *scene, const char *name
);

extern int SARObjLandingGearState(sar_object_struct *obj_ptr);

extern sar_obj_part_struct *SARObjGetPartPtr(
        sar_object_struct *obj_ptr, int type, int skip
);
extern sar_obj_rotor_struct *SARObjGetRotorPtr(
        sar_object_struct *obj_ptr, int n, int *total
);
extern sar_obj_hoist_struct *SARObjGetHoistPtr(
        sar_object_struct *obj_ptr, int n, int *total
);
extern int SARObjGetOnBoardPtr(
        sar_object_struct *obj_ptr,
        int **crew, int **passengers, int **passengers_max,
	float **passengers_mass,
        int **passengers_leave_pending, int **passengers_drop_pending
);
extern sar_external_fueltank_struct *SARObjGetFuelTankPtr(
        sar_object_struct *obj_ptr, int n, int *total
);

extern sar_visual_model_struct *SARVisualModelNew(
        sar_scene_struct *scene,
        const char *filename, const char *name
);
extern void *SARVisualModelNewList(sar_visual_model_struct *vmodel);
extern int SARVisualModelGetRefCount(sar_visual_model_struct *vmodel);
extern void SARVisualModelRef(sar_visual_model_struct *vmodel);
extern void SARVisualModelUnref(
        sar_scene_struct *scene, sar_visual_model_struct *vmodel
);
extern void SARVisualModelCallList(sar_visual_model_struct *vmodel);
extern void SARVisualModelDeleteAll(sar_scene_struct *scene);

extern sar_cloud_layer_struct *SARCloudLayerCreate(
        sar_scene_struct *scene,
        int tile_width, int tile_height,
	float range,		/* Tiling range in meters. */
	float altitude,		/* Altitude in meters. */
        const char *tex_name
);
extern void SARCloudLayerDestroy(
        sar_scene_struct *scene,
        sar_cloud_layer_struct *cloud_layer_ptr
);

extern sar_cloud_bb_struct *SARCloudBBCreate(
        sar_scene_struct *scene,
        int tile_width, int tile_height,
        float x, float y, float z,   /* In meters. */
        float width, float height,    /* In meters. */
        const char *tex_name
);
extern void SARCloudBBDestroy(sar_cloud_bb_struct *cloud_bb_ptr);

extern int SARObjAddToGroundList(
        sar_scene_struct *scene,
        sar_object_struct *obj_ptr
);
extern void SARObjRemoveFromGroundList(
        sar_scene_struct *scene,
        sar_object_struct *obj_ptr
);
extern int SARObjAddToHumanRescueList(
        sar_scene_struct *scene,
        sar_object_struct *obj_ptr
);
extern void SARObjRemoveFromHumanRescueList(
        sar_scene_struct *scene,
        sar_object_struct *obj_ptr
);

extern int SARObjAddContactBoundsSpherical(
        sar_object_struct *obj_ptr,
        sar_obj_flags_t crash_flags, int crash_type,
	float contact_radius
);
extern int SARObjAddContactBoundsCylendrical(
        sar_object_struct *obj_ptr,
        sar_obj_flags_t crash_flags, int crash_type,
	float contact_radius,
	float contact_h_min, float contact_h_max
);
extern int SARObjAddContactBoundsRectangular(
        sar_object_struct *obj_ptr,
        sar_obj_flags_t crash_flags, int crash_type,
        float contact_x_min, float contact_x_max,
        float contact_y_min, float contact_y_max,
        float contact_z_min, float contact_z_max
);

extern int SARObjCreateIntercept(
        sar_scene_struct *scene,
        sar_obj_intercept_struct ***ptr, int *total,
        sar_obj_flags_t flags,
        float x, float y, float z,
        float radius,
        float urgency,
        const char *name
);
extern sar_obj_part_struct *SARObjCreatePart(
        sar_scene_struct *scene,
        sar_obj_part_struct ***ptr, int *total,
        int type                /* One of SAR_OBJ_PART_TYPE_*. */
);
extern sar_obj_part_struct *SARObjCreateAirBrake(
        sar_scene_struct *scene,
        sar_obj_part_struct ***ptr, int *total
);
extern sar_obj_part_struct *SARObjCreateDoorRescue(
        sar_scene_struct *scene,
        sar_obj_part_struct ***ptr, int *total
);
extern sar_obj_part_struct *SARObjCreateLandingGear(
        sar_scene_struct *scene,
        sar_obj_part_struct ***ptr, int *total
);
extern int SARObjCreateExternalFuelTanks(
        sar_scene_struct *scene,
        sar_external_fueltank_struct ***ptr, int *total
);
extern int SARObjCreateRotor(
        sar_scene_struct *scene,
        sar_obj_rotor_struct ***ptr, int *total
);
extern sar_light_struct *SARObjCreateLight(
        sar_scene_struct *scene,
        sar_light_struct ***ptr, int *total
);
extern int SARObjCreate(
        sar_scene_struct *scene,
        sar_object_struct ***ptr, int *total,
        int type
);

extern void SARObjDeleteIntercepts(
        sar_scene_struct *scene,
        sar_obj_intercept_struct ***ptr, int *total
);
extern void SARObjDeleteLights(
        sar_scene_struct *scene,
        sar_light_struct ***ptr, int *total
);
extern void SARObjDeleteParts(
        sar_scene_struct *scene,
        sar_obj_part_struct ***ptr, int *total
);
extern void SARObjDeleteExternalFuelTanks(
        sar_scene_struct *scene,
        sar_external_fueltank_struct ***ptr, int *total
);
extern void SARObjDeleteRotors(
        sar_scene_struct *scene,
        sar_obj_rotor_struct ***ptr, int *total
);
extern void SARObjDelete(
        void *core_ptr,
        sar_object_struct ***ptr, int *total,
        int n
);

extern void SARObjGenerateTilePlane(
        float min, float max, /* In meters. */
        float tile_width, float tile_height
);


#endif	/* OBJUTILS_H */
