/*  	"See": a neat-o superlite POSIX file and man page viewer
	Copyright 2008,2009 Mark Eriksen      	     Version 0.61

This program is free software: you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation, version 3 (or any later).  

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
General Public License for more details.  You should have received a copy of the GNU General 
Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.		*/

/* The binary executable must be called "seetxt" to function correctly */

#include <gtk/gtk.h>
#include <fcntl.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/un.h>
#include <ctype.h>
#include "see.h"

typedef struct {
	GtkWidget *wgt;
	GtkWidget *image1;
	GtkWidget *image2;
	int sw;
} forblink; forblink sff,wff;

typedef struct {
	char *txtfnt;
	int width;
	int height;
	const gchar *tbcolor;
} forconfig;

#define PAD 4		/* frame padding */

void addtohistory (char *line);
void apropos ();
void applytag (int Ts, int Te, char *tag);
gboolean blinktoggle (forblink *ff);
void bookmark_list();
void changewrapmode (GtkWidget *RButton, GtkWrapMode mode);
int check_seesock();
void clear(int opt);
int confirm_popup (char *title, char *messg);
void copytoX (GtkWidget *ignored, int opt); 
gint cursorline();
void cursor_tofound (GtkWidget *widget, int way);
gboolean delbmk (GtkWidget *treeview, GdkEventButton *MoBt, GtkListStore *liststore);
void destroy_widget (GtkWidget *widget, GtkWidget *dead);
gboolean DnDdrop (GtkWidget *widget, GdkDragContext *context, gint x, gint y, guint time, gpointer *NA); 
void DnDleave (GtkWidget *widget, GdkDragContext *context, guint time, gpointer *NA);
gboolean DnDmotion (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *seld, guint ttype, guint time, gpointer *NA);
void DnDreceive (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *seld, guint ttype, guint time, gpointer *data);
void dobmks (); 
void error_popup (char *messg); 
void exec_proc (); 
gboolean FentKpress (GtkWidget *widget, GdkEventKey *kyprs, gpointer *data);
void file_out (void); 
void fileselect (GtkTreeView *treeview, GtkTreePath *treepath, GtkTreeViewColumn *treecol, GtkWidget *swin); 
int fork_seesocket (int trip);
int getagcoords (GtkTextTag *tag, char *tagline);
void gotobmk ();
void grabfocus (GtkWidget *ignored);
void handlequit();
void help (void); 
void highlight (GtkWidget *widget, gchar *tag);
void loadfile (char *old, int setline);
gboolean loadlarge (int len); 
int loadlist (char list[27][MPTH+8]); 
void loadman (char *sec, char *old, int setline);
int loadnew (char *file, char *sec, int setline);
void mainmenu();
gboolean mousevent (GtkWidget *widget, GdkEventButton *MoBt, gpointer *data);
int nextfind (char *haystack, char *needle); 
gboolean nomax (GtkWidget *widget, GdkEventWindowState *ptr, gpointer *data); 
void numberlines ();
void placebmk ();
forconfig *reconfigure(GtkWidget *ignored, char *redo);
void removetags (GtkWidget *widget, gpointer *data); 
gboolean reload();
void savebmks (GtkWidget *widget, GtkWidget *subwin); 
void scrolltoline (GtkWidget *widget, gint line);
void searchlight ();
int send_remote (char *exename, char *sec, char *term);
void setwrapmode ();
void showconfig(char *font, int width, int height);
void showlist();
void sortbmarks();
gboolean tailfile ();
gboolean takecall(GIOChannel *source, GIOCondition *condition, gpointer *data); 
gboolean testuni (gunichar CHR, short int chr);
gchar *textline (int line);
void tglserv (int trip); 
void toedit ();
gboolean TxTKpress (GtkWidget *widget, GdkEventKey *kyprs, gpointer *data);
int update_filelist (char *sec, char *old, int lastline); 
void usage (char *name);
void usebmk (GtkTreeView *treeview, GtkTreePath *treepath, GtkTreeViewColumn *treecol, GtkWidget *swin);
void watchfile ();
	
			/* Global Variables */
GIOChannel *tochild;
GtkWidget *window, *TxT, *Vbox, *Hbox, *Hbox_0, *Fent, *numLbl, *FindBT, *CaseTgl, *regxTgl, *pushTgl, *MMenu, 
	*watchTgl, *watchoff, *watchon, *servTgl, *servoff, *servon, *mainframe, *textframe;
GtkTextBuffer *Tbuf;
GtkTextIter start, finish;
GtkTextMark *bmk;
GtkTextTag *norm, *hlite, *lnnm, *pushed, *boldblue, *italred, *hlink, *ctitle;
char *seefile=NULL, shortname[128]="\0", *seedata=NULL, sckt[107]="\0", *filelist=NULL, *FileCon=NULL, 
	*Editor=NULL, *CopyTo=NULL, **Fhist;
int TF[200000], totalF=0, histC=0, Chist=0, watchtime=10, remote=-1, TailAt=1000000, sfsz=0; /* sfsz not used with man pages */
gint *bookmarks=NULL; /* an array -- first element will be the number of elements */
pid_t sspid;
/*flags*/char DND=0, Settitle=1, Redirect=1, Config=0; gint LNsw=0, confflag=0, watchSW=0;

int main (int argc, char *argv[]) {
	const gchar *homedir=g_get_home_dir();
	char configfile[MPTH], *cwd=NULL, sec[4]="\0", image[256], *term=NULL, options[]="Kd:s:x:vh", *tmp=NULL, isserv=1;   
	PangoFontDescription *Tfont, *Nfont;
	int opt;
	GdkCursor *cursor, *crosshair;
	GdkColor textback;
	forconfig *cfig;

	if (strlen(homedir)>96) { puts("invalid home directory");
		exit (-6); }	/* because of socket() restriction length */
	if (strncmp(argv[0],"./",2)==0) argv[0]+=2; /* eg. if testing locally */ 
	if (strlen(argv[0])>63) return -8;
	strcpy(Me,argv[0]);	

	signal(SIGPIPE,SIG_IGN);
	
		/* parse ~/.seeconfig */
	cfig=reconfigure(NULL,0);
	if (sckt[0]=='\0') sprintf(sckt, "%s/.seesock",homedir);
	if (!(Editor)) { Editor=ec_malloc(6); strcpy(Editor,"gedit"); }
	if (!(seedata)) {
		seedata=ec_malloc(strlen(homedir)+10); 
		sprintf(seedata, "%s/.seedata",homedir);
		if ((opt=open(seedata,O_WRONLY|O_CREAT,S_IWRITE|S_IREAD))==-1) { free(seedata); seedata=NULL; }
		else close(opt);
	}
	
		/* command line arguments */
	if (argc>1) {
		if (strlen(argv[1])>MPTH-1) { puts("Filename is too long!"); return 0; }
		if (argv[1][0]!='-') tmp=argv[1]; /* filenames starting with a dash will need ./ */ 
		while ((opt=getopt(argc, argv, options))>0) switch (opt) {
			case ('?'): usage(argv[0]); return 0;
			case ('h'): usage(argv[0]); return 0;
			case ('K'): sprintf(image, "killall -9 seetxt & killall -9 seeman");
				system(image);
				return 0;   /* altho we already suicided */
			case ('d'): debug=atoi(optarg); break; 
			case ('s'): if ((strlen(optarg)>3) || (strcmp(argv[0],"seeman")!=0)) {usage(argv[0]); return 0;}
				strcpy(sec,optarg); break;
			case ('x'): term=ec_malloc(strlen(optarg)+1);
				strcpy(term,optarg); break;
			case ('v'): printf("%s version 0.61\n",argv[0]); return 0;
			default: usage(argv[0]); return 0;
		}
	}
		/* check for running server */
	switch (check_seesock()) {
		case -66: return -1;
		case -11: puts("!defunct seesocket won't unlink");
			close(remote); remote=-1; 
			break;
		case -1: if (tmp) {
			seefile=tmp; 
			switch (send_remote(argv[0], sec, term)) {
				case (-3): puts("improper response."); break;
				case (-2): puts("One of your arguments is too long."); break;
				default: break;}
			return 0; }
			else {	isserv=0;
				close(remote); remote=-1; }
		case 0: break;
		default: break;
	}

	/***** BEGIN GTK ******/	
    	gtk_init (&argc, &argv);
	
/*png*/	sprintf(image, "%s/seeon.png", SDIR);
	watchon=gtk_image_new_from_file(image);   
	g_object_ref(G_OBJECT(watchon));	
	servon=gtk_image_new_from_file(image);   
	g_object_ref(G_OBJECT(servon));	
	sprintf(image, "%s/seeoff.png",SDIR);
	servoff=gtk_image_new_from_file(image);   
	g_object_ref(G_OBJECT(servoff));	
	watchoff=gtk_image_new_from_file(image);   
	g_object_ref(G_OBJECT(watchoff));	
	
    	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    	g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (handlequit), NULL);
    	g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (gtk_main_quit), NULL);
 	g_signal_connect (G_OBJECT (window), "window-state-event", G_CALLBACK (nomax), NULL);

	Nfont = pango_font_description_copy(window->style->font_desc);
	pango_font_description_set_weight(Nfont,PANGO_WEIGHT_HEAVY);
	
/*menu*/MMenu = gtk_menu_new();
	mainmenu();

	Vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), Vbox);

		       /* the text area */
	TxT = gtk_text_view_new();
	gtk_widget_set_size_request(GTK_WIDGET (TxT), cfig->width, cfig->height);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(TxT),FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(TxT),GTK_WRAP_WORD);
	gtk_box_pack_start(GTK_BOX (Vbox), TxT, FALSE, FALSE, 0);
    	g_signal_connect (G_OBJECT (TxT), "button_press_event", G_CALLBACK (mousevent), NULL);
/*DnD*/	gtk_drag_dest_set(TxT,GTK_DEST_DEFAULT_ALL,NULL,0,GDK_ACTION_COPY);
	gtk_drag_dest_add_text_targets(TxT);
	gtk_drag_dest_add_uri_targets(TxT);
	g_signal_connect(TxT,"drag-drop",G_CALLBACK(DnDdrop),NULL);
	g_signal_connect(TxT,"drag-motion",G_CALLBACK(DnDmotion),NULL);
	g_signal_connect(TxT,"drag-data-received",G_CALLBACK(DnDreceive),NULL);
        g_signal_connect (TxT, "drag-leave",G_CALLBACK(DnDleave),NULL);
	if (cfig->txtfnt) { Tfont = pango_font_description_from_string(cfig->txtfnt);
		gtk_widget_modify_font(TxT,Tfont);
		pango_font_description_free(Tfont); }
	if (cfig->tbcolor) {
		if (gdk_color_parse(cfig->tbcolor, &textback)) gtk_widget_modify_base(TxT, GTK_STATE_NORMAL, &textback);
		free((char*)cfig->tbcolor); }
	
			/* the text buffer */
	Tbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW (TxT));
	italred = gtk_text_buffer_create_tag (Tbuf, "italred", "foreground","#ff0000", "style",PANGO_STYLE_ITALIC, NULL);
	boldblue = gtk_text_buffer_create_tag (Tbuf, "boldblue", "foreground","#0000bb", "weight",PANGO_WEIGHT_BOLD, NULL);
    	hlink = gtk_text_buffer_create_tag (Tbuf, "hyperlinks", "foreground","#00aa00", "underline",PANGO_UNDERLINE_DOUBLE, NULL);
	pushed = gtk_text_buffer_create_tag (Tbuf, "pushed", "foreground","#ffff00", "background","#aa00aa", NULL);
/*tags*/hlite = gtk_text_buffer_create_tag (Tbuf, "highlights", "foreground","#aa00aa", "background","#ffff00", NULL);
	lnnm = gtk_text_buffer_create_tag (Tbuf, "line_numbers", "foreground","#00ffaa", NULL);
	ctitle = gtk_text_buffer_create_tag (Tbuf, "center_title", "justification",GTK_JUSTIFY_CENTER, "weight",700, NULL);

	Hbox_0 = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_end (GTK_BOX (Vbox), Hbox_0, TRUE, TRUE, PAD);
	
	servTgl = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(servTgl),servoff);
	sff.wgt=servTgl; sff.image1=servoff; sff.image2=servon; sff.sw=0;
	gtk_button_set_relief(GTK_BUTTON(servTgl),GTK_RELIEF_NONE);
	gtk_box_pack_start(GTK_BOX (Hbox_0), servTgl, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (servTgl), "clicked", G_CALLBACK (tglserv), (gpointer*)1);
    	g_signal_connect (G_OBJECT (TxT), "key_press_event", G_CALLBACK (TxTKpress), NULL);
	g_signal_connect(servTgl,"drag-data-received",G_CALLBACK(DnDreceive),NULL);
	
	mainframe = gtk_frame_new(NULL);
	gtk_box_pack_start (GTK_BOX (Hbox_0), mainframe, TRUE, TRUE, PAD);
	Hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (mainframe), Hbox);
	
	pushTgl = gtk_toggle_button_new_with_label ("push");
	gtk_box_pack_start(GTK_BOX (Hbox), pushTgl, TRUE, TRUE, PAD);

	numLbl = gtk_label_new("0");
	gtk_box_pack_start(GTK_BOX (Hbox), numLbl, FALSE, FALSE, PAD);
	gtk_widget_modify_font(numLbl,Nfont);
	pango_font_description_free(Nfont);
	gtk_label_set_width_chars(GTK_LABEL(numLbl),6);
	
			/* the user entry */
	Fent = gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(Fent),4096);	
	gtk_entry_set_has_frame(GTK_ENTRY(Fent),TRUE);
	gtk_entry_set_width_chars(GTK_ENTRY(Fent),27);
	gtk_box_pack_start(GTK_BOX (Hbox), Fent, TRUE, TRUE, PAD);
    	g_signal_connect (G_OBJECT (Fent), "key_press_event", G_CALLBACK (FentKpress), NULL);
	
	CaseTgl = gtk_toggle_button_new_with_label ("case");
	gtk_box_pack_start(GTK_BOX (Hbox), CaseTgl, TRUE, TRUE, PAD);
	
	regxTgl = gtk_toggle_button_new_with_label ("regexp");
	gtk_box_pack_start(GTK_BOX (Hbox), regxTgl, TRUE, TRUE, PAD);
	
	watchTgl = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(watchTgl),watchoff);
	wff.wgt=watchTgl; wff.image1=watchoff; wff.image2=watchon; wff.sw=0;
	gtk_button_set_relief(GTK_BUTTON(watchTgl),GTK_RELIEF_NONE);
	gtk_box_pack_end (GTK_BOX (Hbox_0), watchTgl, FALSE, FALSE, PAD);
	g_signal_connect (G_OBJECT (watchTgl), "clicked", G_CALLBACK (watchfile), NULL);

	gtk_widget_show(servon);	
	gtk_widget_show(servoff);	
	gtk_widget_show(watchon);	
	gtk_widget_show(watchoff);	
	gtk_widget_show_all(window);
		/* then because the widgets must be "realized" first: */
	cursor = gdk_cursor_new(GDK_BOX_SPIRAL);  	
	gdk_window_set_cursor(window->window, cursor);
	gdk_cursor_unref(cursor);	

	crosshair = gdk_cursor_new(GDK_CROSSHAIR);  	
	gdk_window_set_cursor (gtk_text_view_get_window (GTK_TEXT_VIEW(TxT), GTK_TEXT_WINDOW_TEXT), crosshair);   
	gdk_cursor_unref(crosshair);	

	gtk_window_set_title(GTK_WINDOW (window), argv[0]);
		
	if (!(filelist)) {
		filelist=ec_malloc(strlen(SDIR)+16);
		strcpy(filelist,SDIR);
		strcat(filelist,"/filelist");
	}				 

		/* load file, prefix path */	
	if (tmp) {
		if ((strcmp(argv[0],"seetxt")==0) && (tmp[0]!='/')) { 	/* leave ./ on for out of tree man pages */
			cwd=getcwd(NULL,0);				/* nb. getopt has moved argv[1] */
			if (strncmp(tmp,"./",2)==0) tmp+=2;	
			sprintf(configfile,"%s/%s",cwd,tmp);	/* reusing "configfile" */
			if (strlen(configfile)>MPTH-1) { puts("File path too long!"); return 0; }	
			free(cwd);
			tmp=configfile;
		}
		if (sec[0]!=0) loadnew(tmp,sec,0);
		else loadnew(tmp,NULL,0);	 /* loadnew() discerns man from text by the presence or absence of the fullpath */
		if (term) {		
			gtk_entry_set_text(GTK_ENTRY(Fent), term);
			searchlight();
			free(term);
	}	}	 
	else showconfig(cfig->txtfnt,cfig->width,cfig->height);
	free(cfig);
	if (debug>1) g_print("%s pid %d (debug level %d)\n", argv[0], getpid(), debug);

	if (isserv>0) tglserv(0);	
    	gtk_main ();
    	return 0;
}

void addtohistory (char *line) {	/* histC is the number of lines in history */
	int i;				/* Chist is the current line */
	for (i=0; i<histC; i++) {
		if (strcmp(Fhist[i],line)==0) {
			Chist=i; return; }
	}	/* entry exits already */

	Fhist=realloc(Fhist,(histC+1)*sizeof(char*));			
	if (!(Fhist)) error_popup("WARNING: Out of memory"); 
	Fhist[histC] = ec_malloc(strlen(line)+1);
	strcpy(Fhist[histC],line);
	histC++;
	Chist=histC; 
}

void apropos () {	/* called from mainmenu()...clickable entries are returned by mousevent() */
	char *string, *tok;
	const gchar *term = gtk_entry_get_text(GTK_ENTRY(Fent));
	int len = strlen(term);
	FILE *fstIN;
	GtkTextIter end;
	GdkCursor *hand=gdk_cursor_new(GDK_HAND2);
	
	if (len == 0) return;
	string=ec_malloc(len+23);
	sprintf(string, "Apropos search for \"%s\"?",term);
	if((confirm_popup("Confirm",string)) == -6) {free(string);return;}
	free(string);
	addtohistory((char*)term);
	
	string=ec_malloc(len+11);
	sprintf(string, "apropos \"%s\"", term);
	if ((fstIN = popen(string, "r")) == NULL) {
		free(string);
		error_popup("apropos failed"); 
		return;}
	free(string);
	clear(1);	
	gtk_text_buffer_get_end_iter(Tbuf,&end);
	while ((string=linein(fstIN)) != NULL) {
		tok=strtok(string," ");
            	gtk_text_buffer_insert_with_tags(Tbuf,&end,(const gchar*)tok,-1,hlink,NULL);
		tok=strtok(NULL," ");
            	gtk_text_buffer_insert_with_tags(Tbuf,&end,(const gchar*)tok,-1,lnnm,NULL);
		tok=strtok(NULL,"");
		gtk_text_buffer_insert(Tbuf,&end,(const gchar*)tok,-1);
		free(string);
	}
	if ((pclose(fstIN)) != 0) error_popup("pclose fail in apropos()");
	gdk_window_set_cursor (gtk_text_view_get_window (GTK_TEXT_VIEW(TxT), GTK_TEXT_WINDOW_TEXT), hand);   
	gdk_cursor_unref(hand);	
}


void applytag (int Ts, int Te, char *tag) {   /* called from dobmks() */
	GtkTextIter tagS, tagE;
	if (debug>0) g_print("applytag()...");
	gtk_text_buffer_get_iter_at_offset(Tbuf,&tagS,Ts);
	gtk_text_buffer_get_iter_at_offset(Tbuf,&tagE,Te);
	gtk_text_buffer_apply_tag_by_name(Tbuf, tag, &tagS, &tagE); 
}


gboolean blinktoggle (forblink *ff) {
	if (ff->sw==0) {
		gtk_container_remove(GTK_CONTAINER(ff->wgt), ff->image1);
		gtk_container_add(GTK_CONTAINER(ff->wgt), ff->image2);
		ff->sw=1;
	} else {	
		gtk_container_remove(GTK_CONTAINER(ff->wgt), ff->image2);
		gtk_container_add(GTK_CONTAINER(ff->wgt), ff->image1);
		ff->sw=0;}
	return TRUE;
}


void bookmark_list () {		/* called from mainmenu() */
	int i, ii;
	GtkListStore *liststore = gtk_list_store_new(2,G_TYPE_INT,G_TYPE_STRING);
	GtkWidget *subwin = gtk_window_new(GTK_WINDOW_POPUP), 
		*bmkLV = gtk_tree_view_new_with_model(GTK_TREE_MODEL(liststore)),
		*frame = gtk_frame_new("Bookmarks"),
		*flab = gtk_frame_get_label_widget(GTK_FRAME(frame)),
		*BMVbox = gtk_vbox_new (FALSE, PAD),
		*BMHbox = gtk_hbox_new (FALSE, PAD),
		*DisBT = gtk_button_new_with_label("Dismiss");
	GtkCellRenderer *render;	
	GtkTreeViewColumn *column;	
	GtkTreeIter Litr;
	PangoAttrList *atrb=pango_attr_list_new();
	PangoAttribute *ubold=pango_attr_weight_new(PANGO_WEIGHT_ULTRABOLD);
	gchar *ptr, snippet[32];

	if (!(seefile)) return;
	if (debug>0) g_print("bookmark_list() %d...\n",bookmarks[0]);	
	
	gtk_window_set_transient_for(GTK_WINDOW(subwin),GTK_WINDOW(window));   
	gtk_window_set_position(GTK_WINDOW(subwin), GTK_WIN_POS_CENTER_ON_PARENT);	
	gtk_container_add(GTK_CONTAINER (subwin), frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame),PAD);
	gtk_container_add(GTK_CONTAINER (frame), BMVbox);
	ubold->start_index=0;
	ubold->end_index=10;
	pango_attr_list_insert(atrb,ubold);
	gtk_label_set_attributes(GTK_LABEL(flab),atrb);
	
	gtk_box_pack_start(GTK_BOX (BMVbox), bmkLV, FALSE, FALSE, PAD);
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(bmkLV), FALSE);
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(bmkLV), TRUE);
	render = gtk_cell_renderer_text_new();
	g_object_set(G_OBJECT(render), "foreground", "Red", "foreground-set", TRUE,NULL);
	column = gtk_tree_view_column_new_with_attributes("LN", render, "text", 0, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(bmkLV), column);
	render = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("text", render, "text", 1, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(bmkLV), column);
	g_signal_connect(bmkLV, "row-activated", G_CALLBACK(usebmk), subwin);
	g_signal_connect(bmkLV, "button-press-event", G_CALLBACK(delbmk), liststore);

	gtk_box_pack_start(GTK_BOX (BMVbox), BMHbox, FALSE, FALSE, PAD);
	
	gtk_box_pack_start(GTK_BOX (BMHbox), DisBT, FALSE, FALSE, PAD);
	g_signal_connect(DisBT, "clicked", G_CALLBACK(destroy_widget), subwin);

	if (bookmarks[0]>1) sortintray(&bookmarks[1],bookmarks[0]);
	for (i=1;i<=bookmarks[0];i++) {
		if (bookmarks[i]==0) continue;	/* was deleted via delbmk() */
		if (!(ptr=textline(bookmarks[i]))) sprintf(snippet, "LINE NUMBER INVALID");
		else for (ii=0;ii<31;ii++) {		/* create index line */
			snippet[ii]=ptr[ii];
		}
		snippet[ii]='\0';
		if (debug>1) g_print("\tsnippet=\"%s\"",snippet);	
		gtk_list_store_append(liststore,&Litr);
		gtk_list_store_set(liststore, &Litr, 0,bookmarks[i], 1,snippet, -1);		
	}

	gtk_widget_show_all(subwin);	
}


void changewrapmode (GtkWidget *RButton, GtkWrapMode mode) {
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(RButton)) == TRUE) gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(TxT),mode);
}


int check_seesock () { 	/* called from main() or tglserv() */
	char messg[9];
	int retv;
	struct sockaddr_un addr;
	size_t size;
	switch (file_check(sckt)) {
		case -2: return 0;      /* socket does not exist */
		case  0: puts("Abnormal output from stat on seesocket");
			 return -66; 
		case 49152: 
			break;	/* socket exists */ 
		default: if (unlink(sckt)<0) return -11;
			else return 0;}
	remote=socket(PF_LOCAL,SOCK_STREAM,0);
	addr.sun_family=AF_LOCAL;
	strcpy(addr.sun_path,sckt);
	size=SUN_LEN(&addr);
	if (connect(remote,(struct sockaddr*)&addr,size)==0) { 
		if ((read(remote,messg,9)>6) && (strncmp(messg,"XOSEESOX",8)==0)) {
			write(remote,"CHECK\n",6);
			if ((read(remote,messg,5)>3) && (strncmp(messg,"HERE",4)==0)) { 
				puts("See server running");
				return -1;
		}	}  	}
	close(remote); remote=-1;
	if ((retv=unlink(sckt))<0) return -11;
	return 0;
}

void clear (int opt) {		
	/* nb. that there is no record of the tags (except for the seedata) */
	gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
	gtk_text_buffer_delete(Tbuf,&start,&finish);
	if (FileCon) {free(FileCon);FileCon=NULL;}
	if ((opt) && (seefile)) {free(seefile);seefile=NULL;}
	if (bookmarks) {free(bookmarks);bookmarks=NULL;}
	shortname[0]='\0';
	sfsz=0;
	LNsw=0;
	if (debug>0) { g_print("clear(%d) done\n",opt); fflush(stdout); }
}

	
int confirm_popup (char *title, char *messg) {
	int respv;
	GtkWidget *textLbl, *dialgBx = gtk_dialog_new_with_buttons (title,GTK_WINDOW(window),
		GTK_DIALOG_NO_SEPARATOR,GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,GTK_STOCK_OK,GTK_RESPONSE_OK,NULL);
	if (Settitle) gtk_window_set_title(GTK_WINDOW (window), "Waiting for confirmation");
	gtk_window_set_position(GTK_WINDOW(dialgBx), GTK_WIN_POS_CENTER_ON_PARENT);	
	textLbl = gtk_label_new_with_mnemonic(messg);
	gtk_label_set_justify(GTK_LABEL(textLbl),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG(dialgBx)->vbox), textLbl, FALSE, FALSE, 0);
	gtk_widget_show(textLbl);
	respv = gtk_dialog_run(GTK_DIALOG(dialgBx));
	gtk_widget_destroy(dialgBx);
	gtk_window_set_title(GTK_WINDOW (window), "...okay");
	return respv;	/* -6 if "Cancel", -5 if "OK" */
}	


void copytoX (GtkWidget *ignored, int opt) {
	GdkDisplay *display = gdk_display_get_default();
	GtkClipboard *clipboard = gtk_clipboard_get_for_display(display,GDK_SELECTION_CLIPBOARD);
	if (opt) { gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
		gtk_text_buffer_select_range(Tbuf,(const GtkTextIter*)&start,(const GtkTextIter*)&finish); }
	gtk_text_buffer_copy_clipboard(Tbuf,clipboard); 
}


void cursor_tofound (GtkWidget *widget, int way) {
	gint oset, i, sw=0;
	GtkTextMark *mk=gtk_text_buffer_get_insert(Tbuf); 
	GtkTextIter itr;
	if (totalF == 0) return;
	gtk_widget_grab_focus(TxT);
	gtk_text_buffer_get_iter_at_mark(Tbuf,&itr,mk); 

	if (LNsw==1) {	
		numberlines();	
		sw = 1;
	}	

	oset = gtk_text_iter_get_offset(&itr);

	if (way==0) {			/* forward */
		for (i=0; i <= (totalF*2)-1; i+=2) {
			if (TF[i] > oset) { 
				gtk_text_buffer_get_iter_at_offset(Tbuf,&itr,TF[i]);
				gtk_text_view_scroll_to_iter(GTK_TEXT_VIEW(TxT),&itr,0.0,TRUE,0.5,0.5);
				gtk_text_buffer_place_cursor(Tbuf,&itr);
				break; }
		}
	} else {			/* back */
		for (i=(totalF*2)-1; i>=0;i-=2) {
			if (TF[i] < oset) { 
				gtk_text_buffer_get_iter_at_offset(Tbuf,&itr,TF[i]);
				gtk_text_view_scroll_to_iter(GTK_TEXT_VIEW(TxT),&itr,0.0,TRUE,0.5,0.5);
				gtk_text_buffer_place_cursor(Tbuf,&itr);
				break; }
		}
	}	  
		
	if (sw == 1) numberlines();
}

gint cursorline() {
	GtkTextIter where; 
	gint pos, line;
	
	g_object_get(Tbuf,"cursor-position",&pos,NULL);
	gtk_text_buffer_get_iter_at_offset(Tbuf, &where, pos);
	line=gtk_text_iter_get_line(&where);
	
	return line;
}


gboolean delbmk (GtkWidget *treeview, GdkEventButton *MoBt, GtkListStore *liststore) { /* called from bookmarks() */	
	GtkTreeIter itr;
	GtkTreeModel *Tmod=gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));
	GtkTreeSelection *selected=gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	int ln, i;

	if (MoBt->button == 2) {
		gtk_tree_selection_get_selected(selected,&Tmod,&itr);
		gtk_tree_model_get(Tmod, &itr, 0, &ln, -1);
		for (i=1;i<=bookmarks[0];i++) if (bookmarks[i] == ln) { bookmarks[i]=0; bookmarks[0]--; break;}
		gtk_list_store_set(liststore, &itr, 0,0, -1);
		gtk_list_store_set(liststore, &itr, 1,"", -1);
		savebmks(NULL,NULL);
		return TRUE;			
	} else return FALSE;
} 


void destroy_widget (GtkWidget *widget, GtkWidget *dead) {
	gtk_widget_destroy(dead);
} 


gboolean DnDdrop (GtkWidget *widget, GdkDragContext *context, gint x, gint y, guint time, gpointer *NA) {
        GdkAtom target_type;
	if (debug>2) { g_print("\tDnDdrop()\t"); fflush(stdout); }
        if (context-> targets) {
/* adapted from "TestDnD - main.c : Simple tutorial for GTK+ Drag-N-Drop" Copyright (C) 2005 Ryan McDougall */
/* GNU General Public License http://live.gnome.org/GnomeLove/DragNDropTutorial */
                target_type = GDK_POINTER_TO_ATOM (g_list_nth_data (context-> targets, 0)); /* Choose the best target type */
		gtk_drag_get_data (
			TxT,         /* we will receive 'drag-data-received' signal */
			context,        /* represents the current state of the DnD */
			target_type,    /* the target type we want */
			time            /* our time stamp */
		);
	}
	else return FALSE;  	/* cancel */
	return TRUE;
}


void DnDleave (GtkWidget *widget, GdkDragContext *context, guint time, gpointer *NA) {
	gtk_text_view_set_editable(GTK_TEXT_VIEW(TxT),FALSE);	/* read-only fowls drag n' drop */
	if (debug>2) { g_print("\tDnDleave()\t"); fflush(stdout); }
	DND=0;
}
	 

gboolean DnDmotion (GtkWidget *widget, GdkDragContext *context, gint x, gint y, 
GtkSelectionData *seld, guint ttype, guint time, gpointer *NA) {
	if (DND) return TRUE;
	if (debug>2) { g_print("\tDnDmotion()\t"); fflush(stdout); }
	gtk_text_view_set_editable(GTK_TEXT_VIEW(TxT),TRUE);	/* read-only fowls drag n' drop */
	DND=1;
	return TRUE;
}


void DnDreceive (GtkWidget *widget, GdkDragContext *context, gint x, gint y, 
GtkSelectionData *data, guint ttype, guint time, gpointer *NA) {
	gboolean got=TRUE;	/* FALSE will bounce inappropriate data */
	gchar *ptr=(char*)data->data;
	if (!(ptr)) { gtk_drag_finish (context, FALSE, FALSE, time); return; }
	if (debug>1) { g_print("\nDnDrecieve() \"%s\"\n",ptr); fflush(stdout); }
	if ((strncmp(ptr,"file:///",8)!=0) || (strlen(ptr)>MPTH)) got=FALSE;
        gtk_drag_finish (context, got, FALSE, time); /* we are responsible for this completion */
	if (got) { ptr+=(7*sizeof(char)); ptr=defluff(ptr); loadnew(ptr,NULL,0); free(ptr); }	
}


void dobmks () {	/* loads bookmarks, called from loadman() or loadfile() */
	int Ts, Te;	/* also qv. placebmk() and savebmks()	*/
	int i=1, type;
	char *line=NULL, *tok, messg[MPTH+16], DL[]="*\n";
	if (seefile[0]=='/') line=returnline(seedata,seefile); 
	else line=returnline(seedata,shortname); /* man page shortname has section number, eg. "man(1)" */
	
	if (line) {
		tok=strtok(line,DL); 
		tok=strtok(NULL,DL);	
		if (tok[0]=='0') {  /* ie. no bookmarks */
			bookmarks=ec_malloc(sizeof(int));
			bookmarks[0]=0;
			if (!(tok=strtok(NULL,DL))) return;		
		} else {bookmarks=ec_malloc(atoi(tok)+1);
			bookmarks[0]=atoi(tok);
			while ((tok=strtok(NULL,DL)) && (tok[0]!='R') && (tok[0]!='B')) {
				bookmarks[i]=atoi(tok);
				if (debug>1) g_print("domks() #=%d i=%d bm=%d\n",bookmarks[0],i,bookmarks[i]);
				i++;}
			if (!(tok)) return; }
	/* now the highlights */		
		if (tok[0]=='R') type=0;
		else if (tok[0]=='B') type=1;
		else {	sprintf(messg, "Corrupted entry in\n%s!",seedata);
			error_popup(messg);
			return; }
		while ((tok=strtok(NULL,DL))) {
			if (tok[0]=='R') type=0;
			else if (tok[0]=='B') type=1;
			else { 	Ts=atoi(tok);	/* these numbers should be paired */
				if (!(Te=atoi(strtok(NULL,DL)))) return;  /* missing one? ...oh well */ 
				if (type==1) applytag(Ts,Te,"boldblue");
				else applytag(Ts,Te,"italred"); }
			if (debug>1) g_print("domks() type=%d Ts=%d Te=%d\n",type,Ts,Te); 
		}		 
		free(line); 
	} else {bookmarks=ec_malloc(sizeof(int));
		bookmarks[0]=0;}
	if (debug>0) g_print("end domks()\n"); 
}


void error_popup (char *messg) {
	char title[12]=" See/Error ";
	GtkWidget *textLbl, *dialgBx = gtk_dialog_new_with_buttons (title,GTK_WINDOW(window),GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_OK,NULL);
	gtk_window_set_title(GTK_WINDOW (window), "!Error");
	gtk_widget_set_size_request(GTK_WIDGET (dialgBx), 300,250);
	textLbl = gtk_label_new_with_mnemonic(messg);
	gtk_label_set_justify(GTK_LABEL(textLbl),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG(dialgBx)->vbox), textLbl, FALSE, FALSE, 0);
	gtk_widget_show(textLbl);
	gtk_dialog_run(GTK_DIALOG(dialgBx));
	gtk_widget_destroy(dialgBx);
	gtk_window_set_title(GTK_WINDOW (window), "...okay");
}	


void exec_proc () {
	GtkTextIter begin, end;
	gboolean sel=gtk_text_buffer_get_selection_bounds(Tbuf,&begin,&end);
	int i, len;
	FILE *pin, *tfp;
	const gchar *term = gtk_entry_get_text(GTK_ENTRY(Fent)), *homedir;
	char *ptr, *tfile, flag=0, *text=NULL, *cmmd, *line;
	if ((!(term)) || ((strlen(term))==0)) return;
	
	addtohistory((char*)term);
	cmmd=ec_malloc(strlen(term)+16);
	sprintf(cmmd,"Execute:\n%s",term);
	if (confirm_popup("See Operation",cmmd)==-6) { free(cmmd); return; }
	free(cmmd);

	if (debug>0) { g_print("exec_proc() +%s+",term); fflush(stdout); }

			/* write temp file if necessary */
	if ((strstr(term,"SEEBUF"))) {
		homedir=g_get_home_dir();
		tfile=ec_malloc(strlen(homedir)+16);
		sprintf(tfile,"%s/.seeTMP",homedir);
		if (!(tfp=fopen(tfile,"w"))) { 
			error_popup("Could not\ncreate temp file!"); return; }
		cmmd=strsub(term,tfile);
		if ((!(sel)) && (!(FileCon))) {
			gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
			FileCon=gtk_text_buffer_get_text(Tbuf,&start,&finish,FALSE);
			text=FileCon; }
		else if (sel) { text=gtk_text_buffer_get_text(Tbuf,&begin,&end,FALSE); flag++; }
		else text=FileCon;
		len=strlen(text);
		for (i=0;i<len;i++) fputc(text[i],tfp);
		flag++;			
		fclose(tfp); } 		
	else {  cmmd=ec_malloc(strlen(term)+8); 
		strcpy(cmmd,term); }
	if (Redirect) strcat(cmmd," 2>&1");  /* redirect stderr */
			/* save our position in current file if necessary */
	if (seefile) {
		ptr=ec_malloc(strlen(seefile)+1);
		strcpy(ptr,seefile);
		free(seefile); seefile=NULL;
		i=cursorline();
		update_filelist(NULL, ptr, i);
		free(ptr);
	}
			/* execute and pipe output into text buffer */
	clear(0);
	if (debug>1) { g_print("...cmmd=\"%s\"...",cmmd); fflush(stdout); }	
	pin=popen(cmmd,"r");
	gtk_text_buffer_get_end_iter(Tbuf,&finish);
	while ((line=linein(pin))) {
		gtk_text_buffer_insert(Tbuf,&finish,(const gchar*)line,-1);
		while(gtk_events_pending()) gtk_main_iteration();	
		free(line); }
	line=ec_malloc(64);
	sprintf(line, "Process returned %d",pclose(pin));
	gtk_window_set_title(GTK_WINDOW (window), line);
	free(line);
		
	if (FileCon) free(FileCon); FileCon=NULL;

	free (cmmd);
	if (flag>0) { unlink(tfile); free(tfile); }
	if (flag==2) free(text);
	if (debug>0) { g_print("...exec_proc() DONE\n"); fflush(stdout); }
}
	

gboolean FentKpress (GtkWidget *widget, GdkEventKey *kyprs, gpointer *data) {
	switch(kyprs->keyval) {
		case GDK_Up:		/* command history */
			if (histC==0) return TRUE; 
			if (Chist <= 0) Chist=histC-1;
			else Chist--;
			gtk_entry_set_text(GTK_ENTRY(Fent),Fhist[Chist]);
			return TRUE;
	 	case GDK_Down:
			if (histC==0) return TRUE; 
			Chist++;
			if (Chist >= histC) { 
				gtk_entry_set_text(GTK_ENTRY(Fent),"");
				Chist = -1;
				return TRUE;} 
			gtk_entry_set_text(GTK_ENTRY(Fent),Fhist[Chist]);
			return TRUE;
		case GDK_Return:
			searchlight();
			return TRUE;
		default:
			return FALSE; 
	}		/* otherwise there will be no typing in Fent */
	return FALSE;
}


void file_out (void) {		/* callable from mainmenu() if CopyTo exists */
	GtkTextIter begin, end;
	gboolean sel=gtk_text_buffer_get_selection_bounds(Tbuf,&begin,&end);
	int ip;
	char messg[MPTH+256], name[MPTH], *rp, flag=0, *ptr;
	const gchar *term = gtk_entry_get_text(GTK_ENTRY(Fent));
	if (strlen(term)==0) { error_popup("You must give a file name\nin the text entry."); return; }
	addtohistory((char*)term);
	if (strlen(CopyTo)+strlen(term)>=MPTH) { error_popup("File + path name too long."); return; }
	if (debug>0) { g_print("file_out() +%s+",term); fflush(stdout); }
				/* confirm */
	sprintf(name, "%s/%s", CopyTo,term);
	if (sel) sprintf(messg,"Copy selected text to\n\"%s/%s\"?",CopyTo,term);
	else sprintf(messg,"Copy text buffer content to\n\"%s/%s\"?",CopyTo,term);
	if (confirm_popup("See Operation",messg)==-6) return;
				/* get the text */	
	if ((!(sel)) && (!(FileCon))){
		gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
		FileCon=gtk_text_buffer_get_text(Tbuf,&start,&finish,FALSE);
		flag=1;
	}
	if (sel) { ptr=gtk_text_buffer_get_text(Tbuf,&begin,&end,FALSE); flag=2; }
	else ptr=FileCon;
				/* write to file */
	if ((rp=writeout(ptr,name,&ip))) {
		sprintf(messg, "Copy failed:\n%s",rp);
		error_popup(messg); 
		return; }
	Settitle=0;
	if (ip!=strlen(ptr)) gtk_window_set_title(GTK_WINDOW (window), "Copy Incomplete!");
	else gtk_window_set_title(GTK_WINDOW (window), "Copy Complete");
	loadnew(name,NULL,0); 
	Settitle=1;
	if (flag==1) { free(FileCon); FileCon=NULL; }
	if (flag==2) free(ptr);
	if (debug>0) { g_print("...file_out() DONE"); fflush(stdout); }
}
	

void fileselect (GtkTreeView *treeview, GtkTreePath *treepath, GtkTreeViewColumn *treecol, GtkWidget *swin) {
	int len, i, setline=0;
	char list[27][MPTH+8], *ptr;
	gchar *file, name[64], sec[5];
	GtkTreeModel *Tmod=gtk_tree_view_get_model(treeview);
	GtkTreeIter itr;
	if (gtk_tree_model_get_iter (Tmod, &itr, treepath)) gtk_tree_model_get(Tmod, &itr, 0, &file, -1);
	else return;
	gtk_widget_destroy(swin);	 
	len=loadlist(list);
	if (debug>0) g_print("fileselect(): "); 
	for (i=0;i<len;i++) if ((ptr=strrchr(list[i],'$'))) {
		ptr[0]='\0';
		if (strcmp(file,list[i])==0) { ptr++; setline=atoi(ptr); break; }
	}	
	if (sscanf(file,"%s (%[*0-9a-zA-Z])",name,sec)!=2) loadnew(file,NULL,setline);
	else { if (debug>0) g_print(" %s (%s) setline=%d\n",name,sec,setline);
		loadnew(name,sec,setline); }		
	free(file);
}

	
/* fork_seesocket() launches the forked see-server.  The only connection the server maintains is to the 
parent process.  When it recieves a call, the server first confirms it's existence to the caller and then
checks to make sure it's parent is still responsive.  If not, it exits, otherwise it passes a message on 
to the parent from the caller.  The other functions involved are check_seesock(), tglserv(), takecall(), 
and send_remote().*/
int fork_seesocket (int trip) {		/* called from tglserv() */
	pid_t pid;			/* "trip" indicates gtk_main loop is running */
	int sfd=-1;
	char messg[64], signon[8];
	struct sockaddr_un rmt;
	size_t size;
	if ((sfd=loclsckt(sckt)) < 0) { 
		sprintf(messg,"Can't create %s",sckt);
		error_popup(messg); return -1;}
	if (listen(sfd,5) != 0) {
		error_popup("listen() fail on seesocket");
		close(sfd);    
		return -1;}
	pid=fork();
	if (pid == 0 ) {
		int SD=-1;
		size_t bytes;
		char buffer[1024]; 
		struct sockaddr_un see;
		socklen_t size=sizeof(see);
		if (trip) gtk_main_quit();
		if ((remote=accept(sfd,(struct sockaddr*)&see,&size)) < 0) {perror("accept");}
		else write(remote,"XOSEESOX\n",9);
		fcntl(sfd,F_SETFL,O_NONBLOCK);
		fcntl(remote,F_SETFL,O_NONBLOCK);
		while (1) {
			if (SD > 2) {close(SD); SD=-1;}
			if ((SD=accept(sfd,(struct sockaddr*)&see,&size)) > 2) {
				write(SD,"XOSEESOX\n",9);
				gap(0,20);
				if ((read(SD,buffer,6)>0) &&  (strncmp(buffer,"CHECK",5)==0)) {	 
					write(remote,"HI\n",3);
					gap(0,20);
					bytes=read(remote,buffer,4);		
					if ((bytes < 4) || (strncmp(buffer,"DONE", 4)!=0)) {
						if (debug>0) g_print("...shutting down see server\n");
						close(remote); close(sfd); 
						break;}
					write(SD,"HERE\n",5);
					gap(0,20);
			 		bytes=read(SD,buffer,1023);				
					buffer[bytes]=10;buffer[bytes+1]=0;
					write(remote,buffer,bytes+1); } 
				write(SD,"DONE\n",5);
				close(SD); SD=-1;
			}	
			if (read(remote,buffer,255) > 0) {
				if (strncmp(buffer,"THEEND",6)==0) {
					if (debug>0) g_print("...shutting down see server\n");
					close(remote); close(sfd); 
					break;}
			}
			gap(0,50);	/* otherwise we hog the CPU */	
		}		
		unlink(sckt); 
		exit (0); 
	}
	sspid=pid;
	if (debug>0) g_print("fork_seesocket() server pid: %d\n",sspid);
	close(sfd);
	remote=socket(PF_LOCAL,SOCK_STREAM,0);
	rmt.sun_family=AF_LOCAL;
	strcpy(rmt.sun_path,sckt);
	size=SUN_LEN(&rmt);
	if (connect(remote,(struct sockaddr*)&rmt,size) == 0) read(remote,signon,8);
	else return -2;
	fcntl(remote,F_SETFL,O_NONBLOCK);
	if (strncmp(signon,"XOSEESOX",8) == 0) return 777;
	return -10;
}

	
int getagcoords (GtkTextTag *tag, char *tagline) {	/* called from savebmks */
	int cc, total=0;
	char coord[16];
	GtkTextIter itr;

	if (debug>0) g_print("getagcoords() %s | ",tagline);	
	gtk_text_buffer_get_iter_at_line(Tbuf,&itr,0);
	if  ((gtk_text_iter_forward_to_tag_toggle(&itr,tag)) == TRUE) {
		cc=gtk_text_iter_get_offset(&itr);
		if (debug>1) g_print("%d -- ",cc);	
		if (tag == boldblue) sprintf(tagline,"*B*%d*",cc);
		else if (tag == italred) sprintf(tagline, "*R*%d*",cc);
		total=strlen(tagline);
		while ((gtk_text_iter_forward_to_tag_toggle(&itr,tag)) == TRUE) {
			cc=gtk_text_iter_get_offset(&itr);
			if (debug>1) g_print("%d -- ",cc);
			sprintf(coord, "%d*", cc);
			if ((total+=strlen(coord))>=4096) break;
			strcat(tagline,coord); }
	}	
	return total;
}


void gotobmk () { gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(TxT),GTK_TEXT_MARK(bmk),0.0,TRUE,0.0,0.5); }


void grabfocus (GtkWidget *ignored) {
	gtk_entry_set_text(GTK_ENTRY(Fent),"");
	gtk_widget_grab_focus(Fent);
}

void handlequit() {        /* delete, ie. "close window" event callback, and from mainmenu() "quit" */
	char old[MPTH];		
	int lastline=cursorline();
	pid_t pid=getpid();
	if (remote>1) tglserv(0);
	if (seefile) {
		strcpy(old,seefile);
		seefile=NULL;
		update_filelist(NULL, old, lastline);
	}
 	if (debug>0) { g_print("______pid %d handlequit(), exiting_______\n\n",pid); fflush(stdout); }
	gtk_widget_destroy(window);
	gtk_main_quit();
}


void highlight (GtkWidget *widget, gchar *tag) { /* called from mainmenu() */  
	GtkTextIter begin, end;
	gtk_text_buffer_get_selection_bounds(Tbuf, &begin, &end);
	gtk_text_buffer_apply_tag_by_name(Tbuf, tag, &begin, &end); 
	savebmks(NULL,NULL);
}


void help (void) { loadnew("seetxt","1",0); } 


void loadfile (char *old, int setline) {		/* called from loadnew() or reload() */ 
	int len=filelen(seefile), i, lastline=0;
	char messg[128], *ptr;
	if (debug>0) g_print("loadfile() '%s',%d bytes...\n",seefile,len);
	
	if (len<=0) {
		if (debug>0) { g_print("loadfile() -- filelen() returned %d (can't load)\n",len); fflush(stdout); }
		if (len==0) sprintf(messg, "\"%s\"\nhas no content",seefile);
		else sprintf(messg, "Can't open\n%s", seefile);
		error_popup(messg);
		if (len!=0) {
			free(seefile);
			seefile=old; /* replace with former value */
			return; 
	}	}
	lastline=cursorline();
	clear(0);
	FileCon = ec_malloc(len+1);
	ptr=strrchr(seefile,'/'); ptr++;
	strcpy(shortname,ptr);
	gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
	
	if (len>TailAt) { if (!(loadlarge(len))) { clear(1); return; }  } 
	else {	if ((i=fdreadin(seefile,FileCon,-1,len,0))!=len) {
			if (debug>1) g_print("\tshort read (stat %d, read %d)\n",len,i);
			if (i==0) sprintf(messg, "Permission denied for\n%s", seefile);
			else sprintf(messg, "Read short on\n%s", seefile);
			error_popup(messg); }
		if (!(g_utf8_validate((const gchar*)FileCon,-1,NULL)))  error_popup("Can't Validate Text\n(Error #4)");
		else gtk_text_buffer_set_text(Tbuf,FileCon,len); }
	
	if (seedata) dobmks();	/* needs shortname and text in buffer*/
	else { bookmarks=ec_malloc(sizeof(int)); bookmarks[0]=0; }
	gtk_window_set_title(GTK_WINDOW (window), shortname);
	gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
	gtk_text_buffer_place_cursor(Tbuf,&start);
	sfsz=strlen(FileCon);
	scrolltoline(NULL, setline);		
	if (filelist) len=update_filelist(NULL,old,lastline); 		/* add to filelist */
	if ((old) && (old!=seefile)) free(old); /* reload() means old==seefile */
}


gboolean loadlarge (int len) {	 /* called from loadfile() to buffer large files in chunks to display */
	int total=0;
	float inc=1.0f/((float)len/100000.0f), sofar=0.0f; 
	gchar buffer[100001], title[MPTH];
	GtkWidget *subwin=gtk_window_new(GTK_WINDOW_POPUP),
		*frame = gtk_frame_new("Loading File"),
		*svbox=gtk_vbox_new(FALSE,0),
		*caption=gtk_label_new(seefile),
		*pbar=gtk_progress_bar_new(),
		*cancelBT = gtk_button_new_with_label("cancel");

	gtk_window_set_transient_for(GTK_WINDOW(subwin),GTK_WINDOW(window));   
	gtk_window_set_position(GTK_WINDOW(subwin), GTK_WIN_POS_CENTER_ON_PARENT);	
	sprintf(title, "Loading \"%s\"...", shortname);
	gtk_window_set_title(GTK_WINDOW(window),title);
	
	gtk_container_add(GTK_CONTAINER(subwin),frame);
	gtk_container_add(GTK_CONTAINER(frame),svbox);
	gtk_box_pack_start(GTK_BOX(svbox),caption,FALSE,FALSE,PAD);
	gtk_box_pack_start(GTK_BOX(svbox),pbar,FALSE,FALSE,PAD);
	gtk_box_pack_start(GTK_BOX(svbox),cancelBT,FALSE,FALSE,PAD);
	g_signal_connect(cancelBT, "clicked", G_CALLBACK(destroy_widget), subwin);
	/* so CANCEL will destroy and leave a NULL pointer for the while loop: */
	g_signal_connect(subwin, "destroy", G_CALLBACK(gtk_widget_destroyed), &subwin);	
	g_signal_connect(subwin, "destroy", G_CALLBACK(gtk_widget_destroyed), &pbar);	
	gtk_widget_show_all(subwin);	
	
	FileCon[0]='\0';
	while ((subwin) && (total<len)) {
		total+=fdreadin(seefile,buffer,-1,100000,total);
		if (!(g_utf8_validate((const gchar*)buffer,-1,NULL))) {
			gtk_widget_destroy(subwin);
			error_popup("Can't Validate Text\n(Error #4)");
			clear(1);
			break; }
		gtk_text_buffer_insert(Tbuf,&finish,buffer,-1);
		strcat(FileCon,buffer); 
		sofar+=inc;
		if (!(pbar)) break; 
		if (sofar<=1.0f) gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(pbar),sofar);
		while(gtk_events_pending()) gtk_main_iteration();
	} 
	if (total==len) { gtk_widget_destroy(subwin); return TRUE; }
	else return FALSE;
}


int loadlist (char list[27][MPTH+8]) {	/* some inefficiency here, but the task is relatively small */
	int i=0;
	char *line;
	FILE *fstRO;

	if (debug>1) { g_print("loadlist()..."); fflush(stdout); }	

	if (!(filelist)) {
		error_popup("You don't have a filelist defined.\nCheck your ~/.seeconfig");
		return -1; }
	if (!(fstRO=fopen(filelist,"r"))) {
		error_popup("Could not open filelist\nSee manpage for more info.");
		return -2; }
	while (streamline(fstRO,&line,MPTH+7)>0) {
		if (i==27) break;
		strcpy(list[i],line);
		free(line);
		i++;}
	fclose(fstRO);
	return i;
}


void loadman (char *sec, char *old, int setline) {	/* called by loadnew() or reload() */
	int len,i,lastline;
	char byte, cmmd[1024], *line, *ptr, messg[256];
	FILE *pin;
	if (debug>0) g_print("loadman()...%s (sec[0]==%d)\n",seefile,sec[0]);
	
		/* check for page (and get section if necessary) */
	if ((sec[0]==0) || (sec[0]=='*')) sprintf(cmmd,"man -w %s",seefile);   	/* no section OR out-of-tree */
	else sprintf(cmmd,"man -w %s %s",sec,seefile);				/* with section */
	if (debug>2) { g_print("\tcmmd: %s\n",cmmd); fflush(stdout); }
	line=ec_malloc(1024);
	if (!(pin = popen(cmmd, "r"))) {
		sprintf(messg, "\"%s\" failed", cmmd);
		error_popup(messg);
		return; }
	for (i=0;i<1024;i++) {
		if (fread(&byte,1,1,pin)!=1) break;
		if ((i==0) && (byte=='\n')) { i=-1; continue; }  /* possible "blank" line? */
		if ((i>0) && (byte=='\n')) { line[i]='\0'; break; } /* just get one line */
		else line[i]=byte;
	}
	if (debug>1) { g_print("\t++%s++\n",line); fflush(stdout); }
		/* if man check returns an error, opt out */
	if (pclose(pin)!=0) {
		if (sec[0]>0) sprintf(cmmd,"No manual entry for\n\"man %s %s\"",sec,seefile);
		else sprintf(cmmd, "No manual entry for \n\"man %s\"",seefile);
		error_popup(cmmd);
		free(seefile);
		seefile=old; 
		return; }

	lastline=cursorline(); 	/* this is for the filelist */
	clear(0);
			/* prep man command */
	if (sec[0]==0) {
		if (debug>1) { g_print("\t+%s+",line); fflush(stdout); }
		ptr=strrchr(line,'/');
		ptr[0]=0;
		ptr=strrchr(line,'/');
		sscanf(ptr, "/man%s", sec);
	}
	if (sec[0]=='*') sprintf(cmmd, "man %s | col -b -x", seefile);
	else sprintf(cmmd, "man %s %s | col -b -x", sec, seefile);
	sprintf(shortname,"%s(%s)",seefile,sec);
	free(line);	

	sprintf(messg, "Loading %s...", shortname);	
	gtk_window_set_title(GTK_WINDOW (window), messg);
	while(gtk_events_pending()) gtk_main_iteration();	

		/* now pipe man | col -b output */	
	if ((pin = popen(cmmd, "r")) == NULL) {
		sprintf(messg, "\"%s\" failed", cmmd);
		error_popup(messg);
		clear(1);
		return; }
	line=linein(pin);
	len=strexd(0,line);
	while ((line=linein(pin)) != NULL) {
		len=strexd(len,line);
		free(line); }
	pclose(pin);
	FileCon = ec_malloc(len+1);
	strcpy(FileCon,EXDline);
	free(EXDline);
	gtk_text_buffer_set_text(Tbuf,FileCon,len);

	sprintf(messg, "Manual Page for \"%s\"", seefile);
	gtk_window_set_title(GTK_WINDOW (window), messg);
	gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
	gtk_text_buffer_place_cursor(Tbuf,&start);
	scrolltoline(NULL,setline);
	
		/* load bookmarks & mark-up, then add to top of filelist history */ 	
	if (seedata) dobmks();
	else { bookmarks=ec_malloc(sizeof(int)); bookmarks[0]=0; }
	if (filelist) update_filelist(sec,old,lastline); 
	if ((old) && (old!=seefile)) free(old);
}


int loadnew (char *file, char *sec, int setline) {  /* called by main(), fileselect(), DnDreceive(), or takecall() */
	char messg[256], *tmp=seefile;

	if (strlen(file)>MPTH-1) { gtk_window_set_title(GTK_WINDOW (window), "Filename Too Long"); return -1; }
	if (watchSW) watchfile(); if (LNsw) numberlines();
	if ((FileCon) && (confflag==0)) { 
		if (file[0] != '/') sprintf(messg, "Load manual page for\n%s?",file);
		else sprintf(messg, "Load \n%s?", file);
		if (confirm_popup ("SEE Request",messg) == -6) return -1;
	}
	
	if (debug>0) g_print("loadnew() %s \"%s\"\n",file,sec);
	gtk_window_present(GTK_WINDOW(window));
	seefile=ec_malloc(strlen(file)+1);
	strcpy(seefile,file);
	if ((sec) && (sec[0]=='*')) loadman(sec,tmp,setline);
	else if (file[0] != '/') if (sec==NULL) { sec=ec_malloc(8); sec[0]=0; loadman(sec,tmp,setline); free(sec); } 
				else loadman(sec,tmp,setline);
	else loadfile(tmp,setline);
	return 0;
}


void mainmenu () {
	GtkWidget *item1, *item2, *item3, *item4, *item5, *item6, *item7, *item8, *item9, *item17, *item18, 
		*item10, *item11, *item12, *item13, *item14, *item15, *item16, *sp1, *sp2, *notshown;
	GtkAccelGroup *keymacros = gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(window), keymacros);
	gtk_menu_set_accel_group(GTK_MENU(MMenu),keymacros);	

	item12 = gtk_menu_item_new_with_label("file list");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item12);
	g_signal_connect(G_OBJECT(item12), "activate",G_CALLBACK(showlist), NULL);
	gtk_widget_add_accelerator(item12, "activate", keymacros, GDK_f, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	
	if (seedata) {
		item6 = gtk_menu_item_new_with_label("see bookmarks");
		gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item6);
		g_signal_connect(G_OBJECT(item6), "activate",G_CALLBACK(bookmark_list), NULL);
		gtk_widget_add_accelerator(item6, "activate", keymacros, GDK_s, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

		item5 = gtk_menu_item_new_with_label("place bookmark");
		gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item5);
		g_signal_connect(G_OBJECT(item5), "activate",G_CALLBACK(placebmk), NULL);
		gtk_widget_add_accelerator(item5, "activate", keymacros, GDK_m, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	}
	item4 = gtk_menu_item_new_with_label("reload");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item4);
	g_signal_connect(G_OBJECT(item4), "activate",G_CALLBACK(reload), NULL);
	gtk_widget_add_accelerator(item4, "activate", keymacros, GDK_l, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	item17 = gtk_menu_item_new_with_label("copy selection");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item17);
	g_signal_connect(G_OBJECT(item17), "activate",G_CALLBACK(copytoX), 0);
	gtk_widget_add_accelerator(item17, "activate", keymacros, GDK_c, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	
	item18 = gtk_menu_item_new_with_label("copy all");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item18);
	g_signal_connect(G_OBJECT(item18), "activate",G_CALLBACK(copytoX), (int*)1);
	gtk_widget_add_accelerator(item18, "activate", keymacros, GDK_c, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
	
	item11 = gtk_menu_item_new_with_label("apropos search");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item11);
	g_signal_connect(G_OBJECT(item11), "activate",G_CALLBACK(apropos), NULL);
	gtk_widget_add_accelerator(item11, "activate", keymacros, GDK_a, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	item13 = gtk_menu_item_new_with_label("previous found");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item13);
	g_signal_connect(G_OBJECT(item13), "activate",G_CALLBACK(cursor_tofound), (int*)1);
	gtk_widget_add_accelerator(item13, "activate", keymacros, GDK_p, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	item14 = gtk_menu_item_new_with_label("next find");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item14);
	g_signal_connect(G_OBJECT(item14), "activate",G_CALLBACK(cursor_tofound), 0);
	gtk_widget_add_accelerator(item14, "activate", keymacros, GDK_n, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	item3 = gtk_menu_item_new_with_label("(un)number lines");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item3);
	g_signal_connect(G_OBJECT(item3), "activate",G_CALLBACK(numberlines), NULL);
	gtk_widget_add_accelerator(item3, "activate", keymacros, GDK_3, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	notshown = gtk_menu_item_new();
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), notshown);
	g_signal_connect(G_OBJECT(notshown), "activate",G_CALLBACK(grabfocus), NULL);
	gtk_widget_add_accelerator(notshown, "activate", keymacros, GDK_slash, GDK_CONTROL_MASK, 0);

	item7 = gtk_menu_item_new_with_label("bold blue");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item7);
	g_signal_connect(G_OBJECT(item7), "activate",G_CALLBACK(highlight), "boldblue");
	gtk_widget_add_accelerator(item7, "activate", keymacros, GDK_h, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	item8 = gtk_menu_item_new_with_label("italic red");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item8);
	g_signal_connect(G_OBJECT(item8), "activate",G_CALLBACK(highlight), "italred");
	gtk_widget_add_accelerator(item8, "activate", keymacros, GDK_h, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

	item9 = gtk_menu_item_new_with_label("untag");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item9);
	g_signal_connect(G_OBJECT(item9), "activate",G_CALLBACK(removetags), NULL);
	gtk_widget_add_accelerator(item9, "activate", keymacros, GDK_u, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	
	item10 = gtk_menu_item_new_with_label("wrap mode");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item10);
	g_signal_connect(G_OBJECT(item10), "activate",G_CALLBACK(setwrapmode), NULL);
	gtk_widget_add_accelerator(item10, "activate", keymacros, GDK_w, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	item1 = gtk_menu_item_new_with_label("send to editor");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item1);
	g_signal_connect(G_OBJECT(item1), "activate",G_CALLBACK(toedit), NULL);
	gtk_widget_add_accelerator(item1, "activate", keymacros, GDK_e, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	
	if (CopyTo) {
		sp1 = gtk_menu_item_new_with_label("copy out");
		gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), sp1);
		g_signal_connect(G_OBJECT(sp1), "activate",G_CALLBACK(file_out),NULL);
		gtk_widget_add_accelerator(sp1, "activate", keymacros, GDK_o, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
		
		sp2 = gtk_menu_item_new_with_label("execute");
		gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), sp2);
		g_signal_connect(G_OBJECT(sp2), "activate",G_CALLBACK(exec_proc),NULL);
		gtk_widget_add_accelerator(sp2, "activate", keymacros, GDK_x, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	}
	
/*	ns2 = gtk_menu_item_new();	// set F1 as alias for ctrl-h 
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), ns2);
	g_signal_connect(G_OBJECT(ns2), "activate",G_CALLBACK(help), NULL);
	gtk_widget_add_accelerator(ns2, "activate", keymacros, GDK_F1, 0, 0);*/
	
	item15 = gtk_menu_item_new_with_label("reconfigure");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item15);
	g_signal_connect(G_OBJECT(item15), "activate",G_CALLBACK(reconfigure),(gpointer*)1);
	gtk_widget_add_accelerator(item15, "activate", keymacros, GDK_F2, 0, GTK_ACCEL_VISIBLE);
	
	item16 = gtk_menu_item_new_with_label("help");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item16);
	g_signal_connect(G_OBJECT(item16), "activate",G_CALLBACK(help),NULL);
	gtk_widget_add_accelerator(item16, "activate", keymacros, GDK_F1, 0, GTK_ACCEL_VISIBLE);
	
	item2 = gtk_menu_item_new_with_label("quit");
	gtk_menu_shell_append(GTK_MENU_SHELL(MMenu), item2);
	g_signal_connect(G_OBJECT(item2), "activate",G_CALLBACK(handlequit), NULL);
	gtk_widget_add_accelerator(item2, "activate", keymacros, GDK_q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	
	gtk_widget_show_all(MMenu);
}	
	

gboolean mousevent (GtkWidget *widget, GdkEventButton *MoBt, gpointer *data) {
	GtkTextIter togo, there;  
	gchar *word, *sec, *old;
	GdkCursor *text=gdk_cursor_new(GDK_CROSSHAIR);

	if (shortname[0]!='\0') gtk_window_set_title(GTK_WINDOW (window), shortname);
	else gtk_window_set_title(GTK_WINDOW (window), "s e e");
	
	if (MoBt->button == 3) {
			gtk_menu_popup(GTK_MENU(MMenu),NULL,NULL,NULL,NULL,0,GDK_CURRENT_TIME);
			return TRUE; }
	
	if (MoBt->button == 1) { if (MoBt->type != GDK_2BUTTON_PRESS) return FALSE;
		gtk_text_buffer_get_iter_at_mark (Tbuf, &there, gtk_text_buffer_get_insert (Tbuf));
		if ((gtk_text_iter_has_tag(&there,hlink)) != TRUE) return FALSE;
		if ((gtk_text_iter_begins_tag(&there,hlink)) != TRUE) gtk_text_iter_backward_to_tag_toggle(&there,hlink);
		togo=there;
		gtk_text_iter_forward_to_tag_toggle(&togo,hlink);
		word=gtk_text_buffer_get_text(Tbuf,&there,&togo,FALSE);

				/* the next two if's are for the "configuration" hyperlinks */
		if (strcmp(word,"manual page")==0) {  
			old=seefile;
			seefile=ec_malloc(4);
			strcpy(seefile,"seetxt");
			loadman("1",old,0); 
			return TRUE; }
		if (strncmp(word,"the example",11)==0) {  
			old=seefile;
			seefile=ec_malloc(MPTH);
			sprintf(seefile,"%s/.seeconfig",SDIR);
			loadfile(old,0); 
			return TRUE; }
		if (word[0]=='/') {
			old=seefile;
			seefile=ec_malloc(strlen(word)+1);
			strcpy(seefile,word);
			loadfile(old,0);
			return TRUE; }
		
		gtk_text_iter_forward_find_char(&there,(GtkTextCharPredicate)testuni,(short int*)40,NULL);
		gtk_text_iter_forward_find_char(&togo,(GtkTextCharPredicate)testuni,(short int*)41,NULL);
		sec=gtk_text_buffer_get_text(Tbuf,&there,&togo,FALSE);
		gtk_text_buffer_set_text(Tbuf," ",1);
		old=seefile;
		seefile=ec_malloc(strlen(word)+1);
		strcpy(seefile,word);	
		loadman(&sec[1],old,0);
		free(word); free(sec);
		gdk_window_set_cursor (gtk_text_view_get_window (GTK_TEXT_VIEW(TxT), GTK_TEXT_WINDOW_TEXT), text);   
		gdk_cursor_unref(text);	
		return TRUE; 
	}
	return FALSE; 
}	


gboolean nomax (GtkWidget *widget, GdkEventWindowState *ptr, gpointer *data) {
	unsigned char newstate=ptr->new_window_state;
	if (newstate&=4) gtk_window_unmaximize(GTK_WINDOW(window));
	if (newstate&=16) gtk_window_unfullscreen(GTK_WINDOW(window));
	return TRUE;
}


int nextfind (char *haystack, char *needle) {  /* used by searchlight() */
	int nlen=strlen(needle), hslen=strlen(haystack), i, ii;
	char copy[nlen+1], UC=0;
	
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(CaseTgl))) UC=1;
	if (UC==0) for (i=0;i<nlen;i++) copy[i]=tolower(needle[i]); 	
	else strcpy(copy,needle);
	if (debug>2) { g_print("nextfind() %ld, needle=%s\n",haystack-FileCon,needle); fflush(stdout); }
	
	for (i=0;i<hslen;i++) {
		if (((UC==0) && (tolower(haystack[i])==copy[0])) || ((UC==1) && haystack[i]==copy[0])) {
			for (ii=1;ii<nlen;ii++) {
				if (((UC==0) && (tolower(haystack[i+ii])!=copy[ii])) || ((UC==1) && haystack[i+ii]!=copy[ii])) 
					break;
				else if (ii==nlen-1) return i; 
			}
		}
	}
	return -1;
}
	

void numberlines () {
	GtkTextIter lstrt, Nend; 
	gchar lnum[6];
	int i, nlen, nofl;
	if (!(FileCon)) return;
	nofl = buflen(FileCon);
	if (nofl>99999) return;
	if (LNsw==0) {	LNsw=1;
		for (i=0; i<nofl; i++) {
			sprintf(lnum, "%5d ", i+1); 
			nlen = strlen(lnum);
			gtk_text_buffer_get_iter_at_line(Tbuf,&lstrt,i);
			gtk_text_buffer_insert_with_tags(Tbuf,&lstrt,lnum,nlen,lnnm,NULL);
	}} else { LNsw=0;
		for (i=0; i<nofl; i++) {
			gtk_text_buffer_get_iter_at_line(Tbuf,&lstrt,i);
			gtk_text_buffer_get_iter_at_line_offset(Tbuf,&Nend,i,5);
			gtk_text_buffer_delete(Tbuf,&lstrt,&Nend);
		}
	}
}


void placebmk () {
	int num = bookmarks[0]+1, ln=cursorline(),i;
	char messg[25];
	if (!(seefile)) return;
	for (i=1;i<=bookmarks[0];i++) if (bookmarks[i]==ln+1) return; 
	bookmarks=realloc(bookmarks, num+1);
	bookmarks[num]=ln+1; bookmarks[0]++;
	sprintf(messg, "Bookmark set at line %d", ln+1);
	gtk_window_set_title(GTK_WINDOW (window), messg);
	savebmks(NULL,NULL);
}


forconfig *reconfigure(GtkWidget *ignored, char *redo) {	/* called from main() or mainmenu() */
	int DBL, i, tmp;		/* DO NOT put any if (debug) statements in! */
	PangoFontDescription *Tfont;
	FILE *fstRO;
	DIR *test;
	const gchar *homedir=g_get_home_dir();
	char configfile[MPTH], *tok, *line, srvflag=0;
	time_t now=time(NULL);
        struct tm *tp=localtime(&now);
	pid_t pid=getpid();
	GdkColor textback;
	forconfig *newcon=ec_malloc(sizeof(forconfig));
	newcon->txtfnt=NULL;
	newcon->tbcolor=NULL;
	newcon->width=700;
	newcon->height=700;
	
	sprintf(configfile,"%s/.seeconfig",homedir);
	if ((fstRO=fopen(configfile, "r"))) {
		confflag=0; Redirect=1; Config=1;
		while ((line=linein(fstRO)) != NULL) {
			tok=strtok(line,":");
			if (strcmp(tok,"text font") == 0) {
				if ((tok=strtok(NULL,":\n"))) {
					while (tok[0]==' ') tok++;
					newcon->txtfnt=ec_malloc(strlen(tok)+1);
					strcpy(newcon->txtfnt,tok); }
			} else if (strcmp(tok,"watch interval") == 0) {
				if ((tok=strtok(NULL,":\n"))) watchtime=strtol((const char*)tok,NULL,10);
			} else if (strcmp(tok,"dimensions") == 0) {
				if ((tok=strtok(NULL,":\n"))) {
					tmp=sscanf(tok,"%d%[x ]%d",&i,configfile,&DBL);		
					if (tmp==0) continue;
					if ((i>0) && (i<9999)) newcon->width=i;
					if (tmp==1) continue;
					if ((DBL>0) && (DBL<9999)) newcon->height=DBL;
				}	
			} else if (strcmp(tok,"seedata") == 0) {
				if ((tok=strtok(NULL,": \n"))) {
					if (seedata) free(seedata);
					seedata=ec_malloc(strlen(tok)+1);
					strcpy(seedata,tok); }
			} else if (strcmp(tok,"filelist") == 0) {
				if ((tok=strtok(NULL,": \n"))) {
					if (filelist) free(filelist);
					filelist=ec_malloc(strlen(tok)+1);
					strcpy(filelist,tok); }
			} else if (strcmp(tok,"no confirm") == 0) confflag=1;
			else if (strcmp(tok,"seesocket") == 0) {
				if (!(tok=strtok(NULL,": \n"))) continue;
				if (remote>2) { tglserv(1); srvflag=1; }	
				if ((strlen(tok)>0) && (strlen(tok)<107)) strcpy(sckt,tok);
			} else if (strcmp(tok,"debuglog")==0) {   /* development use */
				if (!(tok=strtok(NULL,": \n"))) continue;
				if ((DBL=open(tok,O_CREAT|O_WRONLY,S_IREAD|S_IWRITE))<3) continue;
				printf("switching stdout & stderr to %s",tok);
				dup2(DBL,1); dup2(DBL,2); /* stdout, stderr to file */									
				lseek(DBL,0,SEEK_END);
				printf("\n******* pid %d -- %d:%02d *******\n",pid,tp->tm_hour,tp->tm_min);
			} else if (strcmp(tok,"editor")==0) {
				if (!(tok=strtok(NULL,"\n"))) continue;
				while (tok[0]==' ') tok++;
				if (Editor) free(Editor);
				Editor=ec_malloc(strlen(tok)+1);
				strcpy(Editor,tok); 
			} else if (strcmp(tok,"background")==0) {
				if (!(tok=strtok(NULL,": \n"))) continue;
				newcon->tbcolor=ec_malloc(strlen(tok)+1);
				strcpy((char*)newcon->tbcolor,tok); 
			} else if (strcmp(tok,"tail at")==0) {
				if (!(tok=strtok(NULL,": \n"))) continue;
				TailAt=strtol((const char*)tok,NULL,10);
			} else if (strcmp(tok,"copy to")==0) {
				if (!(tok=strtok(NULL,": \n"))) continue;
				if (!(test=opendir((const char*)tok))) continue;
				closedir(test);	
				if (CopyTo) free(CopyTo);
				CopyTo=ec_malloc(strlen(tok)+1);
				strcpy(CopyTo,tok);
			} else if (strncmp(tok,"no redirect",11)==0) Redirect=0;
			free(line); }
		fclose(fstRO);
	} else {sprintf(configfile,"No %s/.seeconfig found.\n",homedir);	
		puts(configfile); Config=0;	
		if (redo) gtk_window_set_title(GTK_WINDOW (window), configfile); }
	if (redo==0) return newcon;  /* when called from main() */

	if (newcon->txtfnt) { Tfont = pango_font_description_from_string(newcon->txtfnt);
		gtk_widget_modify_font(TxT,Tfont);
		pango_font_description_free(Tfont); } 
	gtk_widget_set_size_request(GTK_WIDGET (TxT), newcon->width, newcon->height);
	if (newcon->tbcolor) {
		if (gdk_color_parse(newcon->tbcolor, &textback)) gtk_widget_modify_base(TxT, GTK_STATE_NORMAL, &textback);
		free((char*)newcon->tbcolor); 
	}
	if (srvflag) tglserv(1);

	if (seefile) { 		/* save our position in current file if necessary */
		tok=ec_malloc(strlen(seefile)+1);
		strcpy(tok,seefile);
		free(seefile); seefile=NULL;
		i=cursorline();
		update_filelist(NULL, tok, i);
		free(tok); }
	
	clear(1);
	if (g_object_is_floating(MMenu)) g_object_ref_sink(MMenu); 
	g_object_unref(MMenu); 
	MMenu=gtk_menu_new();
	mainmenu();	/* reconfigure menu possibilities */
	showconfig(newcon->txtfnt,newcon->width,newcon->height);
	free(newcon);	/* txtfnt cannot be freed, so reconfiguring creates a teeny tiny leak */
	return NULL;
}
	

void removetags (GtkWidget *widget, gpointer *data) {
	GtkTextIter Ts, Te;
	gtk_text_buffer_get_selection_bounds(Tbuf, &Ts, &Te);
	gtk_text_buffer_remove_tag(Tbuf, boldblue, &Ts, &Te);
	gtk_text_buffer_remove_tag(Tbuf, italred, &Ts, &Te);
	savebmks(NULL,NULL);
}


gboolean reload () {	/* called from watchfile() or mainmenu() */
	char copy[MPTH], *tok, *tmp=seefile;
	gint lnum, lcount, lcount2;
	if (debug>1) { g_print("reload() %s\n", seefile); fflush(stdout); }
	if (!(seefile)) { if (watchSW) watchfile(); /* toggle left on */
		return TRUE; }

	if ((seefile[0]=='/') && (filelen(seefile)>TailAt)) {
		gtk_window_set_title(GTK_WINDOW (window), "large file: tailed, not reloaded");
		return tailfile();
	}
	
	lnum=cursorline(); 
	lcount=gtk_text_buffer_get_line_count(Tbuf); 
	
	gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
	gtk_text_buffer_delete(Tbuf,&start,&finish);
	if (strlen(seefile) == 0) return TRUE;
	/* another way to tell man from file is in the shortname */
	if (!(strchr(shortname,'('))) loadfile(tmp,0);
	else {	strcpy(copy,shortname);
		tok=strtok(copy,"("); tok=strtok(NULL,")");
		loadman(tok,tmp,lnum); }
	/* try to return to previous position */
	lcount2=gtk_text_buffer_get_line_count(Tbuf);
	if (lnum == (lcount-1) || lnum >= lcount2) scrolltoline(NULL,lcount2-1);
	else scrolltoline(NULL,lnum);
	if (watchSW==0) return FALSE;
	return TRUE;
}


void savebmks (GtkWidget *widget, GtkWidget *subwin) {	/* called from bookmark_list() or placebmk() */
	int i;
	FILE *fstRO, *fstW; 
	const gchar *homedir=g_get_home_dir();
	char *line, tmp[strlen(homedir)+8], seeline[8192], tagline[4096], *sptr, num[7];
	if (seefile[0]=='/') sptr=seefile;
	else sptr=shortname;
	if (subwin) gtk_widget_destroy(subwin);  /* close bookmarks window */
	sprintf(tmp,"%s/.SeeTP",homedir);	/* use homedir rather than /tmp to not intefere with other users */	
		
		/* some possible problems */
	if (!(seefile)) return;
	if (!seedata) {
		gtk_window_set_title(GTK_WINDOW (window), "No personal \"seedata\" file, your bookmarks cannot be saved");
		return;}
	if ((fstRO = fopen(seedata, "r")) == NULL) {
		gtk_window_set_title(GTK_WINDOW (window), "Could not open your \"seedata\" file!");
		return;}
	if ((fstW = fopen(tmp, "w")) == NULL) {
		gtk_window_set_title(GTK_WINDOW (window), "Could not create temp file, your bookmarks will not be saved");
		fclose(fstRO);
		return; }
		
		/* write tmp file */
	while ((line=linein(fstRO)) != NULL) {
		if (line[0]=='\n') { free(line); continue; }
		if (strncmp(line,sptr,strlen(sptr)) != 0) fprintf(fstW,line);
		free(line);}
	fclose(fstRO);
		
		/* compose new line using global integer array "bookmarks" */
	sprintf(seeline, "%s*%d",sptr,bookmarks[0]);	/* bookmarks[0] is the number of bookmarks */
	if (bookmarks[0]>0) for (i=1; i<=bookmarks[0]; i++) {
		if (bookmarks[i]==0) continue;	/* was deleted */
		sprintf(num,"*%d",bookmarks[i]);
		strcat(seeline,num); }
	if (debug>0) g_print("savebmks()...\n"); 
	if (LNsw == 1) {numberlines(); LNsw=1;}
	if (getagcoords(boldblue,tagline)>0) strcat(seeline,tagline);
	if (getagcoords(italred,tagline)>0) strcat(seeline,tagline);
	if (LNsw == 1) {LNsw=0;numberlines();}
		
		/* write new seedata */
	fprintf(fstW,"%s\n",seeline);
	fclose(fstW);
	if ((copytmp(tmp,seedata)) != 0) error_popup("in bookmarks(): copytmp()\nfclose or unlink failed");
	gtk_window_set_title(GTK_WINDOW (window), "Bookmarks saved");
}		


void scrolltoline (GtkWidget *widget, gint line) {
	GtkTextIter where;
	GtkTextMark *goal;
	gtk_text_buffer_get_iter_at_line(Tbuf,&where,line);
	goal=gtk_text_buffer_create_mark(Tbuf,"goal",&where,FALSE);
	gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(TxT),GTK_TEXT_MARK(goal),0.0,TRUE,0.0,0.5);
	gtk_text_buffer_place_cursor(Tbuf,&where); 	
}		


void searchlight () {	/* find and hilite, called from main() or FentKpress() */
	GdkDisplay *display = gdk_display_get_default();
	GtkTextIter begin, end, togo;
	char tonumLbl[7], title[128];
	char *ptr, *FCend, flag=0;
	const gchar *fthis = gtk_entry_get_text(GTK_ENTRY(Fent));
	int slen=strlen(fthis), x=0, i, sw=0, cc=0, tmp;	
	if (slen == 0) return;

	gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
	if (!(FileCon)) {	/* if not an actual file in buffer */
		gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
		FileCon=gtk_text_buffer_get_text(Tbuf,&start,&finish,FALSE); 
		flag=1; }
	ptr=FileCon;
	FCend=FileCon+strlen(FileCon);

	if (debug>0) g_print("searchlight()...\n");

	addtohistory((char*)fthis);
	
	strcpy(title, "Searching for ");
	strncat(title, fthis, 112);
	gtk_window_set_title(GTK_WINDOW(window),title);
	gdk_display_flush(display);
	
	if (LNsw==1) {	/* get around the line numbers */
		numberlines();	
		sw = 1; }	
	gtk_text_buffer_remove_tag (Tbuf, hlite, &start, &finish);	
			
		/* if "push" toggled */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pushTgl))) {
		gtk_text_buffer_remove_tag (Tbuf, pushed, &start, &finish);	
		for (i=0; i<=(totalF*2)-1; i+=2) {
			gtk_text_buffer_get_iter_at_offset(Tbuf,&begin,TF[i]);
			gtk_text_buffer_get_iter_at_offset(Tbuf,&end,TF[i+1]);
			gtk_text_buffer_apply_tag(Tbuf, pushed, &begin, &end);
		}
	}
		/* the search (regexp or normal) */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(regxTgl))) {
		while ((slen=regexp(ptr,(char *)fthis))>0) {
			TF[x] = utfadj(FileCon,ptr-FileCon+rgxp.bgn);
			TF[x+1] = TF[x] + slen;
			ptr+=rgxp.end;  /* the UNADJUSTED place */
			if (debug>2) g_print("+%d=%p\t",rgxp.end,ptr);
			x += 2; 
			if ((x<1000) && ((x%100)==0)) {
				sprintf(tonumLbl,"%d",x/2);
				gtk_label_set_text(GTK_LABEL(numLbl), tonumLbl);			
				while (gtk_events_pending()) gtk_main_iteration(); } 
			if ((x>=1000) && ((x%200)==0)) {
				sprintf(tonumLbl,"%d",x/2);
				gtk_label_set_text(GTK_LABEL(numLbl), tonumLbl);			
				while (gtk_events_pending()) gtk_main_iteration(); } 
			if ((x>=198000) || (ptr>=FCend)) break; }
	} else { while ((tmp=nextfind(ptr, (char*)fthis))>-1) {
			TF[x]=utfadj(FileCon,tmp+cc);
			TF[x+1] = TF[x] + slen;
			cc+=tmp+slen;
			ptr=&FileCon[cc];		
			x += 2; 
			if ((x<1000) && ((x%100)==0)) {
				sprintf(tonumLbl,"%d",x/2);
				gtk_label_set_text(GTK_LABEL(numLbl), tonumLbl);			
				while (gtk_events_pending()) gtk_main_iteration(); } 
			if ((x>=1000) && ((x%200)==0)) {
				sprintf(tonumLbl,"%d",x/2);
				gtk_label_set_text(GTK_LABEL(numLbl), tonumLbl);			
				while (gtk_events_pending()) gtk_main_iteration(); } 
			if ((x>=198000) || (ptr>=FCend)) break; }
	}
	if (flag) { free(FileCon); FileCon=NULL; }
		/* add visible tags */
	for (i=0; i<x; i+=2) {
		gtk_text_buffer_get_iter_at_offset(Tbuf,&begin,TF[i]);
		gtk_text_buffer_get_iter_at_offset(Tbuf,&end,TF[i+1]);
		gtk_text_buffer_apply_tag(Tbuf, hlite, &begin, &end);
	}
	totalF = x/2;	
	sprintf(tonumLbl,"%d",totalF);
	gtk_label_set_text(GTK_LABEL(numLbl), tonumLbl);			
	if (totalF > 0) { 
		gtk_text_buffer_get_iter_at_offset(Tbuf,&togo,TF[0]);
		gtk_text_view_scroll_to_iter(GTK_TEXT_VIEW(TxT),&togo,0.0,TRUE,0.5,0.5);
		gtk_text_buffer_place_cursor(Tbuf,&togo); }
	if (sw == 1) numberlines();
	gtk_window_set_title(GTK_WINDOW(window),shortname);
}



int send_remote (char *exename, char *sec, char *term) {	/* called from main() if server is running */
	char buffer[MPTH+6], *cwd;

	if (strcmp(exename,"seetxt")==0) { 
		if (seefile[0]!='/') { 	
			cwd=getcwd(NULL,0);				
			if (strncmp(seefile,"./",2)==0) seefile+=2;	
			sprintf(buffer,"LOAD %s/%s",cwd,seefile);	
			free(cwd);
		} else sprintf(buffer,"LOAD %s",seefile);
	} else if (strcmp(exename,"seeman")==0) {
		if (seefile[0]=='/') sprintf(buffer, "SMAN *** %s",seefile);
		else if (strncmp(seefile,"./",2)==0) { 		/* section *** is out-of-tree */
			cwd=getcwd(NULL,0); seefile+=2;				
			sprintf(buffer, "SMAN *** %s/%s",cwd,seefile); }		
		else if (sec[0]) sprintf(buffer, "SMAN %s %s",sec,seefile);
		else sprintf(buffer,"MAN %s",seefile);
	}
	if (term) { strcat(buffer," FIND "); strcat(buffer,term); }
	strcat(buffer,"\n");
	write(remote,buffer,strlen(buffer));
	g_print("Request_sent...");
	if (debug>0) g_print("\"%s\"...",buffer);
	read(remote,buffer,5);
	if (strncmp(buffer,"DONE",4) != 0) return -3;
	puts("done.");	
	return 0;
}


void setwrapmode () {
	GtkWidget *sbwin = gtk_window_new(GTK_WINDOW_POPUP), 
		*frame = gtk_frame_new("Wrap Mode"),
		*sbVbox = gtk_vbox_new (FALSE, 0),
		*CloseBT = gtk_button_new_with_label("close"),
		*rbutt = gtk_radio_button_new_with_label (NULL, "no wrap");
	GSList *RBgroup = gtk_radio_button_get_group(GTK_RADIO_BUTTON(rbutt));
	GtkWrapMode current = gtk_text_view_get_wrap_mode(GTK_TEXT_VIEW(TxT));
				/* give sbwin a parent to center on: */
	gtk_window_set_transient_for(GTK_WINDOW(sbwin),GTK_WINDOW(window));   
	gtk_window_set_position(GTK_WINDOW(sbwin), GTK_WIN_POS_CENTER_ON_PARENT);	
	gtk_container_add(GTK_CONTAINER (sbwin), frame);
	gtk_container_add(GTK_CONTAINER (frame), sbVbox);
	
	if (current == GTK_WRAP_NONE) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rbutt),TRUE);
	g_signal_connect(rbutt, "toggled", G_CALLBACK(changewrapmode), (GtkWrapMode*)GTK_WRAP_NONE);
	gtk_box_pack_start(GTK_BOX (sbVbox), rbutt, FALSE, FALSE, 0);
				/* no need for seperate widgets for each button */
	rbutt = gtk_radio_button_new_with_label (RBgroup, "wrap on word");
	RBgroup = gtk_radio_button_get_group(GTK_RADIO_BUTTON(rbutt));
	if (current == GTK_WRAP_WORD) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rbutt),TRUE);
	g_signal_connect(rbutt, "toggled", G_CALLBACK(changewrapmode), (GtkWrapMode*)GTK_WRAP_WORD);
	gtk_box_pack_start(GTK_BOX (sbVbox), rbutt, FALSE, FALSE, 0);
	
	rbutt = gtk_radio_button_new_with_label (RBgroup, "exact wrap");
	RBgroup = gtk_radio_button_get_group(GTK_RADIO_BUTTON(rbutt));
	if (current == GTK_WRAP_CHAR) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rbutt),TRUE);
	g_signal_connect(rbutt, "toggled", G_CALLBACK(changewrapmode), (GtkWrapMode*)GTK_WRAP_CHAR);
	gtk_box_pack_start(GTK_BOX (sbVbox), rbutt, FALSE, FALSE, 0);

	gtk_box_pack_end(GTK_BOX (sbVbox), CloseBT, FALSE, FALSE, 0);
	g_signal_connect(CloseBT, "clicked", G_CALLBACK(destroy_widget), GTK_WIDGET(sbwin));
	
	gtk_widget_show_all(sbwin);	
}


void showconfig(char *font, int width, int height) {	/* called from main() or reconfigure () */
	gchar text[128];
	const gchar *homedir=g_get_home_dir();
	GtkTextIter iter;
	gtk_text_buffer_get_end_iter(Tbuf,&iter);
	sprintf(text, "\n___Configuration___\n\n"); 
	gtk_text_buffer_insert_with_tags(Tbuf,&iter,(const gchar*)text,-1,ctitle,NULL);
	
	if (font) { sprintf(text, "\n\ttext area font: %s\n",font);free(font); }
	else strcpy(text, "\n\tno text font selected.\n");
	gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
	
	sprintf(text, "\twatch interval set to %d seconds\n",watchtime);
	gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
	
	sprintf(text,"\ttext area width=%dpx height=%dpx\n\n",width,height);
	gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
	
	if (seedata) {
		sprintf(text, "\t\"seedata\" file path ");
		gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
		strcpy(text,seedata);
		gtk_text_buffer_insert_with_tags(Tbuf,&iter,(const gchar*)text,-1,hlink,NULL); }
	else { 	sprintf(text, "\t...no \"seedata\" file in use."); 
		gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1); }

	if (filelist) {
		sprintf(text, "\n\tfilelist path ");
		gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
		strcpy(text,filelist);
		gtk_text_buffer_insert_with_tags(Tbuf,&iter,(const gchar*)text,-1,hlink,NULL); }
	else { 	sprintf(text, "\n\t...no filelist in use.\n");
		gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1); }

	sprintf(text, "\n\t\"seesocket\" location: %s\n\n",sckt);
	gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
	
	sprintf(text,"\tYour editor command: \"%s\"\n",Editor);
	gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
	
	if (CopyTo) { sprintf(text, "\n\tYour \"copy to\" directory: %s\n", CopyTo);
		gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1); 
	
		if (!(Redirect)) { sprintf(text,"stderr redirection turned off.\n");
		gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1); }
	}
	
	sprintf(text,"\n\t\"Tail at\" boundary: %d\n",TailAt);
	gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);

	if (confflag==1) sprintf(text,"\t\"Confirm load\" turned off.\n");
	else sprintf(text,"\tConfirm load is on.\n");
	gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
	
	sprintf(text,"\n  For more information, see ");
	gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
	if (Config) sprintf(text,"%s/.seeconfig",homedir);
	else sprintf(text,"the example .seeconfig file");
	gtk_text_buffer_insert_with_tags(Tbuf,&iter,(const gchar*)text,-1,hlink,NULL);
	sprintf(text,"\n  and under \"CONFIGURATION\" in the ");
	gtk_text_buffer_insert(Tbuf,&iter,(const gchar*)text,-1);
	sprintf(text,"manual page");
	gtk_text_buffer_insert_with_tags(Tbuf,&iter,(const gchar*)text,-1,hlink,NULL);
}	
	

void showlist() {
	int len,i;
	char list[27][MPTH+8], *ptr;
	GtkListStore *liststore=gtk_list_store_new(1,G_TYPE_STRING);
	GtkWidget *sbwin = gtk_window_new(GTK_WINDOW_POPUP), 
		*frame = gtk_frame_new("Viewed File List"),
		*flab = gtk_frame_get_label_widget(GTK_FRAME(frame)),
		*sbox = gtk_vbox_new (FALSE, 0),
		*FLLV = gtk_tree_view_new_with_model(GTK_TREE_MODEL(liststore)),
		*cancelBT = gtk_button_new_with_label("cancel");
	GtkCellRenderer *render;	
	GtkTreeViewColumn *column;	
	GtkTreeIter itr;
	PangoAttrList *atrb=pango_attr_list_new();
	PangoAttribute *ubold=pango_attr_weight_new(PANGO_WEIGHT_ULTRABOLD);
	
	if ((len=loadlist(list))<0) return;

	gtk_window_set_transient_for(GTK_WINDOW(sbwin),GTK_WINDOW(window));   
	gtk_window_set_position(GTK_WINDOW(sbwin), GTK_WIN_POS_CENTER_ON_PARENT);	
	gtk_container_add(GTK_CONTAINER(sbwin),frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame),PAD);
	ubold->start_index=0;
	ubold->end_index=16;
	pango_attr_list_insert(atrb,ubold);
	gtk_label_set_attributes(GTK_LABEL(flab),atrb);
	
	gtk_container_add(GTK_CONTAINER(frame),sbox);
	gtk_box_pack_start(GTK_BOX(sbox),FLLV,FALSE,FALSE,0);
	
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(FLLV), FALSE);
	render=gtk_cell_renderer_text_new();	
	column=gtk_tree_view_column_new_with_attributes("filelist",render,"text",0,NULL);	
	gtk_tree_view_append_column(GTK_TREE_VIEW(FLLV),column);
	for (i=0;i<len;i++) {
		gtk_list_store_append(liststore,&itr);
		if ((ptr=strrchr(list[i],'$'))) ptr[0]='\0';
		gtk_list_store_set(liststore,&itr,0,list[i],-1);
	}
	g_signal_connect(FLLV, "row-activated", G_CALLBACK(fileselect), sbwin);
	
	gtk_box_pack_end(GTK_BOX (sbox), cancelBT, FALSE, FALSE, 0);
	g_signal_connect(cancelBT, "clicked", G_CALLBACK(destroy_widget), GTK_WIDGET(sbwin));
	
	gtk_widget_show_all(sbwin);
}


gboolean takecall(GIOChannel *source, GIOCondition *condition, gpointer *data) {  /* called by tglserv() */
	char buffer[MPTH+256], *tok, *sec, *ptr;
	if (read(remote,buffer,MPTH+256)<1) return TRUE;
	while ((ptr=strrchr(buffer,10))) ptr[0]=0;
	if (debug>0) g_print("takecall() recieved \"%s\"\n",buffer);
	if (!(tok=strtok(buffer," "))) return TRUE;
	if ((strcmp(tok,"LOAD") == 0) || (strcmp(tok,"MAN") == 0)) {
		tok=strtok(NULL," \n");
		loadnew(tok,NULL,0); }
	else if (strcmp(tok,"SMAN") == 0) {
		sec=strtok(NULL," ");
		tok=strtok(NULL," \n");
		loadnew(tok,sec,0); }
	if ((tok=strtok(NULL," ")) && (strcmp(tok,"FIND")==0)) {
		tok=strtok(NULL," \n");
		if (!(tok)) { write(remote,"DONE\n",5); return TRUE; }
		gtk_entry_set_text(GTK_ENTRY(Fent), tok);
		searchlight(); }			
	write(remote,"DONE\n",5); 
	return TRUE;
}


gboolean tailfile () {  /* used on large files by watchfile() and reload() */
	char *line, *tmp;
	FILE *fin;
	int now=filelen(seefile);
	if (now<=sfsz) return TRUE;
	if (debug>0) g_print("tailfile() %d %d\n", sfsz, now);
	if (!(tmp=realloc(FileCon,now+1))) {
		error_popup("Out of memory!");
		return TRUE; }
	else FileCon=tmp;
	fin=fopen(seefile,"r");
	fseeko(fin,sfsz,SEEK_SET);
	gtk_text_buffer_get_bounds(Tbuf,&start,&finish);
	while ((line=linein(fin))) {
		gtk_text_buffer_insert(Tbuf,&finish,line,-1);
		strcat(FileCon,line); 
		free(line); }
	fclose(fin);
	scrolltoline(NULL,buflen(FileCon));
	sfsz=strlen(FileCon);
	return TRUE;	
}	
	

gboolean testuni (gunichar CHR, short int chr) {
	if (CHR == chr) return TRUE;
	else return FALSE;
}


gchar *textline (int line) {	/* used by bookmark_list() */
	gchar *rptr=NULL;
	int cc=0, lc=1, lstart=0, len=strlen(FileCon);
	while (cc<len) {
		if (FileCon[cc]=='\n') { lc++; lstart=cc+1; } 
		if (lc==line) { rptr=FileCon+lstart; break; }
		cc++;
	}
	return rptr;
}	


void tglserv (int trip) { 	/* called from main() initially or by button, and handlequit()	*/
	int seerv;		/* "trip" is passed on to fork_seesocket */
	static guint blink_TO, watch_ID; /* some Glib functions return "source" ID's */ 
	char messg[256];
	if (debug>0) g_print("tglserv()...");
	if (remote < 2) {
		switch (check_seesock()) {
			case (-66): sprintf(messg, "Abnormal response from\n %s", sckt); 
				error_popup(messg); return;
			case (-11): sprintf(messg, "Couldn't remove old\n %s", sckt); 
				error_popup(messg); return;
		 	case (-1): error_popup("A see server is\n already running"); return;
			default: break; }
		switch (seerv=fork_seesocket(trip)) {
			case -10: error_popup("seesocket problem");
				kill (sspid,9); return;
			case -2: error_popup("connect() fail");	
			case -1: kill (sspid,9); return;
			case 777: tochild=g_io_channel_unix_new(remote);
				watch_ID=g_io_add_watch(tochild,G_IO_IN,(GIOFunc)takecall,NULL);
				if (debug>0) g_print("See server initialized...");	
				break;
			default: g_print("SEE ERROR: tglserv(): %d returned by fork_seesocket()\n",seerv);}
		blink_TO=g_timeout_add((750), (GSourceFunc)blinktoggle,&sff);
	} else { /* toggle off */
		g_source_remove(blink_TO);
		write(remote,"THEEND\0",7);
		g_io_channel_set_close_on_unref(tochild,TRUE);
		g_io_channel_shutdown(tochild,FALSE,NULL);
		g_io_channel_unref(tochild);
		g_source_remove(watch_ID);	/* important! */
		close(remote); remote=-1; kill (sspid,9);
		unlink(sckt);
		if (sff.sw==1) {gtk_container_remove(GTK_CONTAINER(servTgl), servon);	
			gtk_container_add(GTK_CONTAINER(servTgl), servoff);
			sff.sw=0;}	
	}
}		


void toedit () {
	int pid;
	char string[MPTH+16];

	if ((!(seefile)) || (seefile[0]!='/')) return;
	
	pid=fork();
	if (pid==0) {
		sprintf(string,"%s %s", Editor, seefile);
		system(string);
		exit (0);
	} else {sprintf(string, "%s sent %s", seefile, Editor);
		gtk_window_set_title(GTK_WINDOW (window), string); }
}


gboolean TxTKpress (GtkWidget *widget, GdkEventKey *kyprs, gpointer *data) {
	gint ln, nofl, lend, lffs;
	GtkTextMark *curpos; 
	GtkTextIter from, moveto;	
	switch(kyprs->keyval) {				
		case GDK_Home:
			if (kyprs->state==GDK_CONTROL_MASK) {
				scrolltoline(NULL,1);			
				return TRUE; }
			else return FALSE;			
	 	case GDK_End:
			if ((FileCon) && (kyprs->state==GDK_CONTROL_MASK)) {
				nofl = buflen(FileCon);
				scrolltoline(NULL,nofl-1);			
				return TRUE; }
			else return FALSE;	
		case GDK_Left:		
			if (kyprs->state==GDK_MOD1_MASK) {
				curpos=gtk_text_buffer_get_insert(Tbuf);
				gtk_text_buffer_get_iter_at_mark(Tbuf,&from,curpos);
				ln=gtk_text_iter_get_line(&from);
				gtk_text_buffer_get_iter_at_line(Tbuf,&moveto,ln);
				gtk_text_buffer_place_cursor(Tbuf,&moveto);
				gtk_text_view_scroll_to_iter((GtkTextView*)TxT, &moveto, 0, FALSE, 0, 0);
				return TRUE; }
			else return FALSE;	
		case GDK_Right:
			if (kyprs->state==GDK_MOD1_MASK) {
				curpos=gtk_text_buffer_get_insert(Tbuf);
				gtk_text_buffer_get_iter_at_mark(Tbuf,&from,curpos);
				lend=gtk_text_iter_get_chars_in_line(&from)-1;
				lffs=gtk_text_iter_get_line_offset(&from);
				ln=gtk_text_iter_get_line(&from);
				if ((lffs+27)>lend) {
					gtk_text_buffer_get_iter_at_line_offset(Tbuf,&moveto,ln,lend);}
				else {lffs+=27;
					gtk_text_buffer_get_iter_at_line_offset(Tbuf,&moveto,ln,lffs);}
				gtk_text_buffer_place_cursor(Tbuf,&moveto);
				gtk_text_view_scroll_to_iter((GtkTextView*)TxT, &moveto, 0, FALSE, 0, 0);
				return TRUE; }
			else return FALSE;	
		default:
			return FALSE; 
	}		
}


int update_filelist (char *sec, char *old, int lastline) {  /* used by loadfile(), loadman(), handlequit(), */
	char list[27][MPTH+8], line[MPTH+8]="\0", *ptr;			/* file_out(), exec_proc() and reconfigure() */
	int len, x, i;
	FILE *fstW;
	
	if ((len=loadlist(list))==0) return -1;
	if (!(fstW=fopen(filelist,"w"))) {
		error_popup("Unable to update filelist!\nError #3\n(see manpage/ctrl-h)");
		return -2; }

	if (debug>0) { g_print("update_filelist() sec=%s old=%s listlen=%d\n",sec,old,len); }

	if (len>=27) x=26;
	else x=len;
	if (seefile) {	/* if new file is being loaded, that will be the first line in the new list file */
		if (sec==NULL) sprintf(line,"%s",seefile);  
		else sprintf(line,"%s (%s)",seefile,sec); 
		fprintf(fstW,"%s\n",line); }		
			/* if a previous file was loaded, update its entry with lastline */
	if (old) len=strlen(old);			
	if ((old) && (old!=seefile) && (strncmp(list[0],old,len)==0)) {
		while ((ptr=strrchr(list[0],'$'))) ptr[0]='\0';
		sprintf(list[0],"%s$%d",list[0],lastline); }
	len=strlen(line);
	for (i=0;i<x;i++) {	/* only one entry per filename */
		if ((len) && (strncmp(list[i],line,len)==0)) continue;
		if (debug>2) { g_print("\t%d %s %d %s\n",i,list[i],x,line); }
		fprintf(fstW,"%s\n",list[i]); }
	fclose(fstW);
	return 0;
}


void usage (char *name) {
	int x=strcmp(name,"seeman");
	char tmp[]="filename";
	if (x==0) { strcpy(tmp,"manpage");
		printf("Usage: %s [%s] [-s section] [-x term] [-d level]\n",name,tmp);
		puts("-s\tman page section number (eg, -s1 or -s3p)"); }
	else printf("Usage: %s [%s] [-x term] [-d level]\n",name,tmp);
	printf(	"-x\tinitial search term\n"
		"-d\t1,2 or 3, turn on debugging to stdout\n"
		"-K\tfree server space/socket\n"
		"-v\tshow version\n"
		"-h\tprints this message\n\n");
}


void usebmk (GtkTreeView *treeview, GtkTreePath *treepath, GtkTreeViewColumn *treecol, GtkWidget *swin) {
	int ln;
	GtkTreeModel *Tmod=gtk_tree_view_get_model(treeview);
	GtkTreeIter itr;
	if (gtk_tree_model_get_iter (Tmod, &itr, treepath)) gtk_tree_model_get(Tmod, &itr, 0, &ln, -1);
	if (ln != 0) scrolltoline(NULL,ln-1);
	gtk_widget_destroy(swin);	 	
}


void watchfile () {
	static guint watch_TO, blink_TO;
	gboolean (*func)() = reload;
	if (!(watchSW) && !(seefile)) return;
	if (sfsz>TailAt) func=tailfile;
	if (watchSW==0) {
		watch_TO=g_timeout_add((watchtime*1000), (GSourceFunc)func,NULL);
		blink_TO=g_timeout_add((500), (GSourceFunc)blinktoggle,&wff);
		watchSW=1;
	} else {watchSW=0;
		g_source_remove(watch_TO);	
		g_source_remove(blink_TO);	
		if (wff.sw==1) {gtk_container_remove(GTK_CONTAINER(watchTgl), watchon);	
			gtk_container_add(GTK_CONTAINER(watchTgl), watchoff);
			wff.sw=0;}	
	}
}
