Summary: SELinux documentation
Name: selinux-doc
Version: 1.20
Release: 1
License: Public Use License v1.0 
Group: System Environment/Base
Source: http://www.nsa.gov/selinux/archives/%{name}-%{version}.tgz
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-buildroot
BuildArch: noarch

%description
Security-enhanced Linux is a patch of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access Control,
and Multi-level Security.

This package contains build instructions, porting information, and a
CREDITS file for SELinux.  Some of these files will be split up into
per-package files in the future, and other documentation will be added
to this package (e.g. an updated form of the Configuring the SELinux
Policy report).

%prep
%setup -q

%build
make

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/usr/share/SELinux
install -m644 CREDITS PORTING README README.MLS README.CONDITIONAL ${RPM_BUILD_ROOT}/usr/share/SELinux
cp -a policy ${RPM_BUILD_ROOT}/usr/share/SELinux/
cp -a module ${RPM_BUILD_ROOT}/usr/share/SELinux/
cp -a uavc ${RPM_BUILD_ROOT}/usr/share/SELinux/
	
%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc /usr/share/SELinux


%changelog
* Wed Oct 1 2003 Dan Walsh <dwalsh@redhat.com> 1.2-3
- Update with NSA final 1.2 release

* Fri Sep 12 2003 Dan Walsh <dwalsh@redhat.com> 1.2-2
- Update with latest from NSA

* Mon Jun 2 2003 Dan Walsh <dwalsh@redhat.com> 1.2-1
- Update to 1.2

* Mon Jun 2 2003 Dan Walsh <dwalsh@redhat.com> 1.0-1
- Initial version








