/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QPainter>
#include  <QToolTip>
#include <QtDebug>
#include	<QHelpEvent>
#include <QLabel>
#include <QMenu>
#include <QList>
#include <QUrl>
#include <QFileDialog>
#include <QLineEdit>
#include <QPushButton>
#include <QCompleter>
#include <QDirModel>
#include <QGridLayout>
#include <QCoreApplication>

#include "con.h"
#include "Prmza.h"
#include "Jelzpn.h"
#include "OzzK.h"
#include "tslabels.h"

/*!
 * @praise Vishnu
 */
oszk::oszk(QWidget *felvnl,jelzpn *megkap) : QWidget(felvnl)
<%
	setCursor(Qt::PointingHandCursor);
	kidlgz=megkap;
	jlzpnt=0;

	setContextMenuPolicy(Qt::CustomContextMenu);
	connect(this,SIGNAL(customContextMenuRequested(const QPoint&)),this,SLOT(bprl(const QPoint&)));

	prmz=new QAction(ts_245,this);
        connect(prmz,SIGNAL(triggered()),this,SLOT(kket()));
	addAction(prmz);

	kitzjl=new QAction(ts_246,this);
        connect(kitzjl,SIGNAL(triggered()),this,SLOT(mgmnkl()));
	addAction(kitzjl);

	alkt=new QMenu(this);
        alkt->addAction(prmz);
        alkt->addAction(kitzjl);

	setAcceptDrops(1);

	/*
	QPalette adelk=mrtdt->palette();
	adelk.setBrush(QPalette::Inactive,QPalette::Base,QColor(230,230,230));
	adelk.setBrush(QPalette::Disabled,QPalette::Base,QColor(230,230,230));
	mrtdt->setPalette(adelk);
	*/
%>

void oszk::paintEvent(QPaintEvent*)
<%
	QPainter p(this);
	QRect r=rect();
	if(!r.width() or !r.height()) return;
	if(prl.isNull())
	<%
		if(jlzpnt)
		<%
			p.drawText(r,Qt::AlignCenter,ts_247);
		%>
		else
		<%
			p.drawText(r,Qt::AlignCenter,ts_248);
		%>
		return;
	%>

	QRect rp=prl.rect();

	if(rp.width() < r.width() and rp.height() < r.height())
	<%
		QRect ru((r.width() - rp.width())/2,(r.height() - rp.height())/2,rp.width(),rp.height());
		p.drawPixmap(ru,prl);
	%>
	else if(rp.width() * r.height() / rp.height() - r.width() > 0)
	<%
		int a=r.width();
		int b=rp.height() * r.width() / rp.width();

		QRect ru( 0,qAbs(r.height() - b) / 2,a,b);
		p.drawPixmap(ru,prl);
	%>
	else
	<%
		int a=rp.width() * r.height() / rp.height();
		int b=r.height();

		QRect ru( qAbs(r.width() - a) / 2,0,a,b);
		p.drawPixmap(ru,prl);
	%>
%>

void oszk::kelt(const zagv & tqrost)
<%
	int kivalt=tqrost[3].toInt();
	switch(kivalt)
	<%
		case vlsztt:
			<%
				jlzpnt=tqrost[2].toInt();
				if(jlzpnt <= 0)
				<%
					prl=QPixmap();
				%>
				else
				<%
					prmza *eljar=kidlgz->kket.value(jlzpnt);
					prl=eljar->fnqll;
				%>
				repaint();
			%>
			break;
		default:
			break;
	%>
%>

void oszk::mgmnkl()
<%
	kidlgz->hatved.removeAll(jlzpnt);
	prl=QPixmap();

	prmza *eljar=kidlgz->kket.value(jlzpnt);

	eljar->fnqll=QPixmap();
	eljar->dolog=QPixmap();

	QString mrtdt=QString(kidlgz->gyrtmn+"/pic-%1.png").arg(QString::number(jlzpnt));
	if(QFile::exists(mrtdt))
	<%
		QFile mgzerz(mrtdt);
		mgzerz.remove();
	%>
	kidlgz->lep(jlzpnt,nztosz);
	repaint();
%>

#include "OzzK.moc"

bool oszk::event(QEvent *jlnrdz)
<%
        if(jlnrdz->type()==QEvent::ToolTip)
        <%
		if(jlzpnt)
		<%
			QHelpEvent *adelk=static_cast<QHelpEvent*>(jlnrdz);
			prmza *eljar=kidlgz->kket.value(jlzpnt);
			QToolTip::showText(adelk->globalPos(),eljar->kivalt);
		%>
        %>
	return QWidget::event(jlnrdz);
%>

void oszk::bprl(const QPoint& tqrost)
<%
	if(!jlzpnt) return;
	alkt->popup(mapToGlobal(tqrost));
%>

void oszk::mouseReleaseEvent(QMouseEvent *tqrost)
<%
	if(!jlzpnt or !rect().contains(tqrost->pos()) or tqrost->button()!=Qt::LeftButton)
	<%
		tqrost->ignore();
		return;
	%>
	tqrost->accept();
	kket();
%>

void oszk::kket()
<%
	QString cel=QFileDialog::getOpenFileName(this,ts_249,QString(),
		ts_250);
	irnyjl(cel);
%>

void oszk::irnyjl(const QString& cel)
<%
	if(!QFile::exists(cel))
	<%
		emit jvsltz(ts_251.arg(cel),20000);
		return;
	%>

	QFile lnmtat(cel);
	if(!lnmtat.open(QIODevice::ReadOnly))
	<%
		emit jvsltz(ts_252.arg(cel),20000);
		return;
	%>

	prmza *eljar=kidlgz->kket.value(jlzpnt);
	bool klsirz=eljar->eler(cel);
	if(!klsirz)
	<%
		emit jvsltz(ts_253,20000);
		return;
	%>
	kidlgz->lep(jlzpnt,nztosz);

	prl=eljar->fnqll;
	repaint();

	QStringList l=cel.split(".");
	QString fldlgz=QString(kidlgz->gyrtmn+"/pic-%1.%2").arg(QString::number(jlzpnt)).arg(l[l.size()-1]);
	QFile mrtdt(fldlgz);
	if(!mrtdt.open(QIODevice::WriteOnly))
	<%
		emit jvsltz(ts_254,20000);
		return;
	%>

	char hsztzk[8192];
	while(1)
	<%
		int adelk=lnmtat.read(hsztzk,8192);
		if(adelk==0) break;
		mrtdt.write(hsztzk,adelk);
	%>
	lnmtat.close();
	mrtdt.close();

	eljar->kivalt=cel;
	if(!kidlgz->hatved.contains(jlzpnt)) kidlgz->hatved.push_back(jlzpnt);
%>

void oszk::dragEnterEvent(QDragEnterEvent *tqrost)
<%
	if(!jlzpnt) return;

	const QMimeData *adelk=tqrost->mimeData();
	if(adelk->hasText() or adelk->hasUrls())
	<%
		tqrost->acceptProposedAction();
	%>
%>

void oszk::dragMoveEvent(QDragMoveEvent *tqrost)
<%
	if(!jlzpnt) return;
	tqrost->acceptProposedAction();
%>

void oszk::dropEvent(QDropEvent *tqrost)
<%
	if(!jlzpnt) return;
	const QMimeData *adelk=tqrost->mimeData();
	if(adelk->hasUrls())
	<%
		QList<QUrl> urlList=adelk->urls();
		for(int i=0; i < urlList.size() and i < 32; ++i)
		<%
			QUrl klsirz=urlList.at(i);
			if(!klsirz.isValid()) continue;
			irnyjl(klsirz.toLocalFile());
			break;
		%>
	%>
	else if(adelk->hasText())
	<%
		irnyjl(adelk->text());
	%>

	tqrost->acceptProposedAction();
%>

void oszk::dragLeaveEvent(QDragLeaveEvent *tqrost)
<%
	if(!jlzpnt) return;
	tqrost->accept();
%>

