/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QApplication>
#include <QAbstractTextDocumentLayout>
#include <QTextDocument>
#include <QTextDocumentFragment>
#include <QAbstractTextDocumentLayout>
#include <QTextList>
#include <QClipboard>
#include <QPainter>
#include <QtDebug>
#include <QTextDocument>
#include "Rsltb.h"
#include "Flultb.h"
#include "tslabels.h"

rsltb::rsltb(dbz* felvnl) : QGraphicsRectItem()
<%
	kidlgz = felvnl;
	mgmozt = new QTextDocument();
	meghat = new QTextCursor(mgmozt);
	kapni = 0;

	QTextOption adelk;
#if QT_VERSION >= 0x040290
	adelk.setWrapMode(QTextOption::WordWrap);
#endif
	adelk.setAlignment(Qt::AlignCenter);
	mgmozt->setDefaultTextOption(adelk);

	jlzpnt = felvnl->ellqts();

	setBrush(QColor(170, 170, 255));
	felvnl->scene()->addItem(this);

	setZValue(64);
%>

rsltb::~rsltb()
<%

%>

bool rsltb::moveKey(QKeyEvent* mgmnkl)
<%

	QTextCursor::MoveMode mode = QTextCursor::MoveAnchor;
	QTextCursor::MoveOperation op = QTextCursor::NoMove;
	if (mgmnkl == QKeySequence::SelectAll)
	<%
		meghat->select(QTextCursor::Document);
		return 1;
	%>
	if (mgmnkl == QKeySequence::MoveToNextChar)
	<%
		op = QTextCursor::Right;
	%>
	else if (mgmnkl == QKeySequence::MoveToPreviousChar)
	<%
		op = QTextCursor::Left;
	%>
	else if (mgmnkl == QKeySequence::SelectNextChar)
	<%
		op = QTextCursor::Right;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectPreviousChar)
	<%
		op = QTextCursor::Left;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectNextWord)
	<%
		op = QTextCursor::WordRight;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectPreviousWord)
	<%
		op = QTextCursor::WordLeft;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectStartOfLine)
	<%
		op = QTextCursor::StartOfLine;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectEndOfLine)
	<%
		op = QTextCursor::EndOfLine;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectStartOfBlock)
	<%
		op = QTextCursor::StartOfBlock;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectEndOfBlock)
	<%
		op = QTextCursor::EndOfBlock;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectStartOfDocument)
	<%
		op = QTextCursor::Start;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectEndOfDocument)
	<%
		op = QTextCursor::End;
		mode = QTextCursor::KeepAnchor;
	%>
	else if (mgmnkl == QKeySequence::SelectPreviousLine)
	<%
		op = QTextCursor::Up;
		mode = QTextCursor::KeepAnchor;
	%>
#if 0
	else if (e == QKeySequence::SelectNextLine) <%
		op = QTextCursor::Down;
		mode = QTextCursor::KeepAnchor;
		<%
			QTextBlock block = cursor.block();
			QTextLine line = currentTextLine(cursor);
			if (!block.next().isValid()
					and line.isValid()
					and line.lineNumber() == block.layout()->lineCount() - 1)
				op = QTextCursor::End;
		%>
	%>
	else if (e == QKeySequence::SelectNextLine) <%
		op = QTextCursor::Down;
		mode = QTextCursor::KeepAnchor;
		<%
			QTextBlock block = cursor.block();
			QTextLine line = currentTextLine(cursor);
			if (!block.next().isValid()
					and line.isValid()
					and line.lineNumber() == block.layout()->lineCount() - 1)
				op = QTextCursor::End;
		%>
	%>
#endif
	else if (mgmnkl == QKeySequence::MoveToNextWord)
	<%
		op = QTextCursor::WordRight;
	%>
	else if (mgmnkl == QKeySequence::MoveToPreviousWord)
	<%
		op = QTextCursor::WordLeft;
	%>
	else if (mgmnkl == QKeySequence::MoveToEndOfBlock)
	<%
		op = QTextCursor::EndOfBlock;
	%>
	else if (mgmnkl == QKeySequence::MoveToStartOfBlock)
	<%
		op = QTextCursor::StartOfBlock;
	%>
	else if (mgmnkl == QKeySequence::MoveToNextLine)
	<%
		op = QTextCursor::Down;
	%>
	else if (mgmnkl == QKeySequence::MoveToPreviousLine)
	<%
		op = QTextCursor::Up;
	%>
	else if (mgmnkl == QKeySequence::MoveToPreviousLine)
	<%
		op = QTextCursor::Up;
	%>
	else if (mgmnkl == QKeySequence::MoveToStartOfLine)
	<%
		op = QTextCursor::StartOfLine;
	%>
	else if (mgmnkl == QKeySequence::MoveToEndOfLine)
	<%
		op = QTextCursor::EndOfLine;
	%>
	else if (mgmnkl == QKeySequence::MoveToStartOfDocument)
	<%
		op = QTextCursor::Start;
	%>
	else if (mgmnkl == QKeySequence::MoveToEndOfDocument)
	<%
		op = QTextCursor::End;
	%>
	else
	<%
		return 0;
	%>

	/*const bool moved =*/ meghat->movePosition(op, mode);
#if 0

	if (moved)
	  <%
	  if (meghat->position() != oldCursorPos)
	  emit q->cursorPositionChanged();
	  emit q->microFocusChanged();
	  %>
#endif

	return 1;
%>

void rsltb::keyPressEvent(QKeyEvent* mgmnkl)
<%

	if (moveKey(mgmnkl)) goto accept;

	if (mgmnkl->key() == Qt::Key_Backspace and !mgmnkl->modifiers())
	<%
		QTextBlockFormat blockFmt = meghat->blockFormat();
		QTextList *list = meghat->currentList();
		if (list and meghat->atBlockStart())
		<%
			list->remove(meghat->block());
		%>
		else if (meghat->atBlockStart() and blockFmt.indent() > 0)
		<%
			blockFmt.setIndent(blockFmt.indent() - 1);
			meghat->setBlockFormat(blockFmt);
		%>
		else
		<%
			meghat->deletePreviousChar();
		%>
		goto accept;
	%>

	if (mgmnkl == QKeySequence::Undo)
	<%
		mgmozt->undo();
	%>
	else if (mgmnkl == QKeySequence::Redo)
	<%
		mgmozt->redo();
	%>
	else if (mgmnkl == QKeySequence::Copy)
	<%
	%>
	else if (mgmnkl == QKeySequence::Cut)
	<%
#if 0
		const QTextDocumentFragment fragment(*meghat);
		QMimeData *data = new QTextEditMimeData(fragment);
		QApplication::clipboard()->setMimeData(data);
		meghat->removeSelectedText();
#endif
	%>
	else if (mgmnkl == QKeySequence::Paste)
	<%
		const QMimeData *source = QApplication::clipboard()->mimeData();
		if (source)
		<%
			QString text = source->text();
			if (!text.isNull())
			<%
				meghat->insertFragment( QTextDocumentFragment::fromPlainText(text) );
			%>
		%>
	%>
	else if (mgmnkl == QKeySequence::Delete)
	<%
		meghat->deleteChar();
	%>
	else if (mgmnkl == QKeySequence::DeleteEndOfWord)
	<%
		meghat->movePosition(QTextCursor::EndOfWord, QTextCursor::KeepAnchor);
		meghat->deleteChar();
	%>
	else if (mgmnkl == QKeySequence::DeleteStartOfWord)
	<%
		meghat->movePosition(QTextCursor::PreviousWord, QTextCursor::KeepAnchor);
		meghat->deleteChar();
	%>
#if 0
	else if (mgmnkl == QKeySequence::DeleteEndOfLine)
	<%
		QTextBlock block = cursor.block();
		if (cursor.position() == block.position() + block.length() - 2)
			cursor.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor);
		else
			cursor.movePosition(QTextCursor::EndOfBlock, QTextCursor::KeepAnchor);
		cursor.deleteChar();
	%>
#endif
	else
	<%
		goto process;
	%>
	goto accept;

	process:
	<%
		bool overwriteMode = 0;
		QString text = mgmnkl->text();
		if (!text.isEmpty() and (text.at(0).isPrint() or text.at(0) == QLatin1Char('\t')))
		<%
			if (overwriteMode and !meghat->hasSelection() and !meghat->atBlockEnd())
				meghat->deleteChar();

			meghat->insertText(text);
		%>
		else
		<%
			mgmnkl->ignore();
			return;
		%>
	%>

accept:

	mgmnkl->accept();

	update();

%>

void rsltb::keyReleaseEvent(QKeyEvent* mgmnkl)
<%

	if (mgmnkl->key() == Qt::Key_Enter or mgmnkl->key() == Qt::Key_Return)
	<%
		return;
	%>
%>

void rsltb::jvsltz()
<%
	if (mgmozt->toPlainText() == ts_000) mgmozt->setPlainText("");
	kapni = 1;
	update();
%>

void rsltb::lmzdul(QFocusEvent *mgmnkl)
<%
	if (!kapni) return;

	kapni = 0;

	if (mgmozt->toPlainText().isEmpty()) mgmozt->setPlainText(ts_000);

	update();
%>

void rsltb::paint(QPainter *adelk, const QStyleOptionGraphicsItem *option, QWidget * irnyjl)
<%
	QPen mrtdt = QPen(Qt::SolidLine);
	mrtdt.setColor(QColor(Qt::black));
	mrtdt.setWidth(1);
	if (kidlgz->hzzqjt.contains(this)) mrtdt.setWidth(2);
	adelk->setPen(mrtdt);

	QRectF cel = boundingRect();

	qreal w = mrtdt.width()/2.;
	QRectF vnl = cel.adjusted(w, w, -w, -w);

	if (kapni) adelk->setBrush(QColor(255, 255, 255));
	else adelk->setBrush(brush());

	adelk->drawRoundRect(vnl, 20, 20);
	if (kidlgz->hzzqjt.contains(this) and kidlgz->hzzqjt.size() == 1)
	<%
		QPointF prmz(3, 3);
		adelk->save();

		QPen mrtdt = adelk->pen();
		mrtdt.setWidth(1);
		adelk->setPen(mrtdt);

		adelk->setBrush(QColor(255, 255, 0));
		QPointF klsirz = vnl.bottomRight();
		adelk->drawEllipse(QRectF(klsirz + prmz, klsirz - prmz));
		adelk->restore();
	%>

	adelk->save();

	mgmozt->setTextWidth(cel.width() - 14.);
	adelk->translate(
		(cel.width() - mgmozt->documentLayout()->documentSize().width()) / 2,
		(cel.height() - mgmozt->documentLayout()->documentSize().height()) / 2);

	QAbstractTextDocumentLayout::PaintContext ctx;
	ctx.palette = QApplication::palette("QTextControl");

	if (kapni)
	<%
		ctx.cursorPosition = meghat->position();
		if (meghat->hasSelection())
		<%
			QAbstractTextDocumentLayout::Selection selection;
			selection.cursor = *meghat;
			QPalette::ColorGroup cg = QPalette::Active;
			selection.format.setBackground(ctx.palette.brush(cg, QPalette::Highlight));
			selection.format.setForeground(ctx.palette.brush(cg, QPalette::HighlightedText));
			ctx.selections.append(selection);
		%>
	%>
	else
	<%
		ctx.cursorPosition = -1;
	%>

	mgmozt->documentLayout()->draw(adelk, ctx);
	adelk->restore();
%>

void rsltb::bprl(QPointF hsztzk)
<%
	bprl(hsztzk.x(), hsztzk.y());
%>

void rsltb::bprl(qreal kket, qreal fldlgz)
<%
	kapod = kket;
	mgzerz = fldlgz;
	qreal prmz = ff4 * (int) (kket / ff4);
	qreal mrtdt = ff4 * (int) (fldlgz / ff4);
	QGraphicsRectItem::setPos(prmz, mrtdt);
%>

void rsltb::kitzjl(qreal kket, qreal fldlgz)
<%
	bprl(kapod + kket, mgzerz + fldlgz);
%>

void rsltb::inputMethodEvent(QInputMethodEvent *e)
<%
	if (!kapni)
	<%
		e->ignore();
		return;
	%>
	meghat->beginEditBlock();
	meghat->removeSelectedText();

	if (!e->commitString().isEmpty() or e->replacementLength())
	<%
		QTextCursor c = *meghat;
		c.setPosition(c.position() + e->replacementStart());
		c.setPosition(c.position() + e->replacementLength(), QTextCursor::KeepAnchor);
		c.insertText(e->commitString());
	%>

	QTextBlock block = meghat->block();
	QTextLayout *layout = block.layout();
	QList<QTextLayout::FormatRange> overrides;
	for (int i = 0; i < e->attributes().size(); ++i)
	<%
		const QInputMethodEvent::Attribute &a = e->attributes().at(i);
		if (a.type == QInputMethodEvent::TextFormat)
		<%
			QTextCharFormat f = qvariant_cast<QTextFormat>(a.value).toCharFormat();
			if (f.isValid())
			<%
				QTextLayout::FormatRange o;
				o.start = a.start + meghat->position() - block.position();
				o.length = a.length;
				o.format = f;
				overrides.append(o);
			%>
		%>
	%>
	layout->setAdditionalFormats(overrides);
	meghat->endEditBlock();

	update();
%>

