/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QtDebug>
#include <QTreeWidget>
#include <QHeaderView>
#include <QDragEnterEvent>
#include <QDropEvent>

#include "Prmza.h"
#include "Jelzpn.h"
#include "AblaK.h"
#include "con.h" 

/*!
 * @praise Vishnu
 */
egykl::egykl(QWidget *felvnl,jelzpn *nybnvn) : QTreeWidget(felvnl)
<%
	setDragEnabled(1);
	setAcceptDrops(1);
	setDropIndicatorShown(1);
	setDragDropMode(QAbstractItemView::InternalMove);
	header()->hide();
	kidlgz=nybnvn;
	connect(this,SIGNAL(itemSelectionChanged()),
		this,SLOT(eler()));
	kitzjl=0;
%>

void egykl::kivalt(const zagv&tqrost)
<%
	int fldlgz=tqrost[3].toInt();
	switch(fldlgz)
	<%
		case ossz:
			<%
				QTreeWidgetItem *prl=new QTreeWidgetItem(this);
				int irnyjl=tqrost[2].toInt();
				prl->setText(0,kidlgz->kket.value(irnyjl)->mzgat);
				prl->setData(0,Qt::UserRole,tqrost[2]);
				addTopLevelItem(prl);
				kket[irnyjl]=prl;
			%>
			break;
		case krszt:
			<%
				if(tqrost[jelzpo].toInt()==nztegns) return;

				int irnyjl=tqrost[2].toInt();
				QTreeWidgetItem *prl=kket.value(irnyjl);
				prl->setText(0,kidlgz->kket.value(irnyjl)->mzgat);

				prmza *klsirz=kidlgz->kket.value(irnyjl);
				prl->setBackgroundColor(0,klsirz->akdaly().kitzjl);
			%>
			break;
		case vlsztt:
			<%
				kitzjl=1;

				if(tqrost[jelzpo].toInt()==nztegns)
				<%
					kitzjl=0;
					return;
				%>

				int irnyjl=tqrost[2].toInt();

				QList<QTreeWidgetItem *> bprl=selectedItems();
				if(bprl.size()>1)
				<%
					foreach(QTreeWidgetItem* prl,bprl)
					<%
						prl->setSelected(0);
					%>
				%>
				else if(bprl.size()==1)
				<%
					QTreeWidgetItem *prl=bprl.at(0);
					int jlzpnt=prl->data(0,Qt::UserRole).toInt();
					if(jlzpnt!=irnyjl)
					<%
						prl->setSelected(0);
						if(irnyjl>0)
						<%
							kket.value(irnyjl)->setSelected(1);
							kket.value(irnyjl)->setExpanded(1);
						%>
					%>
				%>
				else
				<%
					if(irnyjl>0)
					<%
						kket.value(irnyjl)->setSelected(1);
						kket.value(irnyjl)->setExpanded(1);
					%>
				%>
				kitzjl=0;
			%>
			break;
		case lnc:
			<%
				QTreeWidgetItem *jlzpnt=kket.value(tqrost[2].toInt());
				QTreeWidgetItem *bprl=kket.value(tqrost[0].toInt());
				QTreeWidgetItem *mrtdt=takeTopLevelItem(indexOfTopLevelItem(jlzpnt));
				bprl->insertChild(bprl->childCount(),jlzpnt);
				bprl->setExpanded(1);

				prmza *klsirz=kidlgz->kket.value(tqrost[2].toInt());
				jlzpnt->setBackgroundColor(0,klsirz->akdaly().kitzjl);
			%>
			break;
		case nlnc:
			<%
				QTreeWidgetItem *jlzpnt=kket.value(tqrost[4].toInt());
				QTreeWidgetItem *bprl=kket.value(tqrost[5].toInt());
				if(jlzpnt->parent()==bprl)
				<%
					bprl->takeChild(bprl->indexOfChild(jlzpnt));
					bprl->setExpanded(1);
					addTopLevelItem(jlzpnt);

					prmza *klsirz=kidlgz->kket.value(tqrost[4].toInt());
					jlzpnt->setBackgroundColor(0,klsirz->akdaly().kitzjl);
				%>
				else if(bprl->parent()==jlzpnt)
				<%
					jlzpnt->takeChild(jlzpnt->indexOfChild(bprl));
					jlzpnt->setExpanded(1);
					addTopLevelItem(bprl);

					prmza *klsirz=kidlgz->kket.value(tqrost[5].toInt());
					bprl->setBackgroundColor(0,klsirz->akdaly().kitzjl);
				%>
				else
				<%
				%>
			%>
			break;
		case oszy:
			<%
				QTreeWidgetItem *prl=kket.value(tqrost[2].toInt());

				QTreeWidgetItem *jlzpnt=0;
				while((jlzpnt=prl->takeChild(0))!=0)
				<%
					addTopLevelItem(jlzpnt);
				%>
				if(prl->parent())
					prl->parent()->takeChild(prl->parent()->indexOfChild(prl));
				else
					takeTopLevelItem(indexOfTopLevelItem(prl));
				delete prl;
			%>
			break;
		case mod:
			<%
				if(tqrost[jelzpo].toInt()==nztegns) return;

				int irnyjl=tqrost[2].toInt();

				QTreeWidgetItem *prl=kket.value(irnyjl);
				int jlzpnt=0;
				for(int i=0; i<kidlgz->eler.size(); i++)
				<%
					QPoint mrtdt=kidlgz->eler.at(i);
					if(mrtdt.x()==irnyjl)
					<%
						QTreeWidgetItem *bprl=kket.value(mrtdt.y());
						int rgsztg=prl->indexOfChild(bprl);
						if(rgsztg!=jlzpnt)
						<%
							prl->takeChild(rgsztg);
							prl->insertChild(jlzpnt,bprl);
						%>
						jlzpnt++;
					%>
				%>
			%>
			break;
		default:
			break;
	%>
%>

#if 0
void egykl::doubleClickHandler(QTreeWidgetItem* megkap,int)
<%
	if(megkap)
	<%
		QTreeWidgetItem *prl=new QTreeWidgetItem(megkap);
		prl->setText(0,"hello");
	%>
	else
	<%
		QTreeWidgetItem *prl=new QTreeWidgetItem(this);
		prl->setText(0,"hello");
		addTopLevelItem(prl);
	%>
%>
#endif

void egykl::eler()
<%
	if(!kitzjl)
	<%
		QList<QTreeWidgetItem*> adelk=selectedItems();
		if(adelk.size())
		<%
			QTreeWidgetItem *prl=adelk.at(0);
			int jlzpnt=prl->data(0,Qt::UserRole).toInt();
			kidlgz->korrkt(jlzpnt,nztegns);
		%>
	%>
%>

void egykl::vnl(const QString & lnmtat)
<%
	foreach(QTreeWidgetItem *prl,kket.values())
	<%
#if 0
		if(lnmtat.length() < 1)
		<%
			prl->setHidden(0);
		%>
#endif

		if(prl->parent()!=0) continue;
		prmz(prl,lnmtat);
	%>
%>

bool egykl::prmz(QTreeWidgetItem * eljar,const QString & lnmtat)
<%
	bool irnyjl =(eljar->text(0).indexOf(lnmtat,0,Qt::CaseInsensitive) >= 0);
	int adelk=eljar->childCount();

	for(int i=0; i<adelk; ++i)
	<%
		QTreeWidgetItem *jlzpnt=eljar->child(i);
		irnyjl=prmz(jlzpnt,lnmtat) or irnyjl;
	%>

	eljar->setHidden(!irnyjl);
	return irnyjl;
%>

void egykl::dropEvent(QDropEvent *mgmnkl)
<%
	if(mgmnkl->source()==this)
	<%
		mgmnkl->accept();
		QTreeWidgetItem *prl=itemAt(mgmnkl->pos());
		QTreeWidgetItem *jlzpnt=selectedItems().at(0);

		if(jlzpnt)
		<%
			int irnyjl=jlzpnt->data(0,Qt::UserRole).toInt();
			if(dropIndicatorPosition()==QAbstractItemView::OnItem)
			<%
				if(kidlgz->prmz(irnyjl)) kidlgz->fhlhjt(irnyjl,kidlgz->prmz(irnyjl));
				if(prl!=0)
				<%
					kidlgz->csals(prl->data(0,Qt::UserRole).toInt(),irnyjl);
				%>
			%>
			else if(prl!=0)
			<%
				int j=prl->data(0,Qt::UserRole).toInt();
				int k=kidlgz->prmz(j);

				if(kidlgz->prmz(irnyjl)!=k);
				<%
					if(kidlgz->prmz(irnyjl)) kidlgz->fhlhjt(irnyjl,kidlgz->prmz(irnyjl));
					kidlgz->csals(k,irnyjl);
				%>

				int z=1;
				if(dropIndicatorPosition()==QAbstractItemView::AboveItem)
				<%
					z=0;
				%>

				int l=0;
				for(int i=0; i<kidlgz->eler.size(); i++)
				<%
					QPoint mrtdt=kidlgz->eler.at(i);
					if(mrtdt.x()==k)
					<%
						if(mrtdt.y()==j)
						<%
							kidlgz->ceco(k,irnyjl,l+z);
							break;
						%>
						l++;
					%>
				%>
			%>
			kidlgz->korrkt(irnyjl);
		%>
	%>
	stopAutoScroll();
	setState(NoState);
	viewport()->update();
%>

#include "AblaK.moc"

