/// Copyright Thomas Nagy 2007
/// License: QPL
#include <Python.h>

#include <aux.h>
#include <QFile>
#include <QtDebug>
#include <QByteArray>
#include "BnvzS.h"
#include "tslabels.h"

PyObject *megkap(const QString &meghat)
<%
	QByteArray adelk=meghat.toUtf8();
	PyObject *klsirz=PyString_FromStringAndSize(adelk.data(),adelk.size());
	return klsirz;
%>

QString hzzqjt(PyObject* tqrost)
<%
	if(!tqrost) return QString();

	int jlzpnt=PyString_Check(tqrost);
	if(!jlzpnt)
	<%
		return QString();
	%>

	int irnyjl=PyString_Size(tqrost);
	char * adelk=PyString_AsString(tqrost);

	QString mrtdt=QString::fromUtf8(adelk,irnyjl);
	return mrtdt;
%>

PyObject *fnqll(PyObject *meghat,PyObject *eler)
<%
	bndkli *adelk=bndkli::instance();
	return PyCObject_FromVoidPtr(adelk,0);
%>

PyObject *vnl(PyObject *meghat,PyObject *eler)
<%
	PyObject * prl=0;
	int num=0;
	if(!PyArg_ParseTuple(eler,"Oi",&prl,&num)) <%  return 0; %>
	bndkli *irnyjl =(bndkli*) PyCObject_AsVoidPtr(prl);
	bndkli *adelk=irnyjl->mgmnkl(num);
	return PyCObject_FromVoidPtr(adelk,0);
%>

PyObject *mgmnkl(PyObject *meghat,PyObject *eler)
<%
	PyObject * prl=0;
	int row=0; int col=0;
	if(!PyArg_ParseTuple(eler,"Oii",&prl,&row,&col)) <%  return 0; %>
	bndkli *irnyjl =(bndkli*) PyCObject_AsVoidPtr(prl);
	QString content=irnyjl->lnmtat(row,col);
	return megkap(content);
%>

PyObject *lnmtat(PyObject *meghat,PyObject *eler)
<%
	PyObject * prl=0;
	if(!PyArg_ParseTuple(eler,"O",&prl)) <%  return 0; %>
	bndkli *irnyjl =(bndkli*) PyCObject_AsVoidPtr(prl);
	int num=irnyjl->fladat();
	return Py_BuildValue("i",num);
%>

PyObject *kket(PyObject *meghat,PyObject *eler)
<%
	PyObject * prl=0;
	if(!PyArg_ParseTuple(eler,"O",&prl)) <%  return 0; %>
	bndkli *irnyjl =(bndkli*) PyCObject_AsVoidPtr(prl);
	int num=irnyjl->akdaly();
	return Py_BuildValue("i",num);
%>

PyObject *felvnl(PyObject *meghat,PyObject *eler)
<%
	PyObject * prl=0;
	if(!PyArg_ParseTuple(eler,"O",&prl)) <%  return 0; %>
	bndkli *irnyjl =(bndkli*) PyCObject_AsVoidPtr(prl);
	int adelk=irnyjl->nybnvn();
	return Py_BuildValue("i",adelk);
%>

PyObject *fldlgz(PyObject *meghat,PyObject *eler)
<%
	PyObject *prl=0;
	PyObject *irnyjl=0;
	if(!PyArg_ParseTuple(eler,"OO",&prl,&irnyjl)) <%  return 0; %>
	bndkli* klsirz =(bndkli*) PyCObject_AsVoidPtr(prl);
	QString adelk=hzzqjt(irnyjl);
	QString mrtdt=klsirz->cel(adelk);
	return megkap(mrtdt);
%>

PyObject *bprl(PyObject *meghat,PyObject *eler)
<%
	PyObject *prl=0;
	PyObject *irnyjl=0;
	PyObject *adelk=0;
	if(!PyArg_ParseTuple(eler,"OOO",&prl,&irnyjl,&adelk)) <%  return 0; %>
	bndkli* klsirz =(bndkli*) PyCObject_AsVoidPtr(prl);
	QString kitzjl=hzzqjt(irnyjl);
	QString val=hzzqjt(adelk);
	klsirz->dolog(kitzjl,val);
	return Py_None;
%>

PyObject *prmz(PyObject *meghat,PyObject *eler)
<%
	PyObject *prl=0;
	if(!PyArg_ParseTuple(eler,"O",&prl)) <%  return 0; %>
	QString adelk=hzzqjt(prl);
	QString mrtdt=bndkli::kitzjl(adelk);
	return megkap(mrtdt);
%>

PyObject *jlzpnt(PyObject *meghat,PyObject *eler)
<%
	PyObject *prl=0;
	PyObject *irnyjl=0;
	if(!PyArg_ParseTuple(eler,"OO",&prl,&irnyjl)) <%  return 0; %>
	QString kitzjl=hzzqjt(prl);
	QString adelk=hzzqjt(irnyjl);

	bndkli::kidlgz(kitzjl,adelk);
	return Py_None;
%>

PyObject *irnyjl(PyObject *meghat,PyObject *eler)
<%
	PyObject *prl=0;
	if(!PyArg_ParseTuple(eler,"O",&prl)) <%  return 0; %>
	QString kitzjl=hzzqjt(prl);
	QString mrtdt=bndkli::protectXML(kitzjl);
	return megkap(mrtdt);
%>

PyObject *adelk(PyObject *meghat,PyObject *eler)
<%
	PyObject *prl=0;
	if(!PyArg_ParseTuple(eler,"O",&prl)) <%  return 0; %>
	QString kitzjl=hzzqjt(prl);
	QString mrtdt=bndkli::protectHTML(kitzjl);
	return megkap(mrtdt);
%>

static PyMethodDef methods[]=<%
	<%"child_count",lnmtat,METH_VARARGS,0%>,
	<%"child_num",  vnl,METH_VARARGS,0%>,
	<%"get_val",  fldlgz,METH_VARARGS,0%>,
	<%"set_val",  bprl,METH_VARARGS,0%>,

	<%"num_rows",kket,METH_VARARGS,0%>,
	<%"num_cols",felvnl,METH_VARARGS,0%>,
	<%"get_cell",mgmnkl,METH_VARARGS,0%>,

	<%"instance",fnqll,METH_VARARGS,0%>,
	<%"get_var", prmz,METH_VARARGS,0%>,
	<%"set_var", jlzpnt,METH_VARARGS,0%>,

	<%"protectXML",irnyjl,METH_VARARGS,0%>,
	<%"protectHTML",adelk,METH_VARARGS,0%>,

	<% 0,0,0,0 %>
%>;

int prl()
<%
	if(Py_IsInitialized()) return 1;

	Py_Initialize();
	Py_InitModule("sembind",methods);
	QFile klsirz(SEMANTIK_DIR "/sembind.py");
	if(!klsirz.open(QIODevice::ReadOnly)) <% return 0; %>
	QByteArray akdaly=klsirz.readAll();
	klsirz.close();
	PyRun_SimpleString(akdaly.constData());

	return 1;
%>

