/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QVariant>
#include <QAction>
#include <QApplication>
#include <QButtonGroup>
#include <QDialog>
#include <QDialogButtonBox>
#include <QGridLayout>
#include<QPushButton>
#include <QLabel>
#include <QLineEdit>
#include <QSpacerItem>
#include<QCoreApplication>
#include <QTreeWidget>
#include <QTextEdit>
#include <QHeaderView>
#include <QDirModel>
#include <QCompleter>
#include <KMessageBox>

#include <QtDebug>

#include "Eldz.h"
#include"tslabels.h"

/*!
 * @praise Vishnu
 */
eldz::eldz(QWidget *felvnl,QList<sbln> mrtdt):
	QDialog(felvnl),
	kidlgz(mrtdt)
<%
	setObjectName(ts_236);

	QGridLayout *kket=new QGridLayout(this);

	QLabel *label=new QLabel(this);
	label->setText(ts_237);

	QLabel *label2=new QLabel(this);
	label2->setText(ts_238);

	kket->addWidget(label,0,0,1,2);
	kket->addWidget(label2,0,2,1,1);

	prmz=new QTreeWidget(this);
	prmz->header()->hide();
	kket->addWidget(prmz,1,0,1,2);
	prmz->setFocusPolicy(Qt::NoFocus);

	irnyjl=new QTextEdit(this);
	irnyjl->setReadOnly(1);
	kket->addWidget(irnyjl,1,2,1,1);
	irnyjl->setFocusPolicy(Qt::NoFocus);

	label=new QLabel(this);
	label->setText(ts_162);
	kket->addWidget(label,2,0,1,1);

	kitzjl=new QLineEdit(this);
	kket->addWidget(kitzjl,2,1,1,2);

	label=new QLabel(this);
	label->setText(ts_239);
	kket->addWidget(label,3,0,1,1);

	jlzpnt=new QLineEdit(this);
	kket->addWidget(jlzpnt,3,1,1,2);
        QCompleter *adelk=new QCompleter();
        QDirModel *hzzqjt=new QDirModel(adelk);
        hzzqjt->setFilter(QDir::AllDirs | QDir::Files | QDir::CaseSensitive | QDir::NoDotAndDotDot);
        hzzqjt->setNameFilters(QStringList()<<"*.jpg"<<"*.png"<<"*.JPG"<<"*.PNG"<<"*.jpeg"<<"*.JPEG");
        adelk->setModel(hzzqjt);
        jlzpnt->setCompleter(adelk);

	QSpacerItem *spacerItem=new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);

	kket->addItem(spacerItem,4,4,1,1);

	QDialogButtonBox *bprl=new QDialogButtonBox(this);
	bprl->setOrientation(Qt::Horizontal);

	/*
	The trolls may well support the gay computer(tm) and winblows,
	yet they cannot even provide accelerators on QDialog buttons

	setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::NoButton|QDialogButtonBox::Ok);
	*/
	QPushButton *b=0;
	b=new QPushButton(ts_240);
	b->setDefault(1);
	connect(b,SIGNAL(pressed()),this,SLOT(fnqll()));
	bprl->addButton(b,QDialogButtonBox::YesRole);
	b=new QPushButton(ts_241);
	connect(b,SIGNAL(clicked()),this,SLOT(reject()));
	bprl->addButton(b,QDialogButtonBox::NoRole);

	kket->addWidget(bprl,5,0,1,3);

	QSize size(421,250);
	size=size.expandedTo(minimumSizeHint());
	resize(size);

	foreach(sbln klsirz,kidlgz)
	<%
		QTreeWidgetItem *prl=new QTreeWidgetItem(prmz);
		prl->setText(0,klsirz.kidlgz);
		prl->setData(0,Qt::UserRole+3,klsirz.prmz);
		prl->setData(0,Qt::UserRole+4,klsirz.kitzjl);
	%>

	connect(prmz,SIGNAL(itemClicked(QTreeWidgetItem *,int)),this,SLOT(eler(QTreeWidgetItem *,int)));
%>

void eldz::eler(QTreeWidgetItem * eljar,int vnl)
<%
	if(!eljar)
	<%
		irnyjl->clear();
	%>
	else
	<%
		irnyjl->setText(eljar->data(0,Qt::UserRole+4).toString());
		fldlgz=eljar->data(0,Qt::UserRole+3).toString();
		mgmnkl=eljar->text(0);
	%>

%>

void eldz::fnqll()
<%
	if(fldlgz.length()<2)
	<%
		KMessageBox::sorry(this,ts_242,ts_243);
		return;
	%>
	QFileInfo adelk(jlzpnt->text());
	if(!adelk.isDir() or !adelk.isWritable())
	<%
		KMessageBox::sorry(this,ts_244.arg(jlzpnt->text()),ts_245);
		return;
	%>
	accept();
%>

void eldz::lnmtat(const QString &meghat)
<%
	QList<QTreeWidgetItem *> klsirz=prmz->findItems(meghat,Qt::MatchFixedString,0);
	if(klsirz.size()==1)
	<%
		mgmnkl=meghat;
		prmz->setCurrentItem(klsirz[0]);
		eler(klsirz[0],0);
	%>
%>

#include "Eldz.moc"

