/// Copyright Thomas Nagy 2007
/// License: QPL

#include "elgyk.h"
#include "Prmza.h"
#include  <QtGlobal>
#include "Jelzpn.h"
#include "Flult.h"
#include  <QMenu> 
#include <QToolTip>
#include  <QColorDialog> 
#include<KToolBar> 
#include  <QActionGroup> 
#include "Rslt.h"
#include "Izlt.h"
#include<QCoreApplication>
#include "Szrt.h"
#include "Bnvzs.h"
#include <QTextCursor> 
#include  <QApplication> 
#include <QtDebug>
#include  <QX11Info>
#include <QScrollBar>
#include  <QGraphicsScene>
#include <QWheelEvent>
#include  <QMatrix>
#include <QPointF>
#include "tslabels.h"

#include <math.h>

/*!
 * @praise Vishnu
 */
felu::felu(QWidget *megkap,jelzpn *nybnvn) : QGraphicsView(megkap)
<%
	leir=megkap;

	kapod=new QRubberBand(QRubberBand::Rectangle,this);
	kapod->setGeometry(QRect(0,0,0,0));

	QGraphicsScene *irnyjl=new QGraphicsScene(this);
	irnyjl->setSceneRect(-400,-400,400,400);
	setScene(irnyjl);

	setRenderHint(QPainter::Antialiasing);

	#ifndef Q_OS_DARWIN

	setDragMode(QGraphicsView::NoDrag);

	setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
	setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);

	setMinimumSize(200,200);

	#ifdef O
	#endif

	/*QMatrix k(0,1,1,0,0,0);
	QMatrix kv(1,0,0,-1,0,0);*/
	kidlgz=nybnvn;
	/*setMatrix(adelk);
	scale(0.8,0.8);*/
	#endif

	fortum=meghat;
	nagy=mgmozt;

	akdaly=0;

	ir=new mgzerz(QRubberBand::Line,this);

	QBrush bprl=QBrush();

	QColor fldlgz=QColor(0,0,150,100);

	QAction *klsirz=0;

	cel=new QAction(ts_001,this);
	cel->setShortcut(ts_002);
        connect(cel,SIGNAL(triggered()),this,SLOT(dolog()));
	addAction(cel);

	fladat=new QAction(ts_003,this);
	fladat->setShortcut(ts_004);
        connect(fladat,SIGNAL(triggered()),this,SLOT(zandek()));
	addAction(fladat);

	targy=new QAction(ts_005,this);
	targy->setShortcut(ts_006);
        connect(targy,SIGNAL(triggered()),this,SLOT(alkt()));
	addAction(targy);

	klsirz=new QAction(ts_007,this);
	klsirz->setShortcut(ts_008);
        connect(klsirz,SIGNAL(triggered()),this,SLOT(megir()));
	addAction(klsirz);

	klsirz=new QAction(ts_009,this); klsirz->setShortcut(ts_010); connect(klsirz,SIGNAL(triggered()),this,SLOT(lemasl())); addAction(klsirz); klsirz->setData(QVariant(0));
	klsirz=new QAction(ts_011,this); klsirz->setShortcut(ts_012); connect(klsirz,SIGNAL(triggered()),this,SLOT(lemasl())); addAction(klsirz); klsirz->setData(QVariant(1));
	klsirz=new QAction(ts_013,this); klsirz->setShortcut(ts_014); connect(klsirz,SIGNAL(triggered()),this,SLOT(lemasl())); addAction(klsirz); klsirz->setData(QVariant(2));
	klsirz=new QAction(ts_015,this); klsirz->setShortcut(ts_016); connect(klsirz,SIGNAL(triggered()),this,SLOT(lemasl())); addAction(klsirz); klsirz->setData(QVariant(3));

	klsirz=new QAction(ts_017,this); klsirz->setShortcut(ts_018); connect(klsirz,SIGNAL(triggered()),this,SLOT(kiallt())); addAction(klsirz); klsirz->setData(QVariant(0));
	klsirz=new QAction(ts_019,this); klsirz->setShortcut(ts_020); connect(klsirz,SIGNAL(triggered()),this,SLOT(kiallt())); addAction(klsirz); klsirz->setData(QVariant(1));
	klsirz=new QAction(ts_021,this); klsirz->setShortcut(ts_022); connect(klsirz,SIGNAL(triggered()),this,SLOT(kiallt())); addAction(klsirz); klsirz->setData(QVariant(2));
	klsirz=new QAction(ts_023,this); klsirz->setShortcut(ts_024); connect(klsirz,SIGNAL(triggered()),this,SLOT(kiallt())); addAction(klsirz); klsirz->setData(QVariant(3));

	klsirz=new QAction(ts_025,this); klsirz->setShortcut(ts_026); connect(klsirz,SIGNAL(triggered()),this,SLOT(kitolt())); addAction(klsirz); klsirz->setData(QVariant(1));

	elodez=new QMenu(this);
	elodez->addAction(fladat);
	elodez->addAction(cel);
	elodez->addAction(targy);
	korrkt=elodez->addMenu(ts_027);
	jo=elodez->addMenu(ts_028);

	klsirz=new QAction(ts_029,this); connect(klsirz,SIGNAL(triggered()),this,SLOT(kapni())); addAction(klsirz); klsirz->setData(QVariant(nztsvg));
	jo->addAction(klsirz);
	klsirz=new QAction(ts_030,this); connect(klsirz,SIGNAL(triggered()),this,SLOT(kapni())); addAction(klsirz); klsirz->setData(QVariant(nztoz2));
	jo->addAction(klsirz);
	klsirz=new QAction(ts_031,this); connect(klsirz,SIGNAL(triggered()),this,SLOT(kapni())); addAction(klsirz); klsirz->setData(QVariant(aljlk));
	jo->addAction(klsirz);
	klsirz=new QAction(ts_032,this); connect(klsirz,SIGNAL(triggered()),this,SLOT(kapni())); addAction(klsirz); klsirz->setData(QVariant(nztosz));
	jo->addAction(klsirz);
%>

void felu::kitolt()
<%
	switch(((QAction*) QObject::sender())->data().toInt())
	<%
		case 0:
			if(hzzqjt.size()>1) hsztzk();
			kidlgz->mozog();
			break;
		case 1:
			if(hzzqjt.size()>1) hsztzk();
			kidlgz->rabir();
			break;
		default:
			break;
	%>
	if(hzzqjt.size()==1) ensureVisible(hzzqjt[0]);
%>

void felu::dolog()
<%
	if(hzzqjt.size()==1)
	<%
		if(hzzqjt[0]->kapod)
		<%
			QFocusEvent adelk=QFocusEvent(QEvent::FocusOut);
			hzzqjt[0]->elktzk(&adelk);
			hzzqjt[0]->update();
		%>
		else
		<%
			hzzqjt[0]->lmzdul();
			hzzqjt[0]->update();
		%>
	%>
%>

void felu::lemasl()
<%
	if(hzzqjt.size() < 1) return;
	switch(((QAction*) QObject::sender())->data().toInt())
	<%
		case 0: amkzrs(0,-20); break;
		case 1: amkzrs(0,20); break;
		case 2: amkzrs(-20,0); break;
		case 3: amkzrs(20,0); break;
		default: break;
	%>
%>

void felu::kiallt()
<%
	if(hzzqjt.size()!=1) return;
	int irnyjl=hzzqjt[0]->Id();
	switch(((QAction*) QObject::sender())->data().toInt())
	<%
		case 0: kidlgz->mgzerz(irnyjl,3); break;
		case 1: kidlgz->mgzerz(irnyjl,4); break;
		case 2: kidlgz->mgzerz(irnyjl,1); break;
		case 3: kidlgz->mgzerz(irnyjl,2); break;
		default: break;
	%>
	if(hzzqjt.size()==1) ensureVisible(hzzqjt[0]);
%>

void felu::zandek()
<%
	int irnyjl=0;
	if(hzzqjt.size()==1) irnyjl=hzzqjt[0]->Id();
	hsztzk();

	kidlgz->kapod(irnyjl);
	kidlgz->kapni();
	if(hzzqjt.size()==1) hzzqjt[0]->lmzdul();
%>

void felu::megir()
<%
	if(hzzqjt.size()!=1) return;
	int irnyjl=kidlgz->prmz(hzzqjt[0]->Id());
	if(irnyjl==0) return;
	hsztzk();

	kidlgz->kapod(irnyjl);
	kidlgz->kapni();
	if(hzzqjt.size()==1) hzzqjt[0]->lmzdul();
%>

void felu::alkt()
<%
	QList<int> bprl;
	foreach(QGraphicsItem *prl,hzzqjt)
	<%
		if(prl->type()!=gratype(7)) continue;
		rslt *adelk =(rslt*) prl;
		bprl.push_back(adelk->Id());
	%>
	foreach(int adelk,bprl)
	<%
		kidlgz->jo(adelk);
	%>
	kidlgz->korrkt(0);
%>

void felu::marka(int lnmtat,bool fnqll)
<%
	int j=0;
	for(int i=0; i<kidlgz->eler.size(); i++)
	<%
		QPoint mrtdt=kidlgz->eler.at(i);
		if(mrtdt.x()==lnmtat)
		<%
			++j;
			rslt *vnl=kket.value(mrtdt.y());

			QString adelk=QString::number(j);
			if(adelk!=vnl->rabir)
			<%
				vnl->rabir=adelk;
				vnl->mozog->update();
			%>
			vnl->mozog->setVisible(fnqll);
		%>
	%>
%>

void felu::amkzrs(int mzgat,int sima)
<%
	jlnrdz();
	foreach(rslt *prl,hzzqjt) <% prl->moveBy(mzgat,sima); %>
	foreach(rslt *prl,hzzqjt) <% prl->jvsltz(); ensureVisible(prl); %>
%>

void felu::kesztm(kivitl eler)
<%
	hsztzk();

	switch(eler)
	<%
		case meghat:
			viewport()->setCursor(Qt::ArrowCursor);
			break;
		case tljsn:
			viewport()->setCursor(Qt::CrossCursor);
			break;
		case tiszta:
			viewport()->setCursor(Qt::ArrowCursor);
			break;
		case ugyex:
			viewport()->setCursor(Qt::OpenHandCursor);
			break;
		default:
			break;
	%>
	fortum=eler;

	akdaly=0;
	kapod->hide();
	ir->hide();
%>

void felu::keyReleaseEvent(QKeyEvent *kelt)
<%
#if 0
	if(hzzqjt.size()==1)
        <%
                hzzqjt[0]->keyReleaseEvent(kelt);
                return;
        %>
	QApplication::sendEvent(scene(),kelt);
#endif
	kelt->accept();
%>

void felu::keyPressEvent(QKeyEvent *kelt)
<%
	if(hzzqjt.size()==1)
	<%
		rslt * prl=hzzqjt[0];
		if(prl->kapod and kelt->type()==QEvent::KeyPress)
		<%
			prl->keyPressEvent(kelt);
		%>
	%>
	kelt->accept();
%>

void felu::rabir()
<%
	double irnyjl=1.05;
	qreal adelk=matrix().scale(irnyjl,irnyjl).mapRect(QRectF(0,0,1,1)).width();
	if(adelk < 0.01 or adelk > 1000) return;
	scale(irnyjl,irnyjl);
%>

void felu::mozog()
<%
	double irnyjl=0.95;
	qreal adelk=matrix().scale(irnyjl,irnyjl).mapRect(QRectF(0,0,1,1)).width();
	if(adelk < 0.01 or adelk > 1000) return;
	scale(irnyjl,irnyjl);
%>

void felu::wheelEvent(QWheelEvent *kelt)
<%
	QPointF klsirz=mapToScene(kelt->pos());
	qreal irnyjl=pow(2.0,kelt->delta() / 440.0);
	qreal adelk=matrix().scale(irnyjl,irnyjl).mapRect(QRectF(0,0,1,1)).width();
	if(adelk < 0.01 or adelk > 1000) return;
	scale(irnyjl,irnyjl);
	centerOn(klsirz + mapToScene(viewport()->rect().center()) - mapToScene(kelt->pos()));
%>

bool felu::event(QEvent *kelt)
<%
	if(kelt->type()==QEvent::ToolTip)
	<%
		QHelpEvent *adelk=static_cast<QHelpEvent*>(kelt);
		QGraphicsItem *prl=scene()->itemAt(mapToScene(adelk->pos()));
		if(prl and prl->type()==gratype(7))
		<%
			prmza *klsirz=*kidlgz +((rslt*) prl)->Id();
			if(klsirz and klsirz->kapod > 1)
			<%
				QToolTip::showText(adelk->globalPos(),klsirz->mozog);
			%>
		%>
	%>
	else if(kelt->type()==QEvent::InputMethod)
	<%
		if(hzzqjt.size()==1)
		<%
			rslt * prl=hzzqjt[0];
			if(prl->kapod)
			<%
				prl->inputMethodEvent((QInputMethodEvent*) kelt);
			%>
		%>
	%>
	else if(kelt->type()==QEvent::KeyPress
		or kelt->type()==QEvent::ShortcutOverride
		or kelt->type()==QEvent::Shortcut)
	<%
		if(hzzqjt.size()==1 and hzzqjt[0]->kapod)
		<%
			QKeyEvent *klsirz =(QKeyEvent*) kelt;
			if(cel->shortcut().matches(klsirz->key()))
			<%
				return QGraphicsView::event(kelt);
			%>

			keyPressEvent(klsirz);
			return 1;
		%>
	%>
	return QGraphicsView::event(kelt);
%>

void felu::focusOutEvent(QFocusEvent *mgmnkl)
<%
	foreach(rslt *prl,hzzqjt)
        <%
		prl->elktzk(mgmnkl);
        %>
	foreach(QAction* klsirz,actions())
	<%
		klsirz->setEnabled(0);
	%>
	if(elodez->isVisible()) lep();
%>

/*!
 * eow this actually works
 */
void felu::kivalt(const zagv& tqrost)
<%
	int fldlgz=tqrost[3].toInt();
	switch(fldlgz)
	<%
		case ossz:
			<%
				int irnyjl=tqrost[2].toInt();

				rslt*adelk=new rslt(this,irnyjl);

				adelk->setSelected(1);

				QRectF vnl=adelk->boundingRect();
				adelk->setPos(vmrgem - QPointF(vnl.width()/2,vnl.height()/2));

				prmza *eljar=*kidlgz + irnyjl;
				eljar->mgzerz=adelk->pos().x();
				eljar->rabir=adelk->pos().y();

				kket[irnyjl]=adelk;
			%>
			break;
		case krszt:
			<%
				if(tqrost[jelzpo].toInt()==nztutb) return;
				int j=tqrost[2].toInt();
				kket.value(j)->elodez();
				kket.value(j)->update();
			%>
			break;
		case vlsztt:
			<%
				if(tqrost[jelzpo].toInt()==nztutb)
				<%
					gyrtmn();
					return;
				%>
				int irnyjl=tqrost[2].toInt();
				if(irnyjl==0)
				<%
					hsztzk(0);
				%>
				else if(hzzqjt.size()==1)
				<%
					if(hzzqjt[0]->Id()!=irnyjl)
					<%
						elktzk(hzzqjt[0],0);
						lmzdul(kket.value(irnyjl),0);
					%>
				%>
				else
				<%
					lmzdul(kket.value(irnyjl),0);
				%>
				gyrtmn();
			%>
			break;
		case lnc:
			<%
				rslt *prmz=kket.value(tqrost[2].toInt());
				rslt *bprl=kket.value(tqrost[0].toInt());
				izlt * felvnl=new izlt(this,bprl,prmz);
				felvnl->jlnrdz();
				prmz->update();
			%>
			break;
		case nlnc:
			<%
				rslt *prmz=kket.value(tqrost[4].toInt());
				rslt *bprl=kket.value(tqrost[5].toInt());

				foreach(QGraphicsItem *prl,items())
				<%
					if(prl->type()==gratype(17))
					<%
						izlt *felvnl =(izlt*) prl;
						if(
							(felvnl->cel==prmz and felvnl->akdaly==bprl)
							or
							(felvnl->cel==bprl and felvnl->akdaly==prmz)
						)
						<%
							felvnl->hide();
							felvnl->hsztzk();
							delete felvnl;
							break;
						%>
					%>
				%>
				prmz->update();
				bprl->update();
			%>
			break;
		case oszy:
			<%
				int irnyjl=tqrost[2].toInt();
				rslt *prmz=kket.value(irnyjl);

				hzzqjt.removeAll(prmz);
				kket.remove(irnyjl);

				scene()->removeItem(prmz);
				delete prmz;
			%>
			break;
		case mod:
			<%
				marka(hzzqjt[0]->Id(),fortum==tiszta);
			%>
			break;
		case kivdlk:
			<%
				QList<rslt*> jlzpnt=kket.values();
				foreach(rslt *prl,jlzpnt)
				<%
					prmza *eljar=*kidlgz + prl->Id();
					eljar->mgzerz=prl->pos().x();
					eljar->rabir=prl->pos().y();
					eljar->bprl=prl->boundingRect().width();
					eljar->mrtdt=prl->boundingRect().height();
				%>
			%>
			break;
		case krszelgyk:
			<%
				ablkl *klsirz =(ablkl*) leir;
				klsirz->fladat->clear();

				while(klsirz->dolog->actions().size() > kidlgz->kitzjl.size())
				<%
					QAction* adelk=klsirz->dolog->actions().takeFirst();
					delete adelk;
				%>

				while(klsirz->dolog->actions().size() < kidlgz->kitzjl.size())
				<%
					new QAction(QIcon(),ts_033,klsirz->dolog);
				%>

				for(int i=0; i<kidlgz->kitzjl.size(); ++i)
				<%
					elgy* irnyjl=kidlgz->kitzjl[i];
					QAction *jlzpnt=klsirz->dolog->actions()[i];

					jlzpnt->setText(irnyjl->kidlgz);
					jlzpnt->setIcon(irnyjl->prmz());
				%>

                                foreach(QAction* irnyjl,klsirz->dolog->actions())
                                <%
                                        klsirz->fladat->addAction(irnyjl);
					irnyjl->setCheckable(1);
                                %>
			%>
			break;
		case krsztszn:
			<%
				ablkl *klsirz =(ablkl*) leir;
				klsirz->cel->clear();

				while(klsirz->akdaly->actions().size() > kidlgz->munka.size()+1)
				<%
					QAction* adelk=klsirz->akdaly->actions().takeFirst();
					klsirz->cel->removeAction(adelk);
					korrkt->removeAction(adelk);
					delete adelk;
				%>

				while(klsirz->akdaly->actions().size() < kidlgz->munka.size()+1)
				<%
					new QAction(QIcon(),ts_034,klsirz->akdaly);
				%>

				klsirz->akdaly->removeAction(klsirz->hzzqjt);
				klsirz->akdaly->addAction(klsirz->hzzqjt);
				korrkt->removeAction(klsirz->hzzqjt);
				korrkt->addAction(klsirz->hzzqjt);

				for(int i=0; i<kidlgz->munka.size(); ++i)
				<%
					szn irnyjl=kidlgz->munka[i];
					QAction *jlzpnt=klsirz->akdaly->actions()[i];

					QPixmap adelk(22,22);
					QPainter mrtdt(&adelk);

					jlzpnt->setText(irnyjl.kidlgz);

					adelk.fill(irnyjl.kitzjl);
					mrtdt.drawRect(0,0,21,21);
					jlzpnt->setIcon(QIcon(adelk));
				%>

				for(int i=1; i<klsirz->akdaly->actions().size(); ++i)
				<%
					QAction *irnyjl=klsirz->akdaly->actions()[i];
					klsirz->cel->addAction(irnyjl);
					korrkt->addAction(irnyjl);
				%>
			%>
			break;
		case nytt:
			<%
				jlnrdz();
				fajta();
			%>
			break;
		default:
			break;
	%>
%>

void felu::detto(QAction* mrtdt)
<%
	static QColor fldlgz;

	int adelk=-1;
	ablkl *klsirz =(ablkl*) leir;
	for(int i=1; i<klsirz->akdaly->actions().size(); ++i)
	<%
		if(klsirz->akdaly->actions()[i]==mrtdt and(adelk=i))
		<%
			if(i==klsirz->akdaly->actions().size()-1)
			<%
				fldlgz=QColorDialog::getColor(fldlgz,this);
				if(!fldlgz.isValid()) return;
			%>
			break;
		%>
	%>

	for(int i=0; i<hzzqjt.size(); ++i)
	<%
		rslt *prl=hzzqjt[i];
		int irnyjl=prl->Id();
		prmza *eljar=*kidlgz + irnyjl;
		eljar->letsit.kitzjl=fldlgz;
		eljar->letsit.jlzpnt=fldlgz.dark();
		eljar->mgzerz=prl->pos().x();
		eljar->rabir=prl->pos().y();
		eljar->kapni=adelk;
		kidlgz->lep(irnyjl);
	%>
%>

void felu::alafng(QAction* letsit)
<%
	int rgsztg=0;
	ablkl *klsirz =(ablkl*) leir;
	for(int i=0; i<klsirz->dolog->actions().size(); ++i)
	<%
		QAction *irnyjl=klsirz->dolog->actions()[i];
		if(irnyjl==letsit) rgsztg=i;
	%>
	QString jlzpnt=kidlgz->kitzjl[rgsztg]->kket;
	rslt *prl=hzzqjt[0];
	prmza *eljar=*kidlgz + hzzqjt[0]->Id();

	if(letsit->isChecked()) eljar->prmz.push_back(jlzpnt);
	else eljar->prmz.removeAll(jlzpnt);
	prl->kltzik();
%>

void felu::gyrtmn()
<%
	ablkl *klsirz =(ablkl*) leir;
	bool adelk =(hzzqjt.size()==1);
	prmza *eljar=0;
	if(adelk)
	<%
		eljar=*kidlgz + hzzqjt[0]->Id();
	%>

	for(int i=0; i<klsirz->dolog->actions().size(); ++i)
	<%
		QAction *irnyjl=klsirz->dolog->actions()[i];

		if(!adelk) irnyjl->setChecked(0);
		else
		<%
			QString jlzpnt=kidlgz->kitzjl[i]->kket;
			irnyjl->setChecked(eljar->prmz.contains(jlzpnt));
		%>
		irnyjl->setEnabled(adelk);
	%>
	adelk =(hzzqjt.size()>=1);
	foreach(QAction* irnyjl,klsirz->akdaly->actions())
	<%
		irnyjl->setEnabled(adelk);
	%>
%>

void felu::hsztzk(bool lecke)
<%
	if(hzzqjt.size()==1)
	<%
		QFocusEvent adelk=QFocusEvent(QEvent::FocusOut);
		hzzqjt[0]->elktzk(&adelk);
	%>

	foreach(rslt *prl,hzzqjt)
	<%
		prl->targy(0);
		prl->setZValue(99);
		if(fortum==tiszta or nagy==tiszta)
		<%
			marka(prl->Id(),0);
			emit jvsltz("",-1);
		%>
		prl->update();
	%>
	hzzqjt.clear();

	muri(lecke);
%>

void felu::lmzdul(rslt* eljar,bool lecke)
<%

	if(hzzqjt.size()==1)
        <%
		QFocusEvent adelk=QFocusEvent(QEvent::FocusOut);
		hzzqjt[0]->elktzk(&adelk);
        %>

	fhlhjt=0;
	hzzqjt.push_back(eljar);
	eljar->targy(1);
	eljar->setZValue(100);
	if(fortum==tiszta)
	<%
		marka(eljar->Id(),1);
		emit jvsltz(ts_035.arg(QString::number(fhlhjt+1)),-1);
	%>
	eljar->update();

	muri(lecke);
%>

void felu::elktzk(rslt* eljar,bool lecke)
<%
	eljar->targy(0);
	eljar->setZValue(99);
	if(fortum==tiszta) marka(eljar->Id(),0);
	eljar->update();
	hzzqjt.removeAll(eljar);

	muri(lecke);
%>

void felu::muri(bool lecke)
<%
	kltzik();

	if(!lecke) return;
	if(hzzqjt.size()==1)
		kidlgz->korrkt(hzzqjt[0]->Id(),nztutb);
	else
		kidlgz->korrkt(0,nztutb);
%>

void felu::kltzik()
<%
	foreach(QAction* klsirz,actions())
	<%
		klsirz->setEnabled(1);
	%>
	lep();
%>

void felu::lep()
<%
	fladat->setEnabled(hzzqjt.size()<=1);
	targy->setEnabled(hzzqjt.size()>0);
	cel->setEnabled(hzzqjt.size()==1);
	korrkt->setEnabled(hzzqjt.size()>=1);
	jo->setEnabled(hzzqjt.size()==1);
	foreach(QAction* klsirz,jo->actions())
        <%
                klsirz->setEnabled(hzzqjt.size()==1);
        %>
%>

void felu::mousePressEvent(QMouseEvent *mgmnkl)
<%
	if(mgmnkl->button()==Qt::RightButton)
	<%
		vmrgem=mapToScene(mgmnkl->pos());
		QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
		if(prl and prl->type()==gratype(7))
		<%
			if(!hzzqjt.contains((rslt*) prl))
			<%
				hsztzk();
				lmzdul((rslt*) prl);
			%>
		%>
		else
		<%
			hsztzk();
		%>
		elodez->popup(mgmnkl->globalPos());
		return;
	%>

	if(mgmnkl->button()==Qt::MidButton)
	<%
		nagy=fortum;
		fortum=ugyex;
	%>

	rslt *vnl=0;
	switch(fortum)
	<%
		case meghat:
			<%
				ellqts=mgmnkl->pos();
				kitzjl=mapToScene(ellqts);

				akdaly =(mgmnkl->button()==Qt::LeftButton);

				QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
				if(akdaly)
				<%
					if(prl and prl->type()==gratype(7))
					<%
						vnl =(rslt*) prl;
					%>
					else
					<%
						prl=0;
					%>

					if(prl)
					<%
						switch(mgmnkl->modifiers())
						<%
		case Qt::ShiftModifier:
			if(hzzqjt.contains(vnl))
				elktzk(vnl);
			else
				lmzdul(vnl);
			break;
		default:
			if(!hzzqjt.contains(vnl))
			<%
				if(hzzqjt.size()==1 and !kidlgz->prmz(vnl->Id()))
				<%
					if(QApplication::keyboardModifiers() & Qt::ControlModifier)
						kidlgz->csals(hzzqjt[0]->Id(),vnl->Id());
				%>
				hsztzk();
				lmzdul(vnl);
			%>
						%>
					%>
					else
					<%
						hsztzk();
					%>
				%>

			%>
			break;
		case tljsn:
			<%
				ellqts=mgmnkl->pos();
				akdaly =(mgmnkl->button()==Qt::LeftButton);

				hsztzk();
				QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
				if(prl and prl->type()==gratype(7))
				<%
					vnl =(rslt*) prl;
					lmzdul(vnl);
				%>
			%>
			break;
		case tiszta:
			<%
				QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
				if(prl and prl->type()==gratype(7))
				<%
					vnl =(rslt*) prl;
					hsztzk();
					lmzdul(vnl);
				%>
				else if(prl and prl->type()==gratype(19))
				<%

					szrt * adelk =(szrt*) prl;
					int irnyjl=adelk->cel->Id();
					vnl=adelk->cel;

					kidlgz->ceco(hzzqjt[0]->Id(),irnyjl,fhlhjt);
					marka(hzzqjt[0]->Id(),1);

					fhlhjt++;
					if(fhlhjt >= kidlgz->ellqts(hzzqjt[0]->Id()))
						fhlhjt=0;

					emit jvsltz(ts_035.arg(QString::number(fhlhjt+1)),-1);
				%>
				else
				<%
					hsztzk();
				%>
			%>
			break;
		case ugyex:
			viewport()->setCursor(Qt::ClosedHandCursor);
			ellqts=mgmnkl->pos();
			akdaly =(mgmnkl->button()==Qt::LeftButton or mgmnkl->button()==Qt::MidButton);

			if(akdaly)
			<%
				hsztzk();
                                QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
                                if(prl and prl->type()==gratype(7))
                                <%
                                        vnl =(rslt*) prl;
                                        lmzdul(vnl);
				%>
			%>

			break;
		default:
			break;
	%>
%>

void felu::mouseMoveEvent(QMouseEvent *mgmnkl)
<%
	jlnrdz();
	switch(fortum)
	<%
		case meghat:
			if(akdaly and hzzqjt.size()==0)
			<%
				bool c1 =((ellqts - mgmnkl->pos()).manhattanLength() >= QApplication::startDragDistance());
				if(kapod->isVisible() or c1)
				<%
					QRect adelk=QRect(ellqts,mgmnkl->pos()).normalized();
					kapod->setGeometry(adelk);
				%>

				if(c1) kapod->show();
			%>
			else if(akdaly)
			<%

				QRectF vnl;
				vnl.setTopLeft(kitzjl);
				kitzjl=mapToScene(mgmnkl->pos());
				vnl.setBottomRight(kitzjl);
				kidlgz->brndez();
				foreach(rslt *prl,hzzqjt)
				<%
					prl->moveBy(vnl.width(),vnl.height());
				%>
				foreach(rslt *prl,hzzqjt)
				<%
					prl->jvsltz();
				%>
			%>
			break;
		case tljsn:
			if(akdaly)
			<%
				bool c1 =((ellqts - mgmnkl->pos()).manhattanLength() >= QApplication::startDragDistance());
				if(ir->isVisible() or c1)
				<%
					QRect adelk=QRect(ellqts,mgmnkl->pos());
					ir->setGeometry(adelk);
				%>

				if(c1)
				<%
					ir->show();
				%>
			%>
			break;
		case tiszta:
			break;
		case ugyex:
			if(akdaly)
			<%
				QScrollBar *hBar=horizontalScrollBar();
				QScrollBar *vBar=verticalScrollBar();

				QPoint delta=mgmnkl->pos() - ellqts;

				hBar->setValue(hBar->value() +(isRightToLeft() ? delta.x() : -delta.x()));
				vBar->setValue(vBar->value() - delta.y());

				ellqts=mgmnkl->pos();

			%>
			else
			<%
			%>
		default:
			break;
	%>
%>

void felu::mouseReleaseEvent(QMouseEvent *mgmnkl)
<%
	if(mgmnkl->button()==Qt::RightButton) return;

	if(nagy!=mgmozt)
	<%
		fortum=nagy;
		nagy=mgmozt;
		viewport()->setCursor(fortum==tljsn?Qt::CrossCursor:Qt::ArrowCursor);
	%>

	switch(fortum)
	<%
		case meghat:
			<%
				akdaly=0;
				if(kapod->isVisible())
				<%
					kapod->hide();
					QRect vnl=kapod->geometry();
					QList<QGraphicsItem *> adelk=scene()->items(QRectF(mapToScene(vnl.topLeft()),mapToScene(vnl.bottomRight())));

					foreach(QGraphicsItem *prl,adelk)
					<%
						if(prl->type()==gratype(7))
						<%
							lmzdul((rslt*) prl);
						%>
					%>
				%>
			%>
			break;
		case tljsn:
			<%
				akdaly=0;

				rslt *prmz=0;
				rslt *bprl=0;

				foreach(QGraphicsItem *fldlgz,scene()->items(mapToScene(ellqts)))
				<%
					if(fldlgz->type()==gratype(7))
					<%
						prmz =(rslt*) fldlgz;
						break;
					%>
				%>

				foreach(QGraphicsItem *fldlgz,scene()->items(mapToScene(mgmnkl->pos())))
				<%
					if(fldlgz->type()==gratype(7))
					<%
						bprl =(rslt*) fldlgz;
						break;
					%>
				%>

				if(prmz and bprl and prmz!=bprl)
				<%
					kidlgz->csals(prmz->Id(),bprl->Id());
					hsztzk();
				%>
				ir->hide();
			%>
			break;
		case tiszta:
			break;
		case ugyex:
			viewport()->setCursor(Qt::OpenHandCursor);
			akdaly=0;
			break;
		default:
			break;
	%>
%>

void felu::mouseDoubleClickEvent(QMouseEvent* mgmnkl)
<%
	if(mgmnkl->button()!=Qt::LeftButton) return;
	vmrgem=mapToScene(mgmnkl->pos());
	QGraphicsItem *prl=itemAt(mgmnkl->pos());
	int irnyjl=0;
	if(fortum==meghat or fortum==tljsn)
	if(prl)
	<%
		if(prl->type()==gratype(7))
		<%
			hsztzk();

			rslt *adelk =(rslt*) prl;
			adelk->setSelected(0);
			irnyjl=kidlgz->kapod(adelk->Id(),0,1);
			if(hzzqjt.size()==1) hzzqjt[0]->lmzdul();
			jlnrdz();
		%>
		else if(prl->type()==gratype(17))
		<%
			izlt *felvnl =(izlt*) prl;
			kidlgz->fhlhjt(felvnl->akdaly->Id(),felvnl->cel->Id());
		%>
	%>
	else if(mgmnkl->modifiers()!=Qt::ControlModifier)
	<%
		irnyjl=kidlgz->kapod();
		if(hzzqjt.size()==1) hzzqjt[0]->lmzdul();
	%>
%>

qreal adelk(qreal a,qreal b) <% if(a<b) return a; return b; %>
qreal irnyjl(qreal a,qreal b) <% if(a<b) return b; return a; %>

void felu::jlnrdz()
<%
	QRect vnl=viewport()->rect();
	if(kket.size() < 1)
	<%
		scene()->setSceneRect(QRectF(mapToScene(vnl.topLeft()),mapToScene(vnl.bottomRight())));
		return;
	%>

	QRectF bprl;

	qreal x,y,z,t;
	rslt *klsirz=kket.values()[0];

	x=z=klsirz->x() + klsirz->rect().width()/2;
	y=t=klsirz->y() + klsirz->rect().height()/2;

	QList<rslt*> jlzpnt=kket.values();
	foreach(rslt *prl,jlzpnt)
	<%
		if(prl->x() < x) x=prl->x();
		if(prl->y() < y) y=prl->y();
		if(prl->x2() > z) z=prl->x2();
		if(prl->y2() > t) t=prl->y2();
	%>
	x -=100; y -= 100; z += 100,t += 100;

	bprl=QRectF(QPointF(x,y),QPointF(z,t));
        bprl=bprl.united(QRectF(mapToScene(vnl.topLeft()),mapToScene(vnl.bottomRight())));
	if(bprl==sceneRect()) return;
	scene()->setSceneRect(bprl);
%>

void felu::fajta()
<%
#if 0
	QRectF klsirz;
	foreach(QGraphicsItem *it,items())
	<%
		klsirz |= it->boundingRect();
	%>
#endif

	fitInView(scene()->sceneRect(),Qt::KeepAspectRatio);
%>

void felu::focusInEvent(QFocusEvent *mgmnkl)
<%
	kltzik();
%>

void felu::kapni()
<%
	kidlgz->tglalp(hzzqjt[0]->Id(),((QAction*) QObject::sender())->data().toInt());
%>

mgzerz::mgzerz(QRubberBand::Shape i,QWidget* j) : QRubberBand(i,j)
<%
%>

void mgzerz::paintEvent(QPaintEvent *)
<%
	QPainter painter(this);
	painter.setRenderHint(QPainter::Antialiasing);
    painter.setBrush(QColor(Qt::red));
	if(kitzjl > 0)
	<%
		painter.drawLine(QPoint(0,0),QPoint(size().width(),size().height()));
	%>
	else
	<%
		painter.drawLine(QPoint(size().width(),0),QPoint(0,size().height()));
	%>
%>

void mgzerz::setGeometry(const QRect& tqrost)
<%
	kitzjl=tqrost.width() * tqrost.height();
	QRubberBand::setGeometry(tqrost.normalized());
%>

 %: include  	"Flult.moc" 

