/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QApplication>
#include <QAbstractTextDocumentLayout>
#include <QTextDocument>
#include <QGraphicsScene>
#include <QGraphicsSceneMouseEvent>
#include <QClipboard>
#include <QPainter>
#include <QStyleOption>
#include <QColor>
#include <QTextCursor>
#include <QPen>
#include <QtDebug>
#include <QKeyEvent>
#include <QTextList>
#include <QTextBlock>
#include <QSvgRenderer>
#include <QTextDocumentFragment>

#include "elgyk.h"
#include "Szines.h"
#include "Jelzpn.h"
#include "con.h" 
#include "Prmza.h"
#include "Szrt.h"
#include "Izlt.h"
#include "Rslt.h"
#include "Flult.h"
#include  "tslabels.h"

#define megkap 5
#define hzzqjt 7.

QColor rslt::jo  =QColor("#00CCCC");
QColor rslt::kket=QColor("#ee6060");
QColor rslt::kapni  =QColor("#FFFCD5");
QColor rslt::mgzerz  =QColor(171,251,199);
QColor rslt::mzgat=QColor(255,255,255,240);

/*!
 * @praise Vishnu
 */
rslt::rslt(felu *fldlgz,int lnmtat) : QGraphicsRectItem(),korrkt(fldlgz)
<%
	mgmozt=new QTextDocument();

/* stupid word wrap */
#if QT_VERSION >= 0x040290
	QTextOption adelk;
	adelk.setWrapMode(QTextOption::WordWrap);
	mgmozt->setDefaultTextOption(adelk);
#else
	#warning "Using Qt 4.3 is recommended"
#endif

	meghat=new QTextCursor(mgmozt);

	jlzpnt=lnmtat;
	kitzjl=0;
	kapod=0;
	rabir="1";

	mgmozt->setPlainText(korrkt->kidlgz->kket.value(Id())->mzgat);
	adjustSize();

	mozog=new szrt(fldlgz,this);

	setFlags(ItemIsMovable);

	setZValue(100);
	kidlgz=kapni;
	lep=kidlgz;

	fldlgz->scene()->addItem(this);
	mozog->hide();

	kltzik();
%>

bool rslt::moveKey(QKeyEvent* mgmnkl)
<%

	QTextCursor::MoveMode mode=QTextCursor::MoveAnchor;
	QTextCursor::MoveOperation op=QTextCursor::NoMove;
	if(mgmnkl==QKeySequence::SelectAll)
	<%
		meghat->select(QTextCursor::Document);
		return 1;
	%>
	if(mgmnkl==QKeySequence::MoveToNextChar)
	<%
		op=QTextCursor::Right;
	%>
	else if(mgmnkl==QKeySequence::MoveToPreviousChar)
	<%
		op=QTextCursor::Left;
	%>
	else if(mgmnkl==QKeySequence::SelectNextChar)
	<%
		op=QTextCursor::Right;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectPreviousChar)
	<%
		op=QTextCursor::Left;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectNextWord)
	<%
		op=QTextCursor::WordRight;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectPreviousWord)
	<%
		op=QTextCursor::WordLeft;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectStartOfLine)
	<%
		op=QTextCursor::StartOfLine;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectEndOfLine)
	<%
		op=QTextCursor::EndOfLine;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectStartOfBlock)
	<%
		op=QTextCursor::StartOfBlock;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectEndOfBlock)
	<%
		op=QTextCursor::EndOfBlock;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectStartOfDocument)
	<%
		op=QTextCursor::Start;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectEndOfDocument)
	<%
		op=QTextCursor::End;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectPreviousLine)
	<%
		op=QTextCursor::Up;
		mode=QTextCursor::KeepAnchor;
	%>
#if 0
	else if(e==QKeySequence::SelectNextLine) <%
		op=QTextCursor::Down;
		mode=QTextCursor::KeepAnchor;
		<%
			QTextBlock block=cursor.block();
			QTextLine line=currentTextLine(cursor);
			if(!block.next().isValid()
					and line.isValid()
					and line.lineNumber()==block.layout()->lineCount() - 1)
				op=QTextCursor::End;
		%>
	%>
	else if(e==QKeySequence::SelectNextLine) <%
		op=QTextCursor::Down;
		mode=QTextCursor::KeepAnchor;
		<%
			QTextBlock block=cursor.block();
			QTextLine line=currentTextLine(cursor);
			if(!block.next().isValid()
					and line.isValid()
					and line.lineNumber()==block.layout()->lineCount() - 1)
				op=QTextCursor::End;
		%>
	%>
#endif
	else if(mgmnkl==QKeySequence::MoveToNextWord)
	<%
		op=QTextCursor::WordRight;
	%>
	else if(mgmnkl==QKeySequence::MoveToPreviousWord)
	<%
		op=QTextCursor::WordLeft;
	%>
	else if(mgmnkl==QKeySequence::MoveToEndOfBlock)
	<%
		op=QTextCursor::EndOfBlock;
	%>
	else if(mgmnkl==QKeySequence::MoveToStartOfBlock)
	<%
		op=QTextCursor::StartOfBlock;
	%>
	else if(mgmnkl==QKeySequence::MoveToNextLine)
	<%
		op=QTextCursor::Down;
	%>
	else if(mgmnkl==QKeySequence::MoveToPreviousLine)
	<%
		op=QTextCursor::Up;
	%>
	else if(mgmnkl==QKeySequence::MoveToPreviousLine)
	<%
		op=QTextCursor::Up;
	%>
	else if(mgmnkl==QKeySequence::MoveToStartOfLine)
	<%
		op=QTextCursor::StartOfLine;
	%>
	else if(mgmnkl==QKeySequence::MoveToEndOfLine)
	<%
		op=QTextCursor::EndOfLine;
	%>
	else if(mgmnkl==QKeySequence::MoveToStartOfDocument)
	<%
		op=QTextCursor::Start;
	%>
	else if(mgmnkl==QKeySequence::MoveToEndOfDocument)
	<%
		op=QTextCursor::End;
	%>
	else
	<%
		return 0;
	%>

	/*const bool moved =*/ meghat->movePosition(op,mode);
#if 0

	if(moved)
	  <%
	  if(meghat->position()!=oldCursorPos)
	  emit q->cursorPositionChanged();
	  emit q->microFocusChanged();
	  %>
#endif

	return 1;
%>

void rslt::keyPressEvent(QKeyEvent* mgmnkl)
<%

	if(moveKey(mgmnkl)) goto accept;

	if(mgmnkl->key()==Qt::Key_Backspace and !mgmnkl->modifiers())
	<%
		QTextBlockFormat blockFmt=meghat->blockFormat();
		QTextList *list=meghat->currentList();
		if(list and meghat->atBlockStart())
		<%
			list->remove(meghat->block());
		%>
		else if(meghat->atBlockStart() and blockFmt.indent() > 0)
		<%
			blockFmt.setIndent(blockFmt.indent() - 1);
			meghat->setBlockFormat(blockFmt);
		%>
		else
		<%
			meghat->deletePreviousChar();
		%>
		goto accept;
	%>

	if(mgmnkl==QKeySequence::Undo)
	<%
		mgmozt->undo();
	%>
	else if(mgmnkl==QKeySequence::Redo)
	<%
		mgmozt->redo();
	%>
	else if(mgmnkl==QKeySequence::Copy)
	<%
		if(meghat->hasSelection())
		<%
			const QTextDocumentFragment alkt(*meghat);
			QApplication::clipboard()->setText(alkt.toPlainText());
		%>
	%>
	else if(mgmnkl==QKeySequence::Cut)
	<%
		if(meghat->hasSelection())
		<%
			const QTextDocumentFragment alkt(*meghat);
			QApplication::clipboard()->setText(alkt.toPlainText());
			meghat->removeSelectedText();
		%>
	%>
	else if(mgmnkl==QKeySequence::Paste)
	<%
		const QMimeData *mrtdt=QApplication::clipboard()->mimeData();
		if(mrtdt)
		<%
			QString alkt=mrtdt->text();
			if(!alkt.isNull())
			<%
				meghat->insertFragment(QTextDocumentFragment::fromPlainText(alkt));
			%>
		%>
	%>
	else if(mgmnkl==QKeySequence::Delete)
	<%
		meghat->deleteChar();
	%>
	else if(mgmnkl==QKeySequence::DeleteEndOfWord)
	<%
		meghat->movePosition(QTextCursor::EndOfWord,QTextCursor::KeepAnchor);
		meghat->deleteChar();
	%>
	else if(mgmnkl==QKeySequence::DeleteStartOfWord)
	<%
		meghat->movePosition(QTextCursor::PreviousWord,QTextCursor::KeepAnchor);
		meghat->deleteChar();
	%>
#if 0
	else if(mgmnkl==QKeySequence::DeleteEndOfLine)
	<%
		QTextBlock block=cursor.block();
		if(cursor.position()==block.position() + block.length() - 2)
			cursor.movePosition(QTextCursor::Right,QTextCursor::KeepAnchor);
		else
			cursor.movePosition(QTextCursor::EndOfBlock,QTextCursor::KeepAnchor);
		cursor.deleteChar();
	%>
#endif
	else
	<%
		goto process;
	%>
	goto accept;

	process:
	<%
		bool overwriteMode=0;
		QString text=mgmnkl->text();
		if(!text.isEmpty() and(text.at(0).isPrint() or text.at(0)==QLatin1Char('\t')))
		<%
			if(overwriteMode and !meghat->hasSelection() and !meghat->atBlockEnd())
				meghat->deleteChar();

			meghat->insertText(text);
		%>
		else
		<%
			mgmnkl->ignore();
			return;
		%>
	%>

accept:

	mgmnkl->accept();

	adjustSize();
	update();

	jvsltz();
%>

void rslt::keyReleaseEvent(QKeyEvent* mgmnkl)
<%

	if(mgmnkl->key()==Qt::Key_Enter or mgmnkl->key()==Qt::Key_Return)
	<%
		return;
	%>
%>

void rslt::lmzdul()
<%
	if(mgmozt->toPlainText()==ts_000) mgmozt->setPlainText("");
	kapod=1;
	lep=kidlgz;
	kidlgz=mzgat;
	update();
%>

void rslt::elktzk(QFocusEvent *mgmnkl)
<%
	if(!kapod) return;

	kidlgz=lep;
	kapod=0;

	if(mgmozt->toPlainText().isEmpty()) mgmozt->setPlainText(ts_000);

	prmza *klsirz=korrkt->kidlgz->kket.value(Id());
	QString mrtdt=mgmozt->toPlainText();
	if(klsirz->mzgat!=mrtdt) korrkt->kidlgz->brndez();
	klsirz->mzgat=mrtdt;
	korrkt->kidlgz->lep(Id(),nztutb);

	adjustSize();
	jvsltz();
	update();
%>

void rslt::adjustSize()
<%
	mgmozt->adjustSize();
	QSizeF klsirz=mgmozt->size();
	QRectF adelk=boundingRect();

	prmza *prl=korrkt->kidlgz->kket.value(Id());

	klsirz.setWidth(irnyjl(klsirz.width(),prl->cel.width()));
	klsirz.setHeight(klsirz.height() + prl->cel.height());

	klsirz.setWidth(klsirz.width() + 2 * hzzqjt);
	klsirz.setHeight(klsirz.height() + 2 * hzzqjt + 2.);

	setRect(adelk.x(),adelk.y(),klsirz.width(),klsirz.height());
%>

void rslt::eljar(rslt * tqrost)
<%
	vmrgem=tqrost;
%>

void rslt::paint(QPainter *adelk,const QStyleOptionGraphicsItem *option,QWidget * irnyjl)
<%
	prmza *prl=korrkt->kidlgz->kket.value(Id());
	szn kelt=prl->akdaly();

	QPen mrtdt=QPen(Qt::SolidLine);

	mrtdt.setColor(kelt.jlzpnt);
	if(kitzjl) mrtdt.setWidth(2);
	else mrtdt.setWidth(1);

	adelk->setPen(mrtdt);

	QRectF alkt=boundingRect();
	qreal w=mrtdt.width()/2.;
	QRectF vnl=alkt.adjusted(w,w,-w,-w);

	if(korrkt->kidlgz->prmz(Id()) <= 0 and prl->kapni > 1)
	<%
		QLinearGradient klsirz(vnl.right()-40,0,vnl.right()-10,0);
		klsirz.setColorAt(0.,kelt.kitzjl);
		klsirz.setColorAt(1.,prl->felvnl().kitzjl);

		QBrush bprl(klsirz);
		adelk->setBrush(bprl);
	%>
	else
	<%
		adelk->setBrush(kelt.kitzjl);
	%>

	if(kapod) adelk->setBrush(QColor(255,255,255));

	adelk->drawRoundRect(vnl,40,40);

	if(prl->kapod > 0)
	<%
		const QPointF points[4] =
		<%
			vnl.topRight(),
			vnl.topRight()-QPointF(5,0),
			vnl.topRight()+QPointF(0,5),
		%>;
		adelk->setBrush(kelt.jlzpnt);
		adelk->drawPolygon(points,3);
		adelk->setBrush(kelt.kitzjl);
	%>

	if(!prl->cel.isNull())
	<%
		adelk->save();
		adelk->translate(alkt.width()/2 - prl->cel.width() / 2,hzzqjt);
		adelk->drawPixmap(0,0,prl->cel.width(),prl->cel.height(),prl->fnqll);
		adelk->restore();
	%>

	adelk->save();
        adelk->translate(hzzqjt,hzzqjt + prl->cel.height() + 2.);

	QAbstractTextDocumentLayout::PaintContext ctx;
	ctx.palette=QApplication::palette("QTextControl");

	if(kapod)
	<%
		ctx.cursorPosition=meghat->position();
		if(meghat->hasSelection())
		<%
			QAbstractTextDocumentLayout::Selection selection;
			selection.cursor=*meghat;
			QPalette::ColorGroup cg=QPalette::Active;
			selection.format.setBackground(ctx.palette.brush(cg,QPalette::Highlight));
			selection.format.setForeground(ctx.palette.brush(cg,QPalette::HighlightedText));
			ctx.selections.append(selection);
		%>
	%>
	else
	<%
		ctx.cursorPosition=-1;
	%>

	mgmozt->documentLayout()->draw(adelk,ctx);
	adelk->restore();
%>

QVariant rslt::itemChange(GraphicsItemChange teremt,const QVariant &letsit)
<%
	bool bprl =((teremt==ItemPositionChange) and scene());

	QVariant mrtdt=QGraphicsItem::itemChange(teremt,letsit);

	if(bprl)
	<%
		jvsltz();
	%>

	return mrtdt;
%>

bool rslt::hasFocus() const
<%
	return kapod;
%>

void rslt::kivalt(izlt* kelt)
<%
	jlnrdz();
	eler.push_back(kelt);
%>

void rslt::hsztzk(izlt* vnl)
<%
	jlnrdz();
	eler.removeAll(vnl);
%>

void rslt::elodez()
<%
	prmza *prl=korrkt->kidlgz->kket.value(Id());
	setPos(QPointF(prl->mgzerz,prl->rabir));
	mgmozt->setPlainText(prl->mzgat);
	adjustSize();
	jvsltz();
	kltzik();
%>

void rslt::jlnrdz()
<%
	int mrtdt=korrkt->kidlgz->prmz(Id());
	if(mrtdt < 0) kidlgz=kapni;
	else kidlgz=mgzerz;
	lep=kidlgz;
%>

void rslt::jvsltz()
<%
	foreach(izlt* felvnl,eler)
	<%
		felvnl->jlnrdz();
	%>
%>

void rslt::kltzik()
<%
	prmza *prl=korrkt->kidlgz->kket.value(Id());
	int bprl=prl->prmz.size() - prmz.size();

	while(bprl > 0)
	<%
		bprl--;
		elgyk *klsirz=new elgyk(korrkt,this);
		prmz.push_back(klsirz);
		klsirz->show();
	%>

	while(bprl < 0)
	<%
		bprl++;
		elgyk *klsirz=prmz.takeFirst();
		klsirz->hide();
		delete klsirz;
	%>

	qreal mrtdt=mgmozt->textWidth();
	for(int i=0; i<prmz.size(); ++i)
	<%
		elgyk *klsirz=prmz[i];
		QPointF alkt=QPointF(mrtdt - 25*i - 16,-22);
		klsirz->setPos(alkt);
	%>
%>

/*!
 * @praise Shiva
 */
rslt::~rslt()
<%
	delete mgmozt;
	delete meghat;
%>

void rslt::targy(bool fnqll)
<%
	kitzjl=fnqll;
	foreach(izlt* felvnl,eler)
	<%
		felvnl->targy();
	%>
%>

void rslt::inputMethodEvent(QInputMethodEvent *e)
<%
	if(!kapod)
	<%
		e->ignore();
		return;
	%>
	meghat->beginEditBlock();
	meghat->removeSelectedText();

	if(!e->commitString().isEmpty() or e->replacementLength())
	<%
		QTextCursor c=*meghat;
		c.setPosition(c.position() + e->replacementStart());
		c.setPosition(c.position() + e->replacementLength(),QTextCursor::KeepAnchor);
		c.insertText(e->commitString());
	%>

	QTextBlock block=meghat->block();
	QTextLayout *layout=block.layout();
	QList<QTextLayout::FormatRange> overrides;
	for(int i=0; i < e->attributes().size(); ++i)
	<%
		const QInputMethodEvent::Attribute &a=e->attributes().at(i);
		if(a.type==QInputMethodEvent::TextFormat)
		<%
			QTextCharFormat f=qvariant_cast<QTextFormat>(a.value).toCharFormat();
			if(f.isValid())
			<%
				QTextLayout::FormatRange o;
				o.start=a.start + meghat->position() - block.position();
				o.length=a.length;
				o.format=f;
				overrides.append(o);
			%>
		%>
	%>
	layout->setAdditionalFormats(overrides);
	meghat->endEditBlock();

	adjustSize();
	update();
%>

