/*
 * Copyright (C) 2005 Alex Murray <murray.alex@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PREFS_DIALOG_H
#define PREFS_DIALOG_H

#include "sensors-applet.h"

struct _PrefsDialog {
	SensorsApplet *sensors_applet;
	GtkDialog *dialog;
	GtkNotebook *notebook;

	/* widgets for global prefs */
	GtkSpinButton *num_sensors_spinbutton, *timeout_spinbutton;
	GtkBox *globals_vbox;
	GtkBox *globals_hbox[4];
	GtkComboBox *font_size_combo_box;
	GtkLabel *num_sensors_label, *timeout_label, *font_size_label;
	GtkCheckButton *fahrenheit_checkbutton, *show_labels_checkbutton, *labels_inline_checkbutton, *show_units_checkbutton;
	GtkAdjustment *num_sensors_adjust, *timeout_adjust; 

	/* widgets for sensors tree */
	GtkTreeView *view; 
	GtkTooltips *view_tooltips;
	GtkTreeSelection *selection;
	GtkTreeViewColumn *id_column, *label_column, *enable_column;
	GtkCellRenderer *id_renderer, *label_renderer, *enable_renderer;
	GtkScrolledWindow *scrolled_window;
	GtkBox *sensors_vbox; /* holds scrolled_window and hbox */
	GtkBox *sensors_hbox; /* holds alarm button */
	GtkButton *sensor_config_button;
};


/* function prototypes */
void prefs_dialog_init(PrefsDialog *prefs_dialog);
void prefs_dialog_show(SensorsApplet *sensors_applet);

#endif /* PREFS_DIALOG_H */
