/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "Network.h"

Network::Network(const int secondsLimit, const short resolution, const QString& nicName, const uint32_t speedLimit, const bool bigger, const TrafficDirection direction) : AbstractLoopCondition(secondsLimit, resolution) {
	this->nicName = nicName;
	this->speedLimit = speedLimit;
	this->bigger = bigger;
	this->direction = direction;
	memset(&old_network_data, 0, sizeof old_network_data);
}

void Network::open() {
#ifdef SA_OPEN_NET
	error = sa_open_net();
#elif defined SA_OPEN_NETWORK
	error = sa_open_network();
#endif
}

bool Network::evaluate() {
#if SA_VERSION_MAJOR > 0 || (SA_VERSION_MAJOR == 0 && SA_VERSION_SMALL >= 6)
	if ((error = sa_reset_net_interfaces()) != 0)
		return 0;

	struct sa_net_interface new_network_data;
	if ((error = sa_get_net_interface(nicName.toAscii().data(), &new_network_data)) != 0)
		return 0;
#else
	struct sa_network_interface new_network_data;
	if ((error = sa_get_network_interface(nicName.toAscii().data(), &new_network_data)) != 0)
		return 0;
#endif

	bool result;
	if (direction == DOWNLOAD)
		result = bigger ? new_network_data.received_bytes - old_network_data.received_bytes > speedLimit : new_network_data.received_bytes - old_network_data.received_bytes < speedLimit;
	else
		result = bigger ? new_network_data.sent_bytes - old_network_data.sent_bytes > speedLimit : new_network_data.sent_bytes - old_network_data.sent_bytes < speedLimit;

	old_network_data = new_network_data;
	return result;
}

void Network::close() {
#ifdef SA_CLOSE_NET
	error = sa_close_net();
#elif defined SA_CLOSE_NETWORK
	error = sa_close_network();
#endif
}
