/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef NETWORK_H_
#define NETWORK_H_

#include <libsysactivity/libsysactivity.h>
#include "AbstractLoopCondition.h"

enum TrafficDirection {
	UPLOAD, DOWNLOAD
};

class Network : public AbstractLoopCondition {

public:
	Network(const int secondsLimit, const short resolution, const QString& nicName, const uint32_t speedLimit, const bool bigger, const TrafficDirection direction);

protected:
	void open();
	bool evaluate();
	void close();

private:
	uint32_t speedLimit; // bytes/sec
	bool bigger;
	TrafficDirection direction;
#if SA_VERSION_MAJOR > 0 || (SA_VERSION_MAJOR == 0 && SA_VERSION_SMALL >= 6)
	struct sa_net_interface old_network_data;
#else
	struct sa_network_interface old_network_data;
#endif
	QString nicName;

};

#endif /* NETWORK_H_ */
