//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------

#ifndef SEQ24_MAINWINDOW
#define SEQ24_MAINWINDOW

#include <gtk--/button.h>
#include <gtk--/window.h>
#include <gtk--/accelgroup.h>
#include <gtk--/box.h>
#include <gtk--/main.h>
#include <gtk--/menu.h>
#include <gtk--/menubar.h>
#include <gtk--/eventbox.h>
#include <gtk--/window.h>
#include <gtk--/table.h>
#include <gtk--/drawingarea.h>
#include <gtk--/label.h>
#include <gtk--/viewport.h> 
#include <gtk--/fileselection.h>
#include <gtk--/dialog.h>
#include <gtk--/text.h>
#include <gtk--/arrow.h>
#include <gtk--/spinbutton.h>
#include <gtk--/progressbar.h>
#include <gtk--/inputdialog.h> 

#include "perform.h"
#include "sequence.h"
#include "event.h"
#include "mainwid.h"
#include "options.h"
#include "maintime.h"

#include "globals.h"

#include <map>


using namespace Gtk;
using SigC::slot;
using SigC::bind;
using namespace Menu_Helpers;


class mainwnd : public Gtk::Window
{
   
 private:
 
    MenuBar  *m_menubar;
    Menu     *m_menu_file;
    Menu     *m_menu_control;
    Menu     *m_menu_help;

    perform  *m_mainperf;

    mainwid  *m_main_wid;
    maintime *m_main_time;

    Gdk_Cursor   m_main_cursor;
    
    FileSelection *m_filesel;

    Button      *m_button_stop;
    Button      *m_button_play;

    Button      *m_button_perfedit;

    SpinButton  *m_spinbutton_bpm;
    Adjustment  *m_adjust_bpm;

    SpinButton  *m_spinbutton_ss;
    Adjustment  *m_adjust_ss;

    SpinButton  *m_spinbutton_load_offset;
    Adjustment  *m_adjust_load_offset;

    Entry       *m_entry_notes;

    Connection   m_timeout_connect;

    int      m_screen_set;
 
    void file_save_dialog( void );
    void file_open_dialog( void );

    void options_dialog( void );
    void about_dialog( void );

    void file_save( bool );
    void file_open( bool );

    void adj_callback_ss( );
    void adj_callback_bpm( );

    void edit_callback_notepad( );

    int timer_callback();

    void start_playing();
    void stop_playing();

    void open_performance_edit( );

    map<long,long> key_events;
    bool m_l_control_pressed;
    bool m_r_control_pressed;
    bool m_l_alt_pressed;

    bool m_sequence_state[c_total_seqs];

 public:

    mainwnd(perform *a_p);

    void destroy_func();

    int delete_event_impl(GdkEventAny *a_e);
    int key_press_event_impl(GdkEventKey* a_ev);
    int key_release_event_impl(GdkEventKey* a_ev);
};


#endif
