//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------

#ifndef SEQ24_PERFORM
#define SEQ24_PERFORM

class perform;

#include "globals.h"
#include "event.h"
#include "midibus.h"
#include "midifile.h"
#include "sequence.h"
#include <unistd.h>
#include <pthread.h>

/* class contains sequences that make up a live set */

class midi_control
{
 public:

	bool m_active;
	bool m_inverse_active;
	unsigned char m_status;
	unsigned char m_data;
	unsigned char m_min_value;
	unsigned char m_max_value;
};

class perform
{
 private:

    /* vector of sequences */
    sequence *m_seqs[c_max_sequence];

    bool m_seqs_active[ c_max_sequence ];

    /* our midibus */
    mastermidibus m_master_bus;

    /* pthread info */
    pthread_t m_out_thread;
    pthread_t m_in_thread;

    bool m_running;
    bool m_inputing;
    bool m_looping;

    bool m_playback_mode;

    int thread_trigger_width_ms; 

    long m_left_tick;
    long m_right_tick;

    long m_tick;

    long m_elapsed_tick_copy;
   
    void set_running( bool a_running );
    bool is_running();



    void launch_output_thread( bool a_playback_mode );

    string m_screen_set_notepad[c_max_sets];

    midi_control m_midi_cc_toggle[c_seqs_in_set];
	midi_control m_midi_cc_on[c_seqs_in_set];
	midi_control m_midi_cc_off[c_seqs_in_set];

	int m_offset;

 public:



    perform();
    ~perform();

    void launch_input_thread( void );
    
    void add_sequence( sequence *a_seq, int a_perf );
    void delete_sequence( int a_num );

    long get_tick( ) { return m_tick; };

    void set_left_tick( long a_tick );
    long get_left_tick( void );

    void set_right_tick( long a_tick );
    long get_right_tick( void );

    void move_triggers( bool a_direction );
    void copy_triggers(  );

    void print();

	midi_control *get_midi_control_toggle( unsigned int a_seq );
	midi_control *get_midi_control_on( unsigned int a_seq );
	midi_control *get_midi_control_off( unsigned int a_seq );

    void set_screen_set_notepad( int a_screen_set, string *a_note );
    string *get_screen_set_notepad( int a_screen_set );

    void start( bool a_state );
    void stop();

    void off_sequences( void );

    bool is_active(int a_sequence);

    void new_sequence( int a_sequence );

    /* plays all notes to Curent tick */
    void play( long a_tick );
    void set_orig_ticks( long a_tick  );

    sequence * get_sequence( int a_sequence );

    void reset_sequences( void );

    void set_bpm(int a_bpm);
    int  get_bpm( );

    void set_looping( bool a_looping ){ m_looping = a_looping; };

    void sequence_playing_toggle( int a_sequence );
    void sequence_playing_on( int a_sequence );
    void sequence_playing_off( int a_sequence );

	void sequence_queued_toggle( int a_sequence );
	void sequence_queued_off( int a_sequence );


    mastermidibus* get_master_midi_bus( );

    friend void *output_thread_func(void *a_p);
    friend void *input_thread_func( void *a_p );


    long get_max_trigger( void );

	void set_offset( int a_offset );

    friend class midifile;

};

/* located in perform.C */
extern void *output_thread_func(void *a_p);
extern void *input_thread_func(void *a_p);

#endif
