//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------
#include "config.h"


#ifndef SEQ24_GLOBALS
#define SEQ24_GLOBALS

#include <string>
#include <gtk--/main.h>
#include <gtk--/drawingarea.h>

using namespace std;

/* 16 per screen */
const int c_mainwnd_rows = 4;
const int c_mainwnd_cols = 8;
const int c_seqs_in_set = c_mainwnd_rows * c_mainwnd_cols;
const int c_max_sets = 32;
const int c_total_seqs = c_seqs_in_set * c_max_sets;

/* number of sequences */
/* 32 screen sets */
const int c_max_sequence =  c_mainwnd_rows *  c_mainwnd_cols * c_max_sets;


const int c_ppqn         = 192;  /* default - dosnt change */
const int c_bpm          = 120;  /* default */
const int c_maxBuses = 32;

/* trigger width in milliseconds */
const int c_thread_trigger_width_ms = 4;
const int c_thread_trigger_lookahead_ms = 2;

/* for the seqarea class */
const int c_text_x = 6;
const int c_text_y = 12;
const int c_seqarea_x = c_text_x * 15;
const int c_seqarea_y =  c_text_y * 5;

const int c_mainwid_border = 0;
const int c_mainwid_spacing = 2;

const int c_control_height = 0;


const int c_mainwid_x = ((c_seqarea_x + c_mainwid_spacing ) 
			 * c_mainwnd_cols - c_mainwid_spacing
			 +  c_mainwid_border * 2 );
const int c_mainwid_y = ((c_seqarea_y  + c_mainwid_spacing ) 
			 * c_mainwnd_rows
			 +  c_mainwid_border * 2 
			 +  c_control_height );



/* data entry area (velocity, aftertouch, etc ) */
const int c_dataarea_y = 128;
/* width of 'bar' */
const int c_data_x = 2;

/* keyboard */
const int c_key_x = 16;
const int c_key_y = 8;
const int c_num_keys = 128;
const int c_keyarea_y = c_key_y * c_num_keys + 1;
const int c_keyarea_x = 36;
const int c_keyoffset_x = c_keyarea_x - c_key_x;


/* paino roll */
const int c_rollarea_y = c_keyarea_y;

/* events bar */
const int c_eventarea_y = 20;
const int c_eventevent_y = 14;
const int c_eventevent_x = 7;

/* time scale window on top */
const int c_timearea_y = 18;

/* sequences */
const int c_midi_notes = 256;
const string c_dummy( "Untitled" );

/* maximum size of sequence, default size */
const int c_maxbeats     = 64;   /* max number of beats in a sequence */


/* midifile tags */
const unsigned long c_midibus =    0x24240001;
const unsigned long c_midich =     0x24240002;
const unsigned long c_midiclocks = 0x24240003;
const unsigned long c_triggers =   0x24240004;
const unsigned long c_notes =      0x24240005;
const unsigned long c_timesig =    0x24240006;
const unsigned long c_bpmtag =     0x24240007;

const unsigned long c_midictrl =   0x24240010;


/* about box */
const string 
c_about( 

	string ( PACKAGE ) + string( " " ) + string( VERSION ) +
	string ( " Interactive Midi Sequencer\n" )+
	string ( "\n" )+
	string ( "Author: Rob C. Buse (rcbuse@filter24.org)\n" )+
	string ( "\n" )+
	string ( "For information about seq24, read the SEQ24\n" )+
	string ( "file included with the source.\n" )+
	string ( "\n" )+
	string ( "Visit http://www.filter24.org for updates.\n" )+
	string ( "\n" )+
	string ( "Copyright (c) 2003  Rob C. Buse\n" )+
	string ( "Released under the GNU Public License, see\n" )+
	string ( "COPYING for details.\n" )
);

extern Gdk_Font c_text_font_6_12;
extern Gdk_Font c_text_font_8_13;
extern Gdk_Font c_text_font_5_7;

/* used in menu to tell setState what to do */
const int c_adding = 0;
const int c_normal = 1;
const int c_paste = 2;

/* redraw when recording ms */
const int c_redraw_ms = 40;



/* consts for perform editor */
const int c_names_x = 6 * 24;
const int c_names_y = 12;
const int c_perf_scale_x = 32; /*ticks per pixel */

extern bool global_showmidi;
extern bool global_priority;
extern bool global_stats;
extern bool global_pass_sysex;

/* scales */
enum c_music_scales {

  c_scale_off,
  c_scale_major,
  c_scale_minor,
  c_scale_size

};


const bool c_scales_policy[c_scale_size][12] =

  {
    /* off = chromatic */
    { true,true,true,true,true,true,true,true,true,true,true,true},

    /* major */
    { true,false,true,false,true,true,false,true,false,true,false,true},

    /* minor */
    { true,false,true,true,false,true,false,true,true,false,true,false},

  };

const char c_scales_text[c_scale_size][20] =
  { 
    "Off", 
    "Major", 
    "Minor" 
  };

const char c_key_text[][20] =
  {
    "C", 
    "C#/Db", 
    "D", 
    "Eb", 
    "E",
    "F", 
    "F#/Gb",
    "G",
    "Ab",
    "A",
    "Bb",
    "B/Cb"
  };

//const char 


#endif
