#
# Copyright (C) 2006 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin
import re


class plugin(Plugin):
    summary =_('''
    SELinux is preventing the $SOURCE from using potentially mislabeled files $TARGET_PATH ($TARGET_TYPE).
    ''')

    problem_description = _('''
    SELinux has denied the $SOURCE access to potentially
    mislabeled files $TARGET_PATH.  This means that SELinux will not
    allow httpd to use these files.  Many third party apps install html files
    in directories that SELinux policy cannot predict.  These directories
    have to be labeled with a file context which httpd can access.
    ''')

    fix_description = _('''
    If you want to change the file context of $TARGET_PATH so that the httpd
    daemon can access it, you need to execute it using
    chcon -t httpd_sys_content_t '$TARGET_PATH'.  You can
    look at the httpd_selinux man page for additional information.
    ''')

    def __init__(self):
        Plugin.__init__(self, __name__)
        self.set_priority(65)

    def analyze(self, avc):
        if avc.matches_source_types(['httpd_t', 'httpd_.*_script_t'])        and \
           not avc.matches_target_types(['.*_home_t', '.*_tmp_t', 'tmp_t'])  and \
           avc.has_tclass_in(['dir', 'file', 'lnk_file', 'sock_file']):
            # MATCH
            return self.report(avc, _("File Label"),
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        return None

