shpproj(1) -- Reproject Shapefiles using PROJ.4
===============================================

##SYNOPSIS
`shpproj` _in_shp_file_ _out_shp_file_ [`-i=`_in_proj_file_ | `-i=`"_in_params_" | `-i=geographic`] [`-o=`_out_info_file_ | `-o=`"_out_params_" | `-o=geographic`]

##OPTIONS
 * _in_shp_file_:
 the name of an existing shapefile.

 * _out_shp_file_:
 the name of the new fixed shapefile that will be created.

 * `-i`:
 Input projection. Input can come from one of three sources. A projection parameter file, directly through parameters or geographic. If the shapefile has an associated prj file, name the same as the shapefile but ending in ".prj" it will be used by default ignoring all other parameters. If input is omitted it defaults to geographic, unless the default prj file exists.

 * `-o`:
 Output can come from one of three sources. A projection parameter file, directly through parameters or geographic. If output is omitted it defaults to geographic.

##PROJECTION DETAILS
 * PROJECTION PARAMETER FILE:
 This file MUST end with the extension ".prj". It has the form of one projection parameter per line. Parameters can be in any order. The projection parameters are those used to define a PROJ.4 projection.

 * PROJECTION PARAMETERS:
 Are the same as used by proj and invproj.

use:
    proj -lu   to see available units
    proj -le   to see available ellipsoid

Or visit the PROJ.4 web page at http://www.remotesensing.org/proj for more details.

##EXAMPLE
The following example projects file _rowtest_ to _row3_, moving data from Stateplane NAD83 zone 1002 to utm zone 16 in meters

`shpproj` _rowtest_ _row_ `-i=`"init=nad83:1002 units=us-ft" `-o=`"proj=utm zone=16 units=m"

`shpproj` _rowtest_ _row3_ `-o=`"proj=utm zone=18 units=m" `-i=`"zone=16 proj=utm units=us-ft"

`shpproj` _rowtest_ _row3_ `-o=`"proj=utm zone=18 units=m"

This example uses a prj file and converts to geographic. note that `-o=geographic` can be ommitted.

`shpproj` _rowtest_ _row3_ `-i=`_myfile.prj_ `-o=geographic`

##AUTHOR
`shpproj` is part of shapelib, maintained by Frank Warmerdam. This guide was created by Eduardo Patoo Kanegae and converted to manpage by Johan Van de Wauw.

##SEE ALSO
`proj`(1), `dbfadd`(1), `dbfcat`(1), `dbfcreate`(1), `dbfdump`(1), `dbfinfo`(1), `shpadd`(1), `shpcat`(1), `shpcentrd`(1), `shpcreate`(1), `shpdump`(1), `shpdxf`(1), `shpfix`(1), `shpinfo`(1), `shprewind`(1), `shptest`(1)

