/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * AtFS -- Attribute Filesystem
 *
 * aftransact.c -- a simple transaction mechanism
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: aftransact.c[7.0] Fri Jun 25 14:49:48 1993 andy@cs.tu-berlin.de frozen $
 */

#include "atfs.h"

/*=========================
 * afAddToTransactionList
 *=========================*/

LOCAL Af_revlist **afTransactionList;

LOCAL int afTransactionCount = 0;

#define AF_TR_SEGSIZE 16

EXPORT int afAddToTransactionList (list)
     Af_revlist *list;
{
  int i;

  if (afTransactionCount == 0) {
    if ((afTransactionList = (Af_revlist **)malloc ((unsigned) AF_TR_SEGSIZE * sizeof (Af_revlist*))) == NULL)
      FAIL ("AddToTransactionList", "malloc", AF_ESYSERR, ERROR);
    afTransactionCount = AF_TR_SEGSIZE;
    for (i=0; i<afTransactionCount; i++)
      afTransactionList[i] = NULL;
  }

  for (i=0; i<afTransactionCount; i++) {
    if (afTransactionList[i] == NULL) {
      afTransactionList[i] = list;
      return (AF_OK);
    }
    if (afTransactionList[i] == list)
      return (AF_OK);
  }

  if ((afTransactionList = (Af_revlist **)realloc ((char *)afTransactionList, (unsigned) (afTransactionCount + AF_TR_SEGSIZE) * sizeof (Af_revlist*))) == NULL)
    FAIL ("AddToTransactionList", "realloc", AF_ESYSERR, ERROR);
  afTransactionCount += AF_TR_SEGSIZE;

  for (i += 1; i<afTransactionCount; i++)
    afTransactionList[i] = NULL;

  afTransactionList[i-AF_TR_SEGSIZE] = list;
  return (AF_OK);
}

/*=================
 * af_transaction
 *=================*/

EXPORT int afCurTransaction = 0;

EXPORT void af_transaction ()
{
  afCurTransaction = 1;
}

/*=================
 * af_commit
 *=================*/

EXPORT int af_commit ()
{
  int i=0, retCode = AF_OK, retVal;

  if (!afCurTransaction)
    return (AF_OK);

  afCurTransaction = 0;

  if (afTransactionCount == 0)
    return (AF_OK);

  while (afTransactionList[i]) {
    if ((afTransactionList[i]->af_extent & AF_CACHE) == AF_CACHE)
      retVal = afObjCacheWrite (afTransactionList[i]);
    else
      retVal = afWriteArchive (afTransactionList[i]);

    if (retVal == ERROR)
      retCode = ERROR;
    
    afTransactionList[i] = NULL;
    if (++i == afTransactionCount)
      return (retCode);
  }
  return (retCode);
}

/*=================
 * af_abort
 *=================*/

EXPORT int af_abort ()
{
  int i=0;

  if (!afCurTransaction)
    return (AF_OK);

  afCurTransaction = 0;

  if (afTransactionCount == 0)
    return (AF_OK);

  while (afTransactionList[i]) {
    afDetachList (afTransactionList[i]);
    afTransactionList[i] = NULL;
    if (++i == afTransactionCount)
      return (AF_OK);
  }
  return (AF_OK);
}

