%define name shorewall-perl
%define version 4.0.12
%define release 0base

Summary: Shoreline Firewall Perl-based compiler.
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
Packager: Tom Eastep <teastep@shorewall.net>
Group: Networking/Utilities
Source: %{name}-%{version}.tgz
URL: http://www.shorewall.net/
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: perl shorewall-common >= 4.0.0
Conflicts: shorewall < 3.4.2
Provides: shorewall_compiler = %{version}-%{release}
Provides: shorewall = %{version}-%{release}

%description

The Shoreline Firewall, more commonly known as "Shorewall", is a Netfilter
(iptables) based firewall that can be used on a dedicated firewall system,
a multi-function gateway/ router/server or on a standalone GNU/Linux system.

Shorewall-perl is a part of Shorewall that allows faster compilation and
execution than the legacy shorewall-shell compiler.

%prep

%setup

%build

%install
export PREFIX=$RPM_BUILD_ROOT ; \
export OWNER=`id -n -u` ; \
export GROUP=`id -n -g` ;\
./install.sh -n

%clean
rm -rf $RPM_BUILD_ROOT

%pre

%post

%preun

%files
%defattr(0644,root,root,0755)

%attr(0755,root,root) %dir /usr/share/shorewall-perl
%attr(0755,root,root) %dir /usr/share/shorewall-perl/Shorewall

%attr(755,root,root) /usr/share/shorewall-perl/compiler.pl
%attr(0644,root,root) /usr/share/shorewall-perl/prog.header
%attr(0644,root,root) /usr/share/shorewall-perl/prog.functions
%attr(0644,root,root) /usr/share/shorewall-perl/prog.footer
%attr(0644,root,root) /usr/share/shorewall-perl/version
%attr(0644,root,root) /usr/share/shorewall-perl/Shorewall/*.pm

%doc COPYING releasenotes.txt

%changelog
* Tue Jun 24 2008 Tom Eastep tom@shorewall.net
- Updated to 4.0.12-0base
* Mon May 19 2008 Tom Eastep tom@shorewall.net
- Updated to 4.0.11-0base
* Sat Mar 29 2008 Tom Eastep tom@shorewall.net
- Updated to 4.0.10-0base
* Fri Feb 15 2008 Tom Eastep tom@shorewall.net
- Updated to 4.0.9-0base
* Sun Jan 06 2008 Tom Eastep tom@shorewall.net
- Updated to 4.0.8-0base
* Wed Dec 26 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.7-0base
* Mon Dec 17 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.7-0RC2
* Mon Dec 17 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.7-RC2-1
* Sat Dec 15 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.7-0RC1
* Thu Dec 13 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.7-0base
* Thu Nov 25 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.7-1
* Thu Nov 15 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.6-1
* Sat Nov 10 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.6-0RC3
* Wed Nov 07 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.6-0RC2
* Thu Oct 25 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.6-0RC1
* Tue Oct 03 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.5-1
* Wed Sep 05 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.4-1
* Mon Aug 13 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.3-1
* Thu Aug 09 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.2-1
* Sat Jul 21 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.1-1
* Wed Jul 11 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.0-1
* Sun Jul 08 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.0-0RC2
* Fri Jun 29 2007 Tom EAstep tom@shorewall.net
- Updated to 4.0.0-0RC1
* Sun Jun 24 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.0-0Beta7
* Wed Jun 20 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.0-0Beta6
- Add new components.
* Thu Jun 14 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.0-0Beta5
* Fri Jun 08 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.0-0Beta4
* Tue Jun 05 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.0-0Beta3
* Sat May 26 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.0-0Beta2
* Tue May 15 2007 Tom Eastep tom@shorewall.net
- Updated to 4.0.0-0Beta1
* Fri May 11 2007 Tom Eastep tom@shorewall.net
- Updated to 3.9.7-1
* Sat May 05 2007 Tom Eastep tom@shorewall.net
- Updated to 3.9.6-1
* Mon Apr 30 2007 Tom Eastep tom@shorewall.net
- Updated to 3.9.5-1
* Mon Apr 23 2007 Tom Eastep tom@shorewall.net
- Updated to 3.9.4-1
* Wed Apr 18 2007 Tom Eastep tom@shorewall.net
- Updated to 3.9.3-1
* Sat Apr 14 2007 Tom Eastep tom@shorewall.net
- Updated to 3.9.2-1
* Sat Apr 07 2007 Tom Eastep tom@shorewall.net
- Initial version 3.9.1-1
* Sat Mar 24 2007 Tom Eastep tom@shorewall.net
- Initial version 3.9.0-1


