/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-title.h DvdTitle header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_TITLE_H__
#define __DVD_TITLE_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_TITLE_TYPE			(dvd_title_get_type())
#define DVD_TITLE(o)			(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_TITLE_TYPE, DvdTitle))
#define DVD_TITLE_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST    (k, DVD_TITLE_TYPE, DvdTitleClass))
#define DVD_TITLE_IS_TITLE(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_TITLE_TYPE))
#define DVD_TITLE_IS_TITLE_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_TITLE_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdTitle		DvdTitle;
typedef struct	_DvdTitleClass		DvdTitleClass;

struct _DvdTitle {
	GObject	  parent;
	
	DvdSource source;
	guint8	  title_id;
	DvdTime	 *time;
	guint32	  kbs;
	DvdVideo  *video;
	guint8	  audio_tracks;
	DvdAudio *audio[MAX_DVD_AUDIO_TRACKS];
	guint8	  chapter_count;
	GSList	 *chapters;	/**< list of DvdChapter objects */
};

/** Dvd title class definition */
struct _DvdTitleClass {
	GObjectClass	parent;
};


/* --- prototypes --- */
GType	    dvd_title_get_type		(void);
DvdTitle*   dvd_title_new		(DvdSource	  source);
void	    dvd_title_append_chapter	(DvdTitle	 *title,
					 DvdChapter	 *chapter);

/* Information */
guint8	    dvd_title_get_id		(DvdTitle	 *title);
guint8	    dvd_title_get_chapters	(DvdTitle	 *title);
DvdChapter* dvd_title_get_chapter	(DvdTitle	 *title,
					 guint8		  chapter_id);
G_CONST_RETURN
DvdTime*    dvd_title_get_time		(DvdTitle	 *title);
guint32	    dvd_title_get_kbs		(DvdTitle	 *title);
void	    dvd_title_get_size		(DvdTitle	 *title,
					 guint8		 *gbytes,
					 guint16	 *mbytes,
					 guint16	 *kbytes);
DvdVideo*   dvd_title_get_video		(DvdTitle	 *title);
guint8	    dvd_title_get_audio_tracks	(DvdTitle	 *title);
DvdAudio*   dvd_title_get_audio		(DvdTitle	 *title,
					 guint8		  track_number);
G_END_DECLS

#endif /*__DVD_TITLE_H__*/
