/*

  HelloX.C
  ========
  (c) Copyright Paul Griffiths 1999
  Email: paulgriffiths@cwcom.net

  "Hello, World!", X Window System style.
  
  Hacked into a Graphite demo helloworld

*/


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <iconv.h>

/*########################################################*/
/*# BEGIN:  TT/AA message */
#include <X11/Xft/Xft.h>
/*# END : TT/AA message */
/*########################################################*/
#include "DrawGraphiteString.h"


/*  Global variables  */

Display *     display;
int           screen_num;
static char * appname;


/*  main() function  */
extern "C" {

int main( int argc, char * argv[] ) {

    /*  Window variables  */

    Window       win;
    int          x, y;
    unsigned int width, height;
    unsigned int border_width;
    char *       window_name = "Hello, X Window System!";
    char *       icon_name   = "HelloX";


    /*  Display variables  */

    char *       display_name = NULL;
    unsigned int display_width, display_height;
    

    /*  Miscellaneous X variables  */

    XSizeHints *  size_hints;
    XWMHints   *  wm_hints;
    XClassHint *  class_hints;
    XTextProperty windowName, iconName;
    XEvent        report;
    XFontStruct * font_info;
    XGCValues     values;
    GC            gc;
    
    appname = argv[0];


    /*  Allocate memory for our structures  */

    if ( !( size_hints  = XAllocSizeHints() ) || 
	 !( wm_hints    = XAllocWMHints()   ) ||
	 !( class_hints = XAllocClassHint() )    ) {
	fprintf(stderr, "%s: couldn't allocate memory.\n", appname);
	exit(EXIT_FAILURE);
    }


    /*  Connect to X server  */

    if ( (display = XOpenDisplay(display_name)) == NULL ) {
	fprintf(stderr, "%s: couldn't connect to X server %s\n",
		appname, display_name);
	exit(EXIT_FAILURE);
    }


    /*  Get screen size from display structure macro  */

    screen_num     = DefaultScreen(display);
    display_width  = DisplayWidth(display, screen_num);
    display_height = DisplayHeight(display, screen_num);


    /*  Set initial window size and position, and create it  */

    x = y = 0;
    width  = display_width / 3;
    height = display_width / 3;

    win = XCreateSimpleWindow(display, RootWindow(display, screen_num),
			      x, y, width, height, border_width,
			      BlackPixel(display, screen_num),
			      WhitePixel(display, screen_num));


    /*  Set hints for window manager before mapping window  */

    if ( XStringListToTextProperty(&window_name, 1, &windowName) == 0 ) {
	fprintf(stderr, "%s: structure allocation for windowName failed.\n",
		appname);
	exit(EXIT_FAILURE);
    }

    if ( XStringListToTextProperty(&icon_name, 1, &iconName) == 0 ) {
	fprintf(stderr, "%s: structure allocation for iconName failed.\n",
		appname);
	exit(EXIT_FAILURE);
    }

    size_hints->flags       = PPosition | PSize | PMinSize;
    size_hints->min_width   = 200;
    size_hints->min_height  = 100;

    wm_hints->flags         = StateHint | InputHint;
    wm_hints->initial_state = NormalState;
    wm_hints->input         = True;

    class_hints->res_name   = appname;
    class_hints->res_class  = "hellox";

    XSetWMProperties(display, win, &windowName, &iconName, argv, argc,
		     size_hints, wm_hints, class_hints);


    /*  Choose which events we want to handle  */

    XSelectInput(display, win, ExposureMask | KeyPressMask |
		 ButtonPressMask | StructureNotifyMask);


    /*  Load a font called "9x15"  */

    if ( (font_info = XLoadQueryFont(display, "9x15")) == NULL ) {
	fprintf(stderr, "%s: cannot open 9x15 font.\n", appname);
	exit(EXIT_FAILURE);
    }


    /*  Create graphics context  */

    gc = XCreateGC(display, win, 0, &values);

    XSetFont(display, gc, font_info->fid);
    XSetForeground(display, gc, BlackPixel(display, screen_num));


    /*  Display Window  */

    XMapWindow(display, win);


    /*  Enter event loop  */

    while ( 1 ) {
	static char * message = "Hello, X Window System!";
	static int    length;
	static int    font_height;
	static int    msg_x, msg_y;
  typedef union {
    char  utf8[128];
    FcChar16  utf16[64];
  } UniBuffer;
    
  UniBuffer outBuffer;

	XNextEvent(display, &report);

	switch ( report.type ) {

	case Expose:

	    if ( report.xexpose.count != 0 )
		break;

	    /*  Output message centrally in window  */

	    length = XTextWidth(font_info, message, strlen(message));
	    msg_x  = (width - length) / 2;

	    font_height = font_info->ascent + font_info->descent;
	    msg_y  = (height + font_height) / 2;

	    XDrawString(display, win, gc, msg_x, msg_y,
			message, strlen(message));

	    /*########################################################*/
	    /*# BEGIN:  TT/AA message */
	    {

	      /* static char * msg = "Hello, X FreeType AA!"; */
        
	      //FcChar32 msg[] =  {
	      FcChar16 msg[] =  {
		      0x1019, 0x1004, 0x1039, 0x1002, 0x101C, 0x102C, 0x1015, 0x102C, 0x1000, 0x1019, 0x1039, 0x1018, 0x102C, 0x104B, 0x0000
		       };
//               FcChar16 msg[] =  {
//  		      0x1000, 0x0000
//  		       };
        FcChar16 * testMsg = msg; 
        size_t textLen = 14;
        if (argc > 1 && strlen(argv[1]) < 100)
        {
          iconv_t ic = iconv_open("UTF-16","UTF-8");
          if (ic != (iconv_t)(-1))
          {
            size_t maxlenIn = strlen(argv[1]);
            if (maxlenIn + 1 > 64) maxlenIn = 63;
            size_t maxlenOut = sizeof(FcChar16) * (maxlenIn + 1);
            size_t maxAvailable = sizeof(FcChar16) * (maxlenIn);
            char  temp[128];
            strcpy(temp,argv[1]);
            temp[maxlenIn] = '\0';
            char * in = &temp[0];
            char * out = &outBuffer.utf8[0];
            printf("%s char %d\n",argv[1], maxlenIn);
            size_t cLen = iconv(ic,&in,&maxlenIn,&out,&maxlenOut);
            printf("found %s %d char %d\n",argv[1], cLen, strlen(argv[1]));
            iconv_close(ic);
            if (maxAvailable > maxlenOut)
            {
              testMsg = &outBuffer.utf16[1];// i think byte 0 is a BOM
              textLen = (maxAvailable - maxlenOut) / 2;
            }
          }
          else printf("iconv open error");
        }
	      XftDraw *xftdraw;
	      XftFont *xftfont;
	      XftFont *xftfont2;
	      XftColor color_fg;
	      XColor dummyc,fg;
	      Status retval;
	      int nglyph;
	      int nchar;
	      FT_UInt glyph[300];
	      int i;

	      xftdraw = XftDrawCreate(display, (Drawable) win,
				      DefaultVisual(display, screen_num),
				      DefaultColormap(display, screen_num));
	      if (!xftdraw) {
		perror("XftDrawCreate(): Failed"); exit(1);}
    const char * testFontName = "Padauk";
    if (argc > 2)
    {
      testFontName = argv[2]; // assumes ascii name
    }
	      xftfont = XftFontOpen(display, screen_num,XFT_FAMILY, XftTypeString,
				     testFontName,
				     XFT_SIZE, XftTypeInteger, 25, 0);
	      if (!xftfont) {
		perror("XftFontOpen1(): Failed"); exit(1);}
    
        if (!IsGraphiteFont(xftfont)) {
          perror("XftFontOpen1(): graphite font not found"); 
          exit(1);
        }

              xftfont2 = XftFontOpen(display, screen_num,XFT_FAMILY, XftTypeString,
				     "Std SILDoulos",
				     XFT_SIZE, XftTypeInteger, 18, 0);
	      if (!xftfont2) {
		perror("XftFontOpen2(): Failed"); exit(1);}


	      retval = XAllocNamedColor(display,DefaultColormap(display,screen_num),
					"black", &fg, &dummyc);
	      if (!retval) {
		perror("XAllocNamedColor(): Failed"); exit(1);}

	      color_fg.color.red = dummyc.red;
	      color_fg.color.green = dummyc.green;
	      color_fg.color.blue = dummyc.blue;
	      color_fg.color.alpha = 0x00ff00;
	      color_fg.pixel = fg.pixel;
              printf("%x %x %x %x\n",color_fg.color.red, color_fg.color.green, color_fg.color.blue, color_fg.color.alpha);

	      nchar = sizeof(msg)/sizeof(FcChar32) - 1;
	      /* convert ucs4 to index
	         replace with silgraphite code
	       */

	       char msg2[16] = "Hello World!!!\000";
		//DrawGraphiteString(xftdraw, xftfont, msg_x-80, msg_y+30, msg);
		//DrawGraphiteString8(xftdraw, xftfont2, msg_x+10, msg_y+70, msg2, 18);
                msg_x  = width / 2;
		DrawGraphiteString(display, xftdraw, xftfont, msg_x, msg_y+30, testMsg, textLen);
	      /*
	      for(i=0;i<nchar;i++)
		       glyph[i] = XftCharIndex(display, xftfont, msg[i]);
	      nglyph = nchar; /* for simple 1:1 char to glyph mapping */

//	      XftDrawGlyphs(xftdraw, &color_fg, xftfont, msg_x-80, msg_y+30,
//			      &glyph[0], nglyph);
//	      XftDrawGlyphSpec(xftdraw, &color_fg, xftfont,
//			      &glyph[0], nglyph);
		XftFontClose (display, xftfont);
		XftFontClose (display, xftfont2);
                XftDrawDestroy(xftdraw);
                
                
	    }
	    /*# END : TT/AA message */
	    /*########################################################*/

	    break;


	case ConfigureNotify:

	    /*  Store new window width & height  */

	    width  = report.xconfigure.width;
	    height = report.xconfigure.height;

	    break;


	case ButtonPress:            /*  Fall through  */
	case KeyPress:

	    /*  Clean up and exit  */
            XFree(size_hints);
            XFree(wm_hints);
            XFree(class_hints);
	    XUnloadFont(display, font_info->fid);
	    XFreeGC(display, gc);
	    XCloseDisplay(display);
	    exit(EXIT_SUCCESS);

	}
    }

    return EXIT_SUCCESS;   /*  We shouldn't get here  */
}

}
