/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: GrFeature.cpp
Responsibility: Sharon Correll
Last reviewed: Not yet.

Description:
    Implements the GrFeature class.
-------------------------------------------------------------------------------*//*:End Ignore*/

//:>********************************************************************************************
//:>	Include files
//:>********************************************************************************************
#include "Main.h"

#pragma hdrstop
#undef THIS_FILE
DEFINE_THIS_FILE

//:>********************************************************************************************
//:>	Forward declarations
//:>********************************************************************************************

//:>********************************************************************************************
//:>	Local Constants and static variables
//:>********************************************************************************************

namespace gr
{

//:>********************************************************************************************
//:>	Methods
//:>********************************************************************************************

/*----------------------------------------------------------------------------------------------
	Initialize the feature.
----------------------------------------------------------------------------------------------*/	
void GrFeature::Initialize(int nID, int nNameId, int cfset, int nDefault)
{
	m_nID = nID;
	m_nNameId = nNameId;
	m_nDefault = nDefault;

	m_vnVal.resize(cfset);
	for (unsigned int ifset = 0; ifset < m_vnVal.size(); ifset++)
		m_vnVal[ifset] = INT_MAX;
	m_vnNameId.resize(cfset);
}

/*----------------------------------------------------------------------------------------------
	Return the feature settings.
----------------------------------------------------------------------------------------------*/
int GrFeature::Settings(int cMax, int * prgnVal)
{
	int cRet = min(cMax, signed(m_vnVal.size()));
	for (int ifset = 0; ifset < cRet; ifset++)
		prgnVal[ifset] = m_vnVal[ifset];
	return cRet;
}

/*----------------------------------------------------------------------------------------------
	Add a feature setting.
----------------------------------------------------------------------------------------------*/
void GrFeature::AddSetting(int nVal, int nNameId)
{
	Assert(nVal != INT_MAX);
	unsigned int ifset;
	for (ifset = 0; ifset < m_vnVal.size(); ifset++)
	{
		if (m_vnVal[ifset] == nVal)
			return; // already there
	}
	for (ifset = 0; ifset < m_vnVal.size(); ifset++)
	{
		if (m_vnVal[ifset] == INT_MAX)
		{
			m_vnVal[ifset] = nVal;
			m_vnNameId[ifset] = nNameId;
			return;
		}
	}
	m_vnVal.push_back(nVal);
	m_vnNameId.push_back(nNameId);
}

/*----------------------------------------------------------------------------------------------
	Return true if the given setting is valid according to the font's feature table.
----------------------------------------------------------------------------------------------*/
bool GrFeature::IsValidSetting(int nVal)
{
	for (unsigned int ifset = 0; ifset < m_vnVal.size(); ifset++)
	{
		if (m_vnVal[ifset] == nVal)
			return true;
	}
	return false;
}

/*----------------------------------------------------------------------------------------------
	Read the feature label from the name table.
----------------------------------------------------------------------------------------------*/
std::wstring GrFeature::Label(GrEngine * pgreng, int nLang)
{
	std::wstring stu = pgreng->StringFromNameTable(nLang, m_nNameId);
	if (stu == L"NoName")
		stu.erase();
	return stu;
}

/*----------------------------------------------------------------------------------------------
	Read the feature value label from the name table.
----------------------------------------------------------------------------------------------*/
std::wstring GrFeature::SettingLabel(GrEngine * pgreng, int nVal, int nLang)
{
	for (unsigned int ifset = 0; ifset < m_vnVal.size(); ifset++)
	{
		if (m_vnVal[ifset] == nVal)
		{
			std::wstring stu = pgreng->StringFromNameTable(nLang, m_vnNameId[ifset]);
			if (stu == L"NoName")
				stu.erase();
			return stu;
		}
	}
	Assert(false); // setting is not valid
	return L"";
}

/*----------------------------------------------------------------------------------------------
	Return the given setting value.
----------------------------------------------------------------------------------------------*/
int GrFeature::NthSetting(int ifset)
{
	if (ifset >= (int)m_vnVal.size())
		return -1;
	else
		return m_vnVal[ifset];
}

/*----------------------------------------------------------------------------------------------
	Read the feature value label for the given index.
----------------------------------------------------------------------------------------------*/
std::wstring GrFeature::NthSettingLabel(GrEngine * pgreng, int ifset, int nLang)
{
	std::wstring stu;

	if (ifset >= (int)m_vnVal.size())
		stu.erase();
	else
	{
        stu = pgreng->StringFromNameTable(nLang, m_vnNameId[ifset]);
		if (stu == L"NoName")
			stu.erase();
	}
	return stu;
}

/*----------------------------------------------------------------------------------------------
	Return the feature setting label.
----------------------------------------------------------------------------------------------*/
//	void GrFeature::SetSettingLabel(int nVal, std::wstring stuLabel, int nLang)
//	{
//		for (int ifset = 0; ifset < m_vfset.size(); ifset++)
//		{
//			if (m_vfset[ifset].m_nVal == nVal)
//			{
//				m_vfset[ifset].m_hmnstuLabels.Insert(nLang, stuLabel, true);
//				return;
//			}			
//		}
//		Assert(false); // setting is not valid
//	}

} // namespace gr
