/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 2005 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: SegmentAux.cpp
Responsibility: Sharon Correll
Last reviewed: Not yet.

Description:
	Implements auxiliary class that work with Segment:
	- GlyphInfo
	- GlyphIterator
	- LayoutEnvironment
-------------------------------------------------------------------------------*//*:End Ignore*/

//:>********************************************************************************************
//:>	   Include files
//:>********************************************************************************************
#include "Main.h"
#pragma hdrstop
// any other headers (not precompiled)
#ifndef _WIN32
#include <stdlib.h>
#endif

#undef THIS_FILE
DEFINE_THIS_FILE

//:>********************************************************************************************
//:>	   Forward declarations
//:>********************************************************************************************

//:>********************************************************************************************
//:>	   Local Constants and static variables
//:>********************************************************************************************

namespace gr
{

//:>********************************************************************************************
//:>	GlyphInfo methods
//:>********************************************************************************************

gid16 GlyphInfo::glyphID()
{
	return m_pslout->m_chwActual;
}

gid16 GlyphInfo::pseudoGlyphID()
{
	if (m_pslout->m_chwActual == m_pslout->m_chwGlyphID)
		return 0; // not a pseudo-glyph
	return m_pslout->m_chwGlyphID;
}

int GlyphInfo::attachedTo()
{
	if (m_pslout->m_srAttachTo == 0)
		return -1;
	else
		return m_islout + m_pslout->AttachTo();
}

size_t GlyphInfo::logicalIndex()
{
	if (m_pseg->OutputSlot(0)->IsLineBreak())
		return m_islout - 1;
	else
		return m_islout;
}

float GlyphInfo::origin()
{
	return m_pslout->XPosition();
}

float GlyphInfo::advanceWidth()		// logical units
{
	return m_pslout->m_xsAdvanceX;
}

float GlyphInfo::advanceHeight()	// logical units; zero for horizontal fonts
{
	return m_pslout->m_xysAdvY;
}

float GlyphInfo::yOffset()
{
	return m_pslout->YPosition();
}

Rect GlyphInfo::bb()				// logical units
{
	return m_pslout->m_rectBB;
}

bool GlyphInfo::isSpace()
{
	return m_pslout->IsSpace();
}

// first char associated with this glyph, relative to start of seg
toffset GlyphInfo::firstChar()
{
	return m_pseg->LogicalSurfaceToUnderlying(m_islout, true);
}

// last char associated with this glyph, relative to start of seg
toffset GlyphInfo::lastChar()
{
	return m_pseg->LogicalSurfaceToUnderlying(m_islout, false);
}

unsigned int GlyphInfo::directionality()
{
	return m_pslout->Directionality();
}

// Embedding depth
unsigned int GlyphInfo::directionLevel()
{
	return m_pslout->DirLevel();
}

bool GlyphInfo::insertBefore()
{
	return m_pslout->InsertBefore();
}

int GlyphInfo::breakweight()
{
	return m_pslout->BreakWeight();
}

float GlyphInfo::maxStretch(size_t level)
{
	return m_pslout->MaxStretch(m_pseg, (int)level);
}

float GlyphInfo::maxShrink(size_t level)
{
	return m_pslout->MaxShrink(m_pseg, (int)level);
}

float GlyphInfo::stretchStep(size_t level)
{
	return m_pslout->StretchStep(m_pseg, (int)level);
}

byte GlyphInfo::justWeight(size_t level)
{
	return m_pslout->JustWeight((int)level);
}

float GlyphInfo::justWidth(size_t level)
{
	return m_pslout->JustWidth(m_pseg, (int)level);
}

float GlyphInfo::measureStartOfLine()
{
	return m_pslout->MeasureSolLogUnits(m_pseg);
}

float GlyphInfo::measureEndOfLine()
{
	return m_pslout->MeasureEolLogUnits(m_pseg);
}

size_t GlyphInfo::numberOfComponents()
{
	return m_pslout->NumberOfComponents();
}

Rect GlyphInfo::componentBox(size_t icomp)
{
	return m_pseg->ComponentRect(m_pslout, icomp);
}

toffset GlyphInfo::componentFirstChar(size_t icomp)
{
	Assert((int)icomp < m_pslout->NumberOfComponents());
	return m_pslout->UnderlyingComponent(icomp);
}
toffset GlyphInfo::componentLastChar(size_t icomp)
{
	Assert((int)icomp < m_pslout->NumberOfComponents());
	return m_pslout->UnderlyingComponent(icomp);
}

bool GlyphInfo::erroneous()
{
	return m_pseg->Erroneous();
}


//:>********************************************************************************************
//:>	GlyphIterator methods
//:>********************************************************************************************

/*----------------------------------------------------------------------------------------------
	Dereference the iterator, returning a GlyphInfo object.
----------------------------------------------------------------------------------------------*/
GlyphInfo GlyphIterator::operator*()
{
    #ifndef NDEBUG
	size_t cginf = (m_fVector) ? m_viginf.size() : m_pseg->m_cginf;
    #endif
	Assert(m_iginf < cginf);

	if (m_fVector)
		// The index is into the vector of indices indicating which subset is included
		// in this iterator.
		return m_pseg->m_prgginf[m_viginf[m_iginf]];
	else
		return m_pseg->m_prgginf[m_iginf];
}

/*----------------------------------------------------------------------------------------------
	Increment the iterator.
----------------------------------------------------------------------------------------------*/
GlyphIterator GlyphIterator::operator++()
{
	size_t cginf = (m_fVector) ? m_viginf.size() : m_pseg->m_cginf;
	if (m_iginf >= cginf)
	{
		Assert(false);
	}
	else
		m_iginf++;

	return *this;
}

/*----------------------------------------------------------------------------------------------
	Increment the iterator by the given number.
----------------------------------------------------------------------------------------------*/
GlyphIterator GlyphIterator::operator+=(int n)
{
	size_t cginf = (m_fVector) ? m_viginf.size() : m_pseg->m_cginf;
	if (m_iginf + n > cginf)
	{
		Assert(false);
	}
	m_iginf = min(m_iginf + n, cginf);

	return *this;
}

/*----------------------------------------------------------------------------------------------
	Return true if the iterators represent the same glyph.
----------------------------------------------------------------------------------------------*/
bool GlyphIterator::operator==(GlyphIterator & gfit)
{
	if (!SameSet(gfit))
		return false;

	return (m_iginf == gfit.m_iginf);
}

/*----------------------------------------------------------------------------------------------
	Return false if the iterators represent the same glyph.
----------------------------------------------------------------------------------------------*/
bool GlyphIterator::operator!=(GlyphIterator & gfit)
{
	return !(*this == gfit);
}

/*----------------------------------------------------------------------------------------------
	Return the difference in the indices of the two iterators. Returns kInvalid if the
	iterators are based on different sets of glyphs.
----------------------------------------------------------------------------------------------*/
int GlyphIterator::operator-(GlyphIterator & gfit)
{
	if (!SameSet(gfit))
		return kInvalid;
	
	return (m_iginf - gfit.m_iginf);
}

/*----------------------------------------------------------------------------------------------
	Return true if the iterators represent the same set of glyphs.
----------------------------------------------------------------------------------------------*/
bool GlyphIterator::SameSet(GlyphIterator & gfit)
{
	size_t cginfThis = (m_fVector) ? m_viginf.size() : m_pseg->m_cginf;
	size_t cginfThat = (gfit.m_fVector) ? gfit.m_viginf.size() : gfit.m_pseg->m_cginf;

	if (cginfThis != cginfThat)
		return false;

	if (m_fVector != gfit.m_fVector)
		return false;

	if (m_fVector)
	{
		// Do the two vectors have the same items?
		for (size_t iiginf = 0; iiginf < cginfThis; iiginf++)
			if (m_viginf[iiginf] != gfit.m_viginf[iiginf])
				return false;
	}

	return true;
}


} // namespace gr
