#ifndef SUPPORT_H__
#define SUPPORT_H__


#include "channel.h"
#include "query.h"


/*----------------------- support.h --------------------------------*/

/* our client */
typedef struct {
    SilcClient client;		/* The actual SILC Client */
    SilcClientConnection conn;	/* Connection to the server */
    int state;			/* Client's connection state */
    SilcRng rng;    /* Cryptographically strong RNG */
} silkyStruct;
/* FIXME: move silkyStruct to some other .h */

/* this stores some info about resolved names in the channel */
typedef struct {
    SilcChannelEntry channel;
    bool retry;
} SilcJoinResolve;

#ifdef ENABLE_NLS
#include <libintl.h>
#define _(str)  gettext(str)
#define N_(str)  str
#else
#define _(str)  str
#define N_(str)  str
#define ngettext(str1, str2, arg) str2
#endif


/* Ted's - Daniel */
#define countof(a) (sizeof(a) / sizeof(a[0]))
gchar * utf_timestamp (void);

void errordialog(const char *errormessage);

GtkTreeIter get_nicklist_iter_by_clientid (GtkListStore *list_store, SilcClientID *client_id);




char * get_active_channel_name (void);
SilcChannelID * get_active_channel_id (void);

char * get_active_channel_name_by_x (GtkWidget *button);
SilcChannelID * get_active_channel_id_by_x (GtkWidget *button);

void * get_query_window (SilcClientID *clientid);

GtkWidget * get_stored_channel_widget (const char *channel_name, const char *widget_name);
GtkWidget * get_stored_channel_window (const char *channel_name);

int print_mime_to_channel (SilcClientEntry client_entry, const char *channel_name, const gchar *content_type, ...);

int printconsole (const char *msg);
int printchannel (const char *channel_name, const char *str);
int printquery (SilcClientID *clientid, gchar *nickname, SilcMessageFlags flag, const char *str);




void add_user_to_nicklist (GtkListStore *liststore, SilcChannelEntry channel, SilcChannelUser user);



gchar * set_cmode_window_widgets (gchar *channel_name, SilcUInt32 mode);

void error_no_channel_oper_priv (gchar *channel_name);
void error_no_channel_founder_priv (gchar *channel_name);
void error_user_not_on_channel (gchar *channel_name);

void mime_types_list_destroy (void);
gchar *mime_types_get_type(gchar *filename);
GHashTable *mime_init(gchar *file);

void close_all_tabs( void );

gboolean context_nick_event(GtkTextTag *texttag, GObject *arg1, GdkEvent *event, GtkTextIter *arg2, gpointer user_data);

SilcChannelUser get_channel_user_by_entry(SilcChannelEntry channel, SilcClientEntry client);
gboolean silky_read_mimetable();

gboolean silky_create_serverkeydir(gchar *serverkeydir);
gboolean silky_create_silkydir(gchar *silkydir);
gchar *silky_get_silkydir(gchar *homedir);
gchar *silky_get_homedir();

int debug_value;
int usec_value;

/* states for silkyStruct->state */
enum {
    STATE_DISCONNECTED,
    STATE_CONNECTING,
    STATE_CONNECTED,
    STATE_DISCONNECTING
};

#define DISCONNECTED	(((silky->state == STATE_DISCONNECTED) && (!silky->conn)) ? 1 : 0)
#define CONNECTING	(((silky->state == STATE_CONNECTING) && (!silky->conn)) ? 1: 0)
#define CONNECTED	(((silky->state == STATE_CONNECTED) && (silky->conn)) ? 1 : 0)
#define DISCONNECTING	(((silky->state == STATE_DISCONNECTING) && (!silky->conn)) ? 1: 0)

void hilight_channel_window_by_ch(SilkyChannel *ch, gint type);
void hilight_query_window_by_q(SilkyQuery *q, gint type);

enum {
    HILIGHT_MOTION,	/* other users join, part, kick, quit, ... */
    HILIGHT_SPEECH,	/* public action or public message */
    HILIGHT_WORD,	/* word from highlight word list */
    HILIGHT_NICK,	/* my nick was mentioned */
};


void silky_nickname_parse(const char *nickname, char **ret_nickname);

unsigned int get_random_number(const unsigned int min, const unsigned int max);

void * silky_get_active_textview ();

/*--> End of support.h */


#endif
