#include <gtk/gtk.h>
#include <glade/glade.h>

#include "silcincludes.h"
#include "silcclient.h"

#include "ui_channel.h"
#include "support.h"
#include "preferences.h"

#include "log.h"

/* this re-orders nicklist, using current GTK sort settings for this widget */
void refresh_gui_nicklist(SilkyChannel *channel) {
  GtkTreeView *treeview = GTK_TREE_VIEW(glade_xml_get_widget(channel->glade_xml, "nicktreeview"));
  GtkTreeModel *sorted_nicklist = gtk_tree_view_get_model(treeview);
  gint colid = 0;
  GtkSortType order;

  populate_gui_nicklist(channel);

  /* get current sort settings */
  if( !gtk_tree_sortable_get_sort_column_id( GTK_TREE_SORTABLE(sorted_nicklist), &colid, &order) ) {
    debug("Couldn't get sort column id and order of nicklist.");
    return;
  }

  debug("Re-ordering nicklist.");
  gtk_tree_sortable_set_sort_column_id( GTK_TREE_SORTABLE(sorted_nicklist), colid, order);

}

/* this reads channel->members linked list and populates GUI nicklist accordingly */
/* - we'll sort it later */
void populate_gui_nicklist(SilkyChannel *channel) {
  GtkTreeView *treeview = GTK_TREE_VIEW(glade_xml_get_widget(channel->glade_xml, "nicktreeview"));
  GtkTreeModel *sn = gtk_tree_view_get_model(treeview);
  GtkListStore *liststore = GTK_LIST_STORE(gtk_tree_model_sort_get_model(GTK_TREE_MODEL_SORT(sn)));
  GtkWidget *usercount_label = glade_xml_get_widget(channel->glade_xml, "channel_usercount");
  GtkTreeIter iter;
  SilkyChannelMember *ch;
  guint usercount = 0;

  /* first we clear the nicklist liststore... */
  gtk_list_store_clear(liststore);

  /* ...and now let's start filling it anew */
  for( ch = channel->members; ch; ch = ch->next ) {
    debug("Adding '%s' to nicklist.", CHMEMBER_NAME(ch));

    gtk_list_store_append(liststore, &iter);

    /* founder column */
    if( IS_CHANNEL_FOUNDER(ch) ) gtk_list_store_set(liststore, &iter, 0, "*", -1);

    /* if muted, let's use the same column, for founders cannot be muted */
    if( IS_CHANNEL_MUTED(ch) ) gtk_list_store_set(liststore, &iter, 0, "&", -1);

    /* chanop column */
    if( IS_CHANNEL_OP(ch) ) gtk_list_store_set(liststore, &iter, 1, "@", -1);

    /* nickname column */
    gtk_list_store_set(liststore, &iter, 2, CHMEMBER_NAME(ch), -1);

    /* clientid column (soon to be removed, redundant) */
    gtk_list_store_set(liststore, &iter, 3, ch->chuser->client->id, -1);

    usercount++;
  }

  gtk_label_set_text(GTK_LABEL(usercount_label), g_strdup_printf(ngettext("%d user", "%d users", usercount), usercount));
}

/*
  This sets the colors to the nicklist widget.
*/

void silky_colorize_nicklist (GtkWidget *treeview) {
  gchar *value;
  GdkColor gdkcolor;

  debug("colorizing");

  /* set BACKGROUND COLOR of the userlist */
  value = prefs_get("color_background");
  if (value && strlen(value) > 1 && strcmp("default", value) ) {
    gdk_color_parse(value, &gdkcolor); /* parse background color */
  } else {
    gdk_color_parse("#ffffff", &gdkcolor); /* set default bgcolor to white */
  }

  debug("setting channel nicklist's background color to '%s'", value);
  gtk_widget_modify_base(GTK_WIDGET(treeview), GTK_STATE_NORMAL, &gdkcolor); /* set color */

  /* set FOREGROUND COLOR of the userlist */
  value = prefs_get("color_server_messages");
  if (value && strlen(value) > 1 && strcmp("default", value) ) {
    gdk_color_parse(value, &gdkcolor); /* parse background color */
    debug("setting channel nicklist's foreground color to '%s'", value);

    gtk_widget_modify_text(GTK_WIDGET(treeview), GTK_STATE_NORMAL, &gdkcolor); /* set color */
  }

  return;
}
