#include <gtk/gtk.h>
#include <glade/glade.h>

#include "silcincludes.h"
#include "silcclient.h"

#include "buddylist.h"
#include "ui_buddylist.h"
#include "log.h"
#include "support.h" /* for CONNECTED/DISCONNECTED */
#include "config.h"

extern GladeXML *xmlmain;
extern SilkyBuddy *buddies; /* from buddylist.c */
extern silkyStruct *silky; /* from main.c */

/**
 * gui_set_up_buddylist_treeview
 *
 * This creates the treeview for the Buddy List window.
 *
 * @Returns: nothing
 **/
void gui_set_up_buddylist_treeview() {
  GtkWidget *treeview;
  GtkCellRenderer *renderer_text;
  GtkCellRenderer *renderer_pixbuf;
  GtkListStore *liststore;
  GtkTreeViewColumn *column;

  debug("creating buddy list treeview");

  liststore = gtk_list_store_new (
                          2,
			  G_TYPE_STRING,  /* nickname */
                          G_TYPE_STRING  /* fingerprint */
                          );
  treeview = glade_xml_get_widget(xmlmain, "buddylist_treeview");
  if (!treeview) {
    debug("can't find the treeview");
    return;
  }


  /* set the model for treeview, overwrites the old one if present */
  gtk_tree_view_set_model (GTK_TREE_VIEW(treeview), GTK_TREE_MODEL(liststore) );

  renderer_text = gtk_cell_renderer_text_new();
  renderer_pixbuf = gtk_cell_renderer_pixbuf_new();

  /* status info */
  column = gtk_tree_view_column_new();
  gtk_tree_view_column_pack_start(column, renderer_pixbuf, FALSE);
  gtk_tree_view_column_add_attribute(column, renderer_pixbuf, "stock-id", 0);

  /* nickname */
  gtk_tree_view_column_pack_start(column, renderer_text, FALSE);
  gtk_tree_view_column_add_attribute(column, renderer_text, "text", 1);
  gtk_tree_view_column_set_title(column, _("Buddy List") );

  //  column = gtk_tree_view_column_new_with_attributes (_("Nick"), renderer_text, "text", 1, NULL);

  gtk_tree_view_append_column (GTK_TREE_VIEW(treeview), column);
  // gtk_tree_view_set_search_column (GTK_TREE_VIEW(treeview), 0); /* set sortable column */
  //gtk_tree_view_column_set_sort_column_id(column,  0);

  debug("created");
}




/**
 * refresh_gui_buddylist:
 *
 * This refreshes the Buddy List window.
 *
 * @Returns: nothing
 **/
void refresh_gui_buddylist() {
  GtkListStore *liststore;
  SilkyBuddy *b;
  GtkTreeIter iter;

  debug("refreshing the buddy list UI");

  /* if no columns in the treeview found */
  if( !gtk_tree_view_get_column(GTK_TREE_VIEW(glade_xml_get_widget(xmlmain, "buddylist_treeview")), 0) ) {
    debug("buddy list treeview not initialized, initializing now");
    gui_set_up_buddylist_treeview();
  }

 liststore = GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(glade_xml_get_widget(xmlmain, "buddylist_treeview"))));

 /* clear the list */
 gtk_list_store_clear(liststore);


 /* append all buddies */
 for( b = buddies; b; b = b->next ) {
   debug("setting icon for '%s' (%s)", b->nickname, b->fingerprint);

   gtk_list_store_append(liststore, &iter); /* new line */

   if (!CONNECTED) {
     /* set unknown icon as we are not connected */
     gtk_list_store_set(liststore, &iter, 0, GTK_STOCK_DIALOG_QUESTION, -1); /* column 0, status image */
   } else {
     switch (b->mode) {

     case SILC_UMODE_DETACHED:
       gtk_list_store_set(liststore, &iter, 0, GTK_STOCK_DIALOG_WARNING, -1); /* column 0, status image */
       break;

     case SILC_UMODE_GONE:
       gtk_list_store_set(liststore, &iter, 0, GTK_STOCK_DIALOG_INFO, -1); /* column 0, status image */
       break;

     default:
       /* all other modes use the network icon */
       gtk_list_store_set(liststore, &iter, 0, GTK_STOCK_JUMP_TO, -1); /* column 0, status image */
       break;
     }
   }

   gtk_list_store_set(liststore, &iter, 1, b->nickname, -1); /* column 1, nickname */
 }

 debug("ready");
}



/**
 * on_buddylist_activate:
 * @widget: unused
 * @userdata: unused
 *
 * Refreshes and shows the "window_buddylist" widget.
 *
 * Returns: TRUE
 **/

gboolean on_buddylist_activate (GtkWidget *widget, gpointer userdata) {
  debug("showing buddylist");

  refresh_gui_buddylist();

  /* I18N This is a window title */
  gtk_window_set_title(GTK_WINDOW(glade_xml_get_widget (xmlmain, "window_buddylist")), g_strdup_printf("Silky v%s : %s ", SILKY_VERSION, _("Buddy List") ));

  gtk_widget_show(glade_xml_get_widget(xmlmain, "window_buddylist"));
  return TRUE;
}
