/**************************************************************************
 * star.hxx
 * Written by Durk Talsma. Originally started October 1997, for distribution  
 * with the FlightGear project. Version 2 was written in August and 
 * September 1998. This code is based upon algorithms and data kindly 
 * provided by Mr. Paul Schlyter. (pausch@saaf.se). 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * $Id: star.hxx,v 1.5 2006-03-08 18:16:08 mfranz Exp $
 **************************************************************************/
#ifndef _STAR_HXX_
#define _STAR_HXX_


#include <simgear/ephemeris/celestialBody.hxx>


class Star : public CelestialBody
{

private:

    double xs, ys;     // the sun's rectangular geocentric coordinates
    double ye, ze;     // the sun's rectangularequatorial rectangular geocentric coordinates
    double distance;   // the sun's distance to the earth

public:

    Star (double mjd);
    Star ();
    ~Star();
    void updatePosition(double mjd);
    double getM();
    double getw();
    double getxs();
    double getys();
    double getye();
    double getze();
    double getDistance();
};


inline double Star::getM()
{
  return M;
}

inline double Star::getw()
{
  return w;
}

inline double Star::getxs()
{
  return xs;
}

inline double Star::getys()
{
  return ys;
}

inline double Star::getye()
{
   return ye;
}

inline double Star::getze()
{
   return ze;
}

inline double Star::getDistance()
{
  return distance;
}


#endif // _STAR_HXX_














